/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.search.lucene;

import de.lwsystems.mailarchive.search.IFullSearchHit;
import de.lwsystems.mailarchive.search.ISearchHit;
import de.lwsystems.mailarchive.search.ISearchResult;
import de.lwsystems.mailarchive.search.lucene.LuceneFullSearchHit;
import de.lwsystems.mailarchive.search.lucene.LuceneSearchHit;
import de.lwsystems.mailarchive.utils.ArrayRangeIterator;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneSearchResult
implements ISearchResult {
    private ScoreDoc[] hits;
    private int overAll;
    private IndexSearcher isearcher;

    public LuceneSearchResult(ScoreDoc[] hits, int overAll, IndexSearcher isearcher) {
        this.hits = hits;
        this.isearcher = isearcher;
        this.overAll = overAll;
    }

    private <HIT extends ISearchHit> Iterable<HIT> getIterableHits(final int hitIndex, final int limit, final boolean full) {
        return new Iterable<HIT>(){

            @Override
            public Iterator<HIT> iterator() {
                return ArrayRangeIterator.buildIterator((Object[])LuceneSearchResult.this.hits, (int)hitIndex, (int)limit, new ScoreHitTransformer(full));
            }
        };
    }

    @Override
    public Iterable<ISearchHit> getHits(int hitIndex, int limit) {
        return this.getIterableHits(hitIndex, limit, false);
    }

    @Override
    public Iterable<IFullSearchHit> getFullHits(int hitIndex, int limit) {
        return this.getIterableHits(hitIndex, limit, true);
    }

    @Override
    public int getHitCount() {
        return this.hits.length;
    }

    @Override
    public Integer getOverallHitCount() {
        return this.overAll;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ScoreHitTransformer<HIT extends ISearchHit>
    implements ArrayRangeIterator.Transformer<ScoreDoc, HIT> {
        private boolean full;

        public ScoreHitTransformer(boolean full) {
            this.full = full;
        }

        public HIT transform(ScoreDoc scoreDoc) {
            try {
                if (!this.full) {
                    FieldSelector fds = new FieldSelector(){

                        public FieldSelectorResult accept(String fieldName) {
                            if (fieldName.equals("Date") || fieldName.equals("Subject") || fieldName.equals("From") || fieldName.equals("id") || fieldName.equals("To") || fieldName.equals("Cc") || fieldName.equals("Recipient") || fieldName.equals("hasAttachment")) {
                                return FieldSelectorResult.LOAD;
                            }
                            return FieldSelectorResult.NO_LOAD;
                        }
                    };
                    Document hitDoc = LuceneSearchResult.this.isearcher.doc(scoreDoc.doc, fds);
                    return (HIT)new LuceneSearchHit(hitDoc);
                }
                Document hitDoc = LuceneSearchResult.this.isearcher.doc(scoreDoc.doc);
                return (HIT)new LuceneFullSearchHit(hitDoc);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

