/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import de.lwsystems.mailarchive.archive.container.IContainer;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;

public class BennoSearcherManager {
    private static final Logger LOGGER = Logger.getLogger(BennoSearcherManager.class);
    private static BennoSearcherManager instance;
    private HashMap<String, IndexSearcher> searchers = new HashMap();
    private HashMap<String, Long> searcherTimes = new HashMap();
    private long cacheTTL;

    private BennoSearcherManager(long cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    public static BennoSearcherManager getInstance(long cacheTTL) {
        if (instance == null) {
            instance = new BennoSearcherManager(cacheTTL);
        }
        return instance;
    }

    public IndexSearcher getSearcher(IContainer container) {
        String containerName = container.getIdentifier();
        if (!this.searchers.containsKey(containerName)) {
            try {
                IndexReader ireader = IndexReader.open((Directory)container.getIndexPath());
                IndexSearcher isearcher = new IndexSearcher(ireader);
                this.searchers.put(containerName, isearcher);
                this.searcherTimes.put(containerName, new Date().getTime());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        if (new Date().getTime() - this.searcherTimes.get(containerName) > this.cacheTTL) {
            IndexSearcher isearcher = this.searchers.get(containerName);
            IndexReader ireader = isearcher.getIndexReader();
            try {
                IndexReader newIndexReader = IndexReader.openIfChanged((IndexReader)ireader);
                if (newIndexReader != null) {
                    isearcher.close();
                    ireader.close();
                    ireader = newIndexReader;
                    isearcher = new IndexSearcher(newIndexReader);
                    this.searchers.put(containerName, isearcher);
                    this.searcherTimes.put(containerName, new Date().getTime());
                    LOGGER.debug((Object)("Recreated indexSearcher for " + containerName));
                } else {
                    this.searcherTimes.put(containerName, new Date().getTime());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.searchers.get(container.getIdentifier());
    }
}

