/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Fieldable;
import org.json.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientResolver {
    List<Fieldable> toList = new ArrayList<Fieldable>();
    List<Fieldable> ccList = new ArrayList<Fieldable>();
    List<Fieldable> bccList = new ArrayList<Fieldable>();

    public RecipientResolver(Fieldable[] to, Fieldable[] cc, Fieldable[] recipients) {
        for (Fieldable toField : to) {
            this.toList.add(toField);
        }
        for (Fieldable ccField : cc) {
            this.ccList.add(ccField);
        }
        for (Fieldable recipientField : recipients) {
            boolean found = false;
            for (Fieldable toField : to) {
                if (!toField.stringValue().contains(recipientField.stringValue())) continue;
                found = true;
            }
            if (!found) {
                for (Fieldable ccField : cc) {
                    if (!ccField.stringValue().contains(recipientField.stringValue())) continue;
                    found = true;
                }
            }
            if (found) continue;
            this.bccList.add(recipientField);
        }
    }

    public String[] getToArray() {
        return this.toArray(this.toList);
    }

    private String[] toArray(List<Fieldable> list) {
        String[] array = new String[list.size()];
        int i = 0;
        for (Fieldable tmp : list) {
            array[i++] = tmp.stringValue();
        }
        return array;
    }

    public String[] getCcArray() {
        return this.toArray(this.ccList);
    }

    public String[] getBccArray() {
        return this.toArray(this.bccList);
    }

    public static JSONArray getJSONArrayFromString(String input) {
        JSONArray result = new JSONArray();
        if (input.isEmpty()) {
            return result;
        }
        for (String aktRecipient : input.split(", ")) {
            result.put((Object)aktRecipient);
        }
        return result;
    }
}

