/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.utils;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.parser.ParserException;
import de.lwsystems.mailarchive.rest.api.MailResult;
import de.lwsystems.mailarchive.rest.utils.JsonUtils;
import de.lwsystems.mailarchive.rest.utils.MimeUtils;
import de.proite.mailarchive.rest.tools.JsonBuilder;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.mail.MessagingException;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;

public class BennoMailResponse {
    private static final Logger LOGGER = LogManager.getLogger(BennoMailResponse.class);

    public static void buildRawResponse(HttpServletResponse response, boolean skipUtf8Recode, MailDocument myDoc) throws MessagingException, IOException {
        CharsetMatch cm = BennoMailResponse.detectCharset(myDoc);
        InputStream mailStream = myDoc.getMailStream();
        if (skipUtf8Recode) {
            IOUtils.copy((InputStream)mailStream, (OutputStream)response.getOutputStream());
        } else {
            InputStreamReader isr;
            if (cm != null) {
                try {
                    isr = new InputStreamReader(mailStream, cm.getName());
                }
                catch (UnsupportedEncodingException ex) {
                    isr = new InputStreamReader(mailStream);
                }
            } else {
                isr = new InputStreamReader(mailStream);
            }
            BufferedReader br = new BufferedReader(isr);
            while (br.ready()) {
                response.getWriter().println(br.readLine());
            }
        }
    }

    public static void buildHeadersOnlyJsonResponse(HttpServletResponse response, MailDocument myDoc) throws JSONException, IOException {
        Map<String, Object> result = JsonBuilder.createHeadersOnlyJsonDocument(myDoc);
        response.setContentType("application/json; charset=UTF-8");
        JsonUtils.write(result, response.getWriter());
    }

    public static MailResult buildFullJsonResponse(HttpServletResponse response, MailDocument myDoc) throws JSONException, IOException, MessagingException, ParserException {
        return JsonBuilder.createFullJsonDocument(myDoc);
    }

    public static CharsetMatch detectCharset(MailDocument myDoc) throws MessagingException, IOException {
        CharsetMatch cm;
        CharsetDetector cd = new CharsetDetector();
        MimeUtils.getMimeMesage(myDoc).getEncoding();
        cd.setText(myDoc.getMailStream());
        try {
            cm = cd.detect();
        }
        catch (Exception ex) {
            LOGGER.warn("Cannot detect charset: ", (Throwable)ex);
            cm = null;
        }
        return cm;
    }
}

