#!/bin/sh
# preinst script for benno-rest
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <new-preinst> `install'
#        * <new-preinst> `install' <old-version>
#        * <new-preinst> `upgrade' <old-version>
#        * <old-preinst> `abort-upgrade' <new-version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package



case "$1" in
    install|upgrade)
        [ -z "$REST_USER" ] && REST_USER=bennorest
        [ -z "$BENNO_GROUP" ] && BENNO_GROUP=benno
        if ! getent passwd | grep -q "^$REST_USER:"; then
            echo -n "Adding system user $REST_USER.."
            adduser --quiet --system --ingroup $BENNO_GROUP \
                --home /opt/benno --no-create-home \
                --disabled-password $REST_USER 2>/dev/null || true
            echo "..done"
        fi
    ;;

    abort-upgrade)
    ;;

    *)
        echo "preinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac
case "$1" in
    upgrade)
        #/etc/init.d/benno-rest stop
        systemctl stop benno-rest
    ;;
esac


# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.

# Automatically added by dh_installinit/13.11.4
if [ "$1" = "install" ] && [ -n "$2" ] && [ -e "/etc/init.d/benno-rest" ] ; then
	chmod +x "/etc/init.d/benno-rest" >/dev/null || true
fi
# End automatically added section


exit 0
