/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.QueryWrapperFilter;

public class BennoFilterManager {
    private static final Logger LOGGER = LogManager.getLogger(BennoFilterManager.class);
    private static BennoFilterManager instance;
    private HashMap<String, CachingWrapperFilter> filters = new HashMap();
    private QueryParser parser;

    private BennoFilterManager(QueryParser parser) {
        this.parser = parser;
    }

    public static BennoFilterManager getInstance(QueryParser parser) {
        if (instance == null) {
            instance = new BennoFilterManager(parser);
        }
        return instance;
    }

    public CachingWrapperFilter getFilter(String filterQuery) {
        if (!this.filters.containsKey(filterQuery)) {
            try {
                this.parser.setLowercaseExpandedTerms(false);
                QueryWrapperFilter filter = new QueryWrapperFilter(this.parser.parse(filterQuery));
                filter = new CachingWrapperFilter((Filter)filter);
                this.filters.put(filterQuery, (CachingWrapperFilter)filter);
                LOGGER.debug("Created a new Filter for filterQuery: " + filterQuery);
                LOGGER.debug("Created filter is:" + filter.toString());
                this.parser.setLowercaseExpandedTerms(true);
            }
            catch (ParseException pex) {
                LOGGER.warn("ParseException: " + pex);
                return null;
            }
        }
        return this.filters.get(filterQuery);
    }
}

