/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import de.lwsystems.mailarchive.rest.servlets.BennoSearchServlet;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Scorer;

public class MailboxCollector
extends Collector {
    private Scorer scorer;
    private final String sender = "Sender";
    private final String from = "From";
    private final String size = "Size";
    public Integer mailCount = 0;
    public Integer mailWarnings = 0;
    public Integer mailErrors = 0;
    IndexReader reader;
    private static final Logger LOGGER = LogManager.getLogger(BennoSearchServlet.class);
    Map<String, Integer> domainCount = new HashMap<String, Integer>();
    Map<String, Integer> addressCount = new HashMap<String, Integer>();
    Map<String, Long> mailDomainSize = new HashMap<String, Long>();
    Map<String, Long> mailAddressSize = new HashMap<String, Long>();
    long mailTotalSumSize = 0L;

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    public void collect(int doc) throws IOException {
        String localPart = "";
        String domainPart = "";
        String senderAddress = this.reader.document(doc).get("Sender");
        Long mailSize = Long.parseLong(this.reader.document(doc).get("Size"));
        LOGGER.debug("Analyze: " + senderAddress);
        Integer n = this.mailCount;
        this.mailCount = this.mailCount + 1;
        try {
            try {
                Object parts;
                if (senderAddress.contains("@")) {
                    parts = senderAddress.split("@");
                    localPart = parts[0];
                    domainPart = parts[1];
                } else {
                    localPart = senderAddress;
                    domainPart = "<not-set>";
                    parts = this.mailWarnings;
                    this.mailWarnings = this.mailWarnings + 1;
                    LOGGER.warn("Senderaddress without domain part \"" + this.reader.document(doc).get("Sender") + "\" (from " + this.reader.document(doc).get("id") + ")");
                }
            }
            catch (Exception ex) {
                LOGGER.error("Sender count error: " + senderAddress + ": " + ex);
            }
            if (this.addressCount.get(senderAddress) == null) {
                this.addressCount.put(senderAddress, 1);
                this.mailAddressSize.put(senderAddress, mailSize);
            } else {
                this.addressCount.put(senderAddress, this.addressCount.get(senderAddress) + 1);
                this.mailAddressSize.put(senderAddress, this.mailAddressSize.get(senderAddress) + mailSize);
            }
            if (this.domainCount.get(domainPart) == null) {
                this.domainCount.put(domainPart, 1);
                this.mailDomainSize.put(domainPart, mailSize);
            } else {
                this.domainCount.put(domainPart, this.domainCount.get(domainPart) + 1);
                this.mailDomainSize.put(domainPart, (long)this.domainCount.get(domainPart).intValue() + mailSize);
            }
            if (mailSize > 0L) {
                this.mailTotalSumSize += mailSize.longValue();
            }
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            LOGGER.error(ex + " " + senderAddress);
            Integer n2 = this.mailErrors;
            this.mailErrors = this.mailErrors + 1;
        }
        catch (NullPointerException ex) {
            LOGGER.error(ex + " " + senderAddress);
            Integer n3 = this.mailErrors;
            this.mailErrors = this.mailErrors + 1;
        }
        catch (Exception ex) {
            LOGGER.error(ex + " " + senderAddress);
            Integer n4 = this.mailErrors;
            this.mailErrors = this.mailErrors + 1;
        }
    }

    public void setNextReader(IndexReader reader, int docBase) throws IOException {
        this.reader = reader;
    }

    public boolean acceptsDocsOutOfOrder() {
        return false;
    }

    public Map<String, Integer> getDomainCount() {
        return Collections.unmodifiableMap(MailboxCollector.sortMapByValues(this.domainCount));
    }

    public Map<String, Integer> getAddressCount() {
        return Collections.unmodifiableMap(MailboxCollector.sortMapByValues(this.addressCount));
    }

    public Map<String, Long> getMailDomainSize() {
        return Collections.unmodifiableMap(this.mailDomainSize);
    }

    public Map<String, Long> getMailAddressSize() {
        return Collections.unmodifiableMap(this.mailAddressSize);
    }

    public Long getMailTotalSumSize() {
        return this.mailTotalSumSize;
    }

    private static Map<String, Integer> sortMapByValues(Map<String, Integer> aMap) {
        Set<Map.Entry<String, Integer>> mapEntries = aMap.entrySet();
        LinkedList<Map.Entry<String, Integer>> aList = new LinkedList<Map.Entry<String, Integer>>(mapEntries);
        Collections.sort(aList, new Comparator<Map.Entry<String, Integer>>(){

            @Override
            public int compare(Map.Entry<String, Integer> ele1, Map.Entry<String, Integer> ele2) {
                return ele2.getValue().compareTo(ele1.getValue());
            }
        });
        LinkedHashMap<String, Integer> aMap2 = new LinkedHashMap<String, Integer>();
        for (Map.Entry entry : aList) {
            aMap2.put((String)entry.getKey(), (Integer)entry.getValue());
        }
        return aMap2;
    }
}

