/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.utils.ILicense;
import de.proite.mailarchive.rest.tools.BennoLicenseInstance;
import de.proite.mailarchive.rest.tools.IBennoLicense;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.security.NoSuchAlgorithmException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class BennoLicenseServlet
extends HttpServlet {
    private static final Logger LOGGER = LogManager.getLogger(BennoLicenseServlet.class);
    private final BennoRest bennoRest;
    private final IBennoLicense bennoLicense;
    private final Benno benno;
    private final ILicense license;

    public BennoLicenseServlet(BennoRest bennoRest, Benno benno, ILicense license, IBennoLicense bennoLicense) {
        this.bennoRest = bennoRest;
        this.benno = benno;
        this.license = license;
        this.bennoLicense = bennoLicense;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.doProccess(request, response);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (ArchiveException e) {
            throw new RuntimeException(e);
        }
        catch (ContainerNotFoundException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.doProccess(request, response);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (ArchiveException e) {
            throw new RuntimeException(e);
        }
        catch (ContainerNotFoundException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doProccess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException, NoSuchAlgorithmException, ArchiveException, ContainerNotFoundException, InterruptedException {
        response.setStatus(200);
        response.setContentType("application/json; charset=UTF-8");
        JSONObject result = new JSONObject();
        BennoLicenseInstance bennoLicenseInstance = null;
        bennoLicenseInstance = BennoLicenseInstance.getInstance(this.benno);
        try {
            result.put("licenseExpires", (Object)this.bennoLicense.getLicenseExpires());
            result.put("licenseFile", (Object)this.license.getFile());
            result.put("licenseStatus", (Object)this.bennoLicense.getLicenseStatus());
            result.put("licenseType", (Object)this.license.getType());
            result.put("licenseInstanceId", (Object)bennoLicenseInstance.getInstanceId());
            result.put("myHostname", (Object)this.bennoRest.getMyHostname());
            result.put("myAddress", (Object)this.bennoRest.getMyAddress());
            result.put("mailDomain", (Object)this.bennoRest.getMaildomain());
            result.put("coreVersion", (Object)this.bennoRest.getCoreVersion());
            result.put("restVersion", (Object)this.bennoRest.getRestVersion());
            result.put("archiveCount", (Object)this.bennoRest.getNumberArchives());
            result.write((Writer)response.getWriter());
        }
        catch (Exception ex) {
            LOGGER.error("Uncaught Exception", (Throwable)ex);
        }
    }
}

