/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.rest.api.MultipartItem;
import de.lwsystems.mailarchive.rest.servlets.ServletTools;
import de.lwsystems.mailarchive.rest.utils.MimeUtils;
import de.lwsystems.mailarchive.search.IFullSearchHit;
import de.lwsystems.mailarchive.search.ISearchResult;
import de.lwsystems.mailarchive.search.NoSuchObjectException;
import de.lwsystems.mailarchive.utils.ILicense;
import de.lwsystems.mailarchive.utils.InitizalizationMail;
import de.lwsystems.mailarchive.utils.InstanceIdGenerationType;
import de.lwsystems.mailarchive.utils.License;
import de.lwsystems.mailarchive.utils.LicenseException;
import de.proite.mailarchive.rest.tools.BennoLicense;
import de.proite.mailarchive.rest.tools.BennoLicenseInstance;
import de.proite.mailarchive.rest.tools.IBennoLicense;
import de.proite.mailarchive.rest.tools.JsonBuilder;
import de.proite.mailarchive.rest.tools.LuceneIndexSearch;
import de.proite.mailarchive.rest.tools.MimePartResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Optional;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BennoLicenseMail {
    private static final Logger LOGGER = LogManager.getLogger(BennoLicenseMail.class);
    private final String searchHostHeader = "X-BENNO-Host-Info";
    private final String searchInstanceIdHeader = "X-BENNO-Instance-ID";
    private final String searchContainer = "SYSDATA";
    private ILicense bennoLicense;
    private IBennoLicense bennoLicenseRest;
    String instanceId = "";
    private boolean valid = false;

    public BennoLicenseMail(Benno benno) throws MessagingException, ArchiveException, ContainerNotFoundException, IOException, NoSuchAlgorithmException {
        this.getLicenseMail(benno);
    }

    public boolean isLicenseValid() {
        return this.valid;
    }

    private void getLicenseMail(Benno benno) throws ArchiveException, ContainerNotFoundException, IOException, MessagingException, NoSuchAlgorithmException {
        IContainer myContainer = null;
        myContainer = ServletTools.getContainer("SYSDATA", benno);
        try {
            Iterable<IFullSearchHit> hits = this.searchLicenseMail(benno).getFullHits(0, 1000000);
            this.findLicenseFile(hits, myContainer, benno);
        }
        catch (NoSuchObjectException nso) {
            this.bennoLicenseRest = null;
            this.bennoLicense = null;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private ISearchResult searchLicenseMail(Benno benno) throws NoSuchObjectException, ContainerNotFoundException {
        LuceneIndexSearch luceneIndexSearch = new LuceneIndexSearch(benno, "SYSDATA");
        ISearchResult result = null;
        try {
            result = luceneIndexSearch.searchInIndex("License mail", "SortableDate", "Sender:*@*", "(From:*@* To:*@* Recipient:*@* Sender:*@*)", 0, true);
            if (result.getHitCount() < 1) {
                InitizalizationMail.createInitializationMailMessage((Benno)benno);
            }
        }
        catch (Exception ex) {
            InitizalizationMail.createInitializationMailMessage((Benno)benno);
        }
        return result;
    }

    private void findLicenseFile(Iterable<IFullSearchHit> hits, IContainer myContainer, Benno benno) throws IOException, ArchiveException, MessagingException, NoSuchAlgorithmException, ContainerNotFoundException, InterruptedException {
        InetAddress iaddr = InetAddress.getLocalHost();
        String hostname = iaddr.getHostAddress() + "/" + iaddr.getCanonicalHostName();
        BennoLicenseInstance bennoLicenseInstance = BennoLicenseInstance.getInstance(benno);
        block4: for (IFullSearchHit hit : hits) {
            Header[] ausgabe;
            if (this.valid) break;
            MailDocumentId documentId = new MailDocumentId(hit.getId(), "");
            IBox box = myContainer.getBox(documentId.getInternalBoxIndentifier());
            Optional<MailDocument> opMyDoc = Optional.ofNullable(box.getDocument(documentId));
            if (!opMyDoc.isPresent()) continue;
            MailDocument myDoc = opMyDoc.get();
            for (Header header : ausgabe = myDoc.getMetaData().getHeaders()) {
                if (!header.getName().equalsIgnoreCase("X-BENNO-Host-Info") && !header.getName().equalsIgnoreCase("X-BENNO-Instance-ID")) continue;
                try {
                    MimeMultipart multipart = null;
                    ArrayList<MultipartItem> attachmentList = new ArrayList<MultipartItem>();
                    ArrayList<MultipartItem> bodyList = new ArrayList<MultipartItem>();
                    if (!MimeUtils.getMimeMesage(myDoc).getContent().getClass().equals(String.class)) {
                        multipart = JsonBuilder.buildMimeMultipart(myDoc, multipart, attachmentList);
                    }
                    if (multipart != null) {
                        MimePartResolver.resolveMimeParts(multipart, attachmentList, bodyList, 0);
                    }
                    ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>();
                    MimePartResolver.getBodyPartList(multipart, bodyParts);
                    InputStream mailLicenseStream = bodyParts.get(1).getInputStream();
                    this.bennoLicense = new License(mailLicenseStream, hit.getId());
                    if (header.getName().equalsIgnoreCase("X-BENNO-Instance-ID")) {
                        for (InstanceIdGenerationType idGenerationType : InstanceIdGenerationType.values()) {
                            try {
                                this.valid = this.bennoLicense.checkValid(bennoLicenseInstance.getInstanceId(idGenerationType), hostname, iaddr.getHostAddress());
                            }
                            catch (LicenseException ex) {
                                LOGGER.debug("License mail is not valid " + hit.getId());
                            }
                            if (!this.valid) continue;
                            LOGGER.debug("License mail is valid " + hit.getId());
                            bennoLicenseInstance.setInstanceIdGenerationFromType(idGenerationType);
                            break;
                        }
                        if (!this.valid) {
                            this.valid = this.bennoLicense.checkValid(hostname, iaddr.getHostAddress());
                        }
                    } else if (header.getName().equalsIgnoreCase("X-BENNO-Host-Info")) {
                        this.valid = this.bennoLicense.checkValid(hostname, iaddr.getHostAddress());
                    }
                    this.valid = this.bennoLicense.checkBuild();
                    if (!this.valid) continue;
                    this.bennoLicenseRest = new BennoLicense(bodyParts.get(1).getInputStream(), hit.getId(), benno);
                    continue block4;
                }
                catch (LicenseException ex) {
                    this.valid = false;
                }
            }
        }
    }

    public IBennoLicense getBennoLicenseRest() {
        return this.bennoLicenseRest;
    }

    public ILicense getBennoLicense() {
        return this.bennoLicense;
    }
}

