/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import de.lwsystems.mailarchive.rest.api.MultipartItem;
import de.lwsystems.mailarchive.rest.utils.FilenameSuffixChecker;
import de.lwsystems.mailarchive.utils.UniversalAttachmentExtractor;
import de.proite.mailarchive.rest.tools.ContentType;
import de.proite.mailarchive.rest.tools.MailAttachment;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.SharedByteArrayInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MimePartResolver {
    private static final Logger LOGGER = LogManager.getLogger(MimePartResolver.class);
    private static int attachmentCounter = 0;

    public static void resolveMimeParts(MimeMultipart mm, List<MultipartItem> attachments, List<MultipartItem> bodies, int attachmentCounter) throws MessagingException, IOException {
        int[] bodyPartCount = new int[]{0, 0};
        MimePartResolver.resolveMimeParts(mm, attachments, bodies, bodyPartCount, attachmentCounter);
    }

    public static void resolveMimeParts(MimeMultipart mm, List<MultipartItem> attachments, List<MultipartItem> bodies, int[] bodyPartCount, int aCounter) throws MessagingException, IOException {
        attachmentCounter = aCounter;
        block14: for (int i = 0; i < mm.getCount(); ++i) {
            BodyPart bp = mm.getBodyPart(i);
            boolean isMultiPart = false;
            try {
                if (bp.getContentType().toLowerCase().contains("multipart/signed")) continue;
                if (bp.getContentType().toLowerCase().contains("multipart/")) {
                    isMultiPart = true;
                }
            }
            catch (MessagingException ex) {
                isMultiPart = false;
                bp.setHeader("Content-Type", ContentType.bareType(bp));
                LOGGER.info("Missing start boundary in mailfile");
            }
            if (isMultiPart) {
                MimePartResolver.resolveMimeParts((MimeMultipart)bp.getContent(), attachments, bodies, attachmentCounter);
                continue;
            }
            MultipartItem file = new MultipartItem();
            String fileName = UniversalAttachmentExtractor.extractFilename((BodyPart)bp);
            if (fileName != null && !fileName.isEmpty()) {
                MailAttachment tmpAttachment = new MailAttachment(bp);
                file.setContentType(tmpAttachment.getContentType());
                if (tmpAttachment.getFilename() == null) {
                    file.setName(fileName);
                } else {
                    file.setName(tmpAttachment.getFilename());
                }
                file.setContentType(ContentType.bareType(bp));
                try {
                    if (bp.getDisposition() != null) {
                        file.setContentDisposition(bp.getDisposition());
                    }
                }
                catch (MessagingException ex) {
                    file.setContentDisposition("attachment");
                }
                file.setSize(tmpAttachment.getSize());
                file.setAttachmentId(attachmentCounter);
                attachments.add(file);
                ++attachmentCounter;
                continue;
            }
            file.setContentType(ContentType.bareType(bp));
            try {
                if (bp.getDisposition() != null) {
                    file.setContentDisposition(bp.getDisposition());
                }
            }
            catch (MessagingException ex) {
                file.setContentDisposition("attachment");
            }
            if (bp.getDisposition() == null || bp.getDisposition().contains("inline")) {
                file.setData(MimePartResolver.decodeContent(bp));
            }
            switch (ContentType.bareType(bp).toLowerCase()) {
                case "text/plain": {
                    int n = bodyPartCount[0];
                    bodyPartCount[0] = n + 1;
                    if (n < 1) {
                        bodies.add(file);
                        continue block14;
                    }
                    attachments.add(file);
                    continue block14;
                }
                case "text/html": {
                    int n = bodyPartCount[1];
                    bodyPartCount[1] = n + 1;
                    if (n < 1) {
                        bodies.add(file);
                        continue block14;
                    }
                    attachments.add(file);
                    continue block14;
                }
                default: {
                    file.setSize(file.getData().length());
                    attachments.add(file);
                }
            }
        }
    }

    public static String decodeContent(BodyPart bp) {
        String returnContent;
        try {
            Object content = bp.getContent();
            if (content instanceof BASE64DecoderStream) {
                BASE64DecoderStream contentBase64DecoderStream = (BASE64DecoderStream)content;
                ByteArrayOutputStream contentOutputStream = new ByteArrayOutputStream();
                BASE64EncoderStream base64Stream = new BASE64EncoderStream((OutputStream)contentOutputStream);
                contentBase64DecoderStream.transferTo((OutputStream)base64Stream);
                returnContent = contentOutputStream.toString();
            } else if (content instanceof SharedByteArrayInputStream) {
                SharedByteArrayInputStream contentStream = (SharedByteArrayInputStream)content;
                int contentLength = contentStream.available();
                byte[] contentBytes = new byte[contentLength];
                contentStream.read(contentBytes, 0, contentLength);
                returnContent = new String(contentBytes, StandardCharsets.UTF_8);
            } else {
                returnContent = content.toString();
            }
        }
        catch (Exception ex) {
            LOGGER.fatal("Error decode body content: ", (Throwable)ex);
            returnContent = "";
        }
        return returnContent;
    }

    public static void getInlineAttachment(MimeMultipart mm, HashMap<String, String> base64Value) throws MessagingException, IOException {
        boolean isMultiPart = false;
        for (int i = 0; i < mm.getCount(); ++i) {
            String fileName;
            BodyPart bp = mm.getBodyPart(i);
            try {
                if (bp.getContentType().toLowerCase().contains("multipart/")) {
                    isMultiPart = true;
                }
            }
            catch (MessagingException ex) {
                isMultiPart = false;
                bp.setHeader("Content-Type", ContentType.bareType(bp));
                LOGGER.info("Detected unsupported charset in Content-Type-Header. Force Content-Type to: " + ContentType.bareType(bp));
            }
            if (isMultiPart) {
                try {
                    MimePartResolver.getInlineAttachment((MimeMultipart)bp.getContent(), base64Value);
                }
                catch (Exception e) {
                    isMultiPart = false;
                }
            }
            if (isMultiPart) continue;
            try {
                fileName = bp.getHeader("Content-ID")[0];
            }
            catch (NullPointerException es) {
                try {
                    fileName = bp.getHeader("Content-Id")[0];
                }
                catch (NullPointerException ex) {
                    fileName = "empty";
                }
            }
            if (fileName.contains("empty")) continue;
            fileName = fileName.replaceAll("[<>]", "");
            base64Value.put(fileName, MimePartResolver.decodeContent(bp).replaceAll("\\r\\n", ""));
        }
    }

    public static List<MultipartItem> convertInlineImageToBase64(MimeMultipart mimePart, List<MultipartItem> body) throws MessagingException, IOException {
        Integer counter = 0;
        for (MultipartItem bodyPart : body) {
            Pattern pattern = Pattern.compile("<img\\b[^>]*src\\s*=\\s*\"(cid[^\"]*)\"[^>]*>");
            String bodyData = bodyPart.getData().replaceAll("\r?\n", "");
            Matcher matcher = pattern.matcher(bodyData);
            HashMap<String, String> base64Value = new HashMap<String, String>();
            MimePartResolver.getInlineAttachment(mimePart, base64Value);
            matcher.matches();
            while (matcher.find()) {
                if (!matcher.group(1).contains("cid:")) continue;
                try {
                    if (!base64Value.containsKey(matcher.group(1).substring(4))) continue;
                    String base64Data = "data:image/png;base64," + base64Value.get(matcher.group(1).substring(4));
                    bodyData = bodyData.replace(matcher.group(1), base64Data);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Convert inline image \"" + matcher.group(1).substring(4) + "\"");
                    }
                    body.get(counter).setData(bodyData);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
            }
            Integer n = counter;
            counter = counter + 1;
        }
        return body;
    }

    public static String setNameToUnknownFile(BodyPart bp, Integer fileNumber, String contentId) {
        if ((contentId = contentId.replaceAll("[<>]", "")).matches("[\\w,\\s-]+\\.[A-Za-z]{3,}")) {
            return contentId;
        }
        if (ContentType.bareType(bp).toString().equals("message/rfc822")) {
            return "ForwardedMail_" + fileNumber + ".eml";
        }
        if (ContentType.bareType(bp).toString().equals("image/png")) {
            if (contentId.equals("empty")) {
                return "image_" + fileNumber + ".png";
            }
            return FilenameSuffixChecker.ensureSuffix(contentId, "png");
        }
        if (ContentType.bareType(bp).toString().equals("image/jpeg") || ContentType.bareType(bp).toString().equals("image/jpg")) {
            if (contentId.equals("empty")) {
                return "image_" + fileNumber + ".jpeg";
            }
            return FilenameSuffixChecker.ensureSuffix(contentId, "jpeg");
        }
        if (ContentType.bareType(bp).toString().equals("image/tiff")) {
            if (contentId.equals("empty")) {
                return "image_" + fileNumber + ".tiff";
            }
            return FilenameSuffixChecker.ensureSuffix(contentId, "tiff");
        }
        if (ContentType.bareType(bp).toString().equals("image/gif")) {
            if (contentId.equals("empty")) {
                return "image_" + fileNumber + ".gif";
            }
            return FilenameSuffixChecker.ensureSuffix(contentId, "gif");
        }
        if (ContentType.bareType(bp).toString().equals("text/calendar")) {
            MailAttachment mailAttachment = new MailAttachment();
            return mailAttachment.identifyFilename(contentId);
        }
        return contentId;
    }

    public static void getBodyPartList(MimeMultipart mm, ArrayList<BodyPart> bodyParts) throws MessagingException, IOException {
        ArrayList bodyPart = new ArrayList();
        for (int i = 0; i < mm.getCount(); ++i) {
            BodyPart bp = mm.getBodyPart(i);
            boolean isMultiPart = false;
            if (bp.getContentType().toLowerCase().contains("multipart/")) {
                isMultiPart = true;
            }
            if (isMultiPart) {
                try {
                    MimePartResolver.getBodyPartList((MimeMultipart)bp.getContent(), bodyParts);
                }
                catch (MessagingException ex) {
                    isMultiPart = false;
                }
                continue;
            }
            bodyParts.add(bp);
        }
    }
}

