/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.api;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.lwsystems.mailarchive.journal.ChecksumEntry;
import de.lwsystems.mailarchive.journal.JournalChecksumResult;
import de.lwsystems.mailarchive.journal.ProcessingError;
import java.util.List;
import java.util.stream.Collectors;

public class JournalChecksumsResponse {
    @JsonProperty(value="checksums")
    private List<ChecksumEntryDTO> checksums;
    @JsonProperty(value="container")
    private String container;
    @JsonProperty(value="count")
    private int count;
    @JsonProperty(value="startChecksum")
    private String startChecksum;
    @JsonProperty(value="endChecksum")
    private String endChecksum;
    @JsonProperty(value="totalCount")
    private Integer totalCount;
    @JsonProperty(value="truncated")
    private Boolean truncated;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="processingTimeMillis")
    private Long processingTimeMillis;
    @JsonProperty(value="offset")
    private Integer offset;
    @JsonProperty(value="limit")
    private Integer limit;
    @JsonProperty(value="hasMore")
    private Boolean hasMore;
    @JsonProperty(value="errors")
    private List<ProcessingErrorDTO> errors;

    public JournalChecksumsResponse() {
    }

    public JournalChecksumsResponse(JournalChecksumResult result, String container, String startChecksum, String endChecksum) {
        this.checksums = result.checksums().stream().map(ChecksumEntryDTO::from).collect(Collectors.toList());
        this.container = container;
        this.count = result.checksums().size();
        this.startChecksum = startChecksum;
        this.endChecksum = endChecksum;
        this.totalCount = result.totalCount();
        this.truncated = result.truncated();
        this.message = result.message();
        this.processingTimeMillis = result.processingTimeMillis();
        if (result.hasErrors()) {
            this.errors = result.errors().stream().map(ProcessingErrorDTO::from).collect(Collectors.toList());
        }
    }

    public JournalChecksumsResponse(JournalChecksumResult result, String container, String startChecksum, String endChecksum, int offset, int limit) {
        this(result, container, startChecksum, endChecksum);
        this.offset = offset;
        this.limit = limit;
        this.hasMore = offset + limit < result.totalCount();
    }

    public List<ChecksumEntryDTO> getChecksums() {
        return this.checksums;
    }

    public void setChecksums(List<ChecksumEntryDTO> checksums) {
        this.checksums = checksums;
        this.count = checksums != null ? checksums.size() : 0;
    }

    public String getContainer() {
        return this.container;
    }

    public void setContainer(String container) {
        this.container = container;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public String getStartChecksum() {
        return this.startChecksum;
    }

    public void setStartChecksum(String startChecksum) {
        this.startChecksum = startChecksum;
    }

    public String getEndChecksum() {
        return this.endChecksum;
    }

    public void setEndChecksum(String endChecksum) {
        this.endChecksum = endChecksum;
    }

    public Integer getTotalCount() {
        return this.totalCount;
    }

    public void setTotalCount(Integer totalCount) {
        this.totalCount = totalCount;
    }

    public Boolean getTruncated() {
        return this.truncated;
    }

    public void setTruncated(Boolean truncated) {
        this.truncated = truncated;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Long getProcessingTimeMillis() {
        return this.processingTimeMillis;
    }

    public void setProcessingTimeMillis(Long processingTimeMillis) {
        this.processingTimeMillis = processingTimeMillis;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Boolean getHasMore() {
        return this.hasMore;
    }

    public void setHasMore(Boolean hasMore) {
        this.hasMore = hasMore;
    }

    public List<ProcessingErrorDTO> getErrors() {
        return this.errors;
    }

    public void setErrors(List<ProcessingErrorDTO> errors) {
        this.errors = errors;
    }

    public static class ProcessingErrorDTO {
        @JsonProperty(value="file")
        private String file;
        @JsonProperty(value="error")
        private String error;

        public ProcessingErrorDTO() {
        }

        public ProcessingErrorDTO(String file, String error) {
            this.file = file;
            this.error = error;
        }

        public static ProcessingErrorDTO from(ProcessingError error) {
            return new ProcessingErrorDTO(error.getFile(), error.getError());
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getError() {
            return this.error;
        }

        public void setError(String error) {
            this.error = error;
        }
    }

    public static class ChecksumEntryDTO {
        @JsonProperty(value="checksum")
        private String checksum;
        @JsonProperty(value="yearBox")
        private String yearBox;

        public ChecksumEntryDTO() {
        }

        public ChecksumEntryDTO(String checksum, String yearBox) {
            this.checksum = checksum;
            this.yearBox = yearBox;
        }

        public static ChecksumEntryDTO from(ChecksumEntry entry) {
            return new ChecksumEntryDTO(entry.checksum(), entry.yearBox());
        }

        public String getChecksum() {
            return this.checksum;
        }

        public void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public String getYearBox() {
            return this.yearBox;
        }

        public void setYearBox(String yearBox) {
            this.yearBox = yearBox;
        }
    }
}

