/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.backup.service.ArchiveFormat;
import de.lwsystems.mailarchive.backup.service.BackupArchiveService;
import de.lwsystems.mailarchive.backup.service.BackupArchiveStreamWriter;
import de.lwsystems.mailarchive.backup.service.BackupFormat;
import de.lwsystems.mailarchive.journal.JournalProcessingException;
import de.lwsystems.mailarchive.rest.utils.BennoHttpSessionUtils;
import de.proite.mailarchive.rest.tools.IpAddressExtractor;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseBackupServlet
extends HttpServlet {
    private static final Logger LOGGER = LogManager.getLogger(BaseBackupServlet.class);
    protected final Benno benno;
    protected final IpAddressExtractor ipAddressExtractor;
    protected final BackupArchiveService backupArchiveService;

    protected BaseBackupServlet(Benno benno, IpAddressExtractor ipAddressExtractor) {
        this.benno = benno;
        this.ipAddressExtractor = ipAddressExtractor;
        this.backupArchiveService = new BackupArchiveService();
    }

    protected static boolean parseIncludeHeader(String headerParam) {
        if (headerParam == null) {
            return true;
        }
        return "true".equalsIgnoreCase(headerParam) || "1".equals(headerParam);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void withArchiveOutputStream(HttpServletResponse response, ArchiveFormat archiveFormat, ArchiveStreamHandler handler) throws IOException, JournalProcessingException {
        ServletOutputStream servletOut = response.getOutputStream();
        BufferedOutputStream buffered = new BufferedOutputStream((OutputStream)servletOut);
        BackupArchiveStreamWriter writer = archiveFormat.createWriter((OutputStream)buffered);
        boolean success = false;
        try {
            handler.handle(writer);
            success = true;
        }
        finally {
            if (success) {
                writer.close();
            }
        }
    }

    protected void writeError(HttpServletResponse response, int status, String error, String message) {
        try {
            response.reset();
            response.setStatus(status);
            response.setContentType("application/json; charset=UTF-8");
            response.getWriter().write(String.format(Locale.ROOT, "{\"error\":\"%s\",\"message\":\"%s\"}", error, message));
        }
        catch (IllegalStateException e) {
            LOGGER.warn("Cannot write error response - response already committed: {}", (Object)e.getMessage());
        }
        catch (IOException e) {
            LOGGER.warn("Failed to write error response: {}", (Object)e.getMessage());
        }
    }

    protected void setArchiveResponseHeaders(HttpServletResponse response, String filePrefix, String containerName, ArchiveFormat archiveFormat) {
        response.setStatus(200);
        response.setContentType(archiveFormat.contentType());
        String timestamp = new SimpleDateFormat("yyyyMMdd-HHmmss", Locale.ROOT).format(new Date());
        response.setHeader("Content-Disposition", String.format("attachment; filename=%s-%s-%s%s", filePrefix, containerName, timestamp, archiveFormat.fileExtension()));
    }

    protected IContainer getContainerOrSendError(HttpServletResponse response, HttpSession session, String containerName, String cacheKeyPrefix) {
        try {
            return BennoHttpSessionUtils.getContainer(session, containerName, this.benno, cacheKeyPrefix);
        }
        catch (ContainerNotFoundException e) {
            LOGGER.warn("Container not found: {}", (Object)containerName);
            this.writeError(response, 404, "container_not_found", "Container '" + containerName + "' not found");
            return null;
        }
    }

    protected boolean validateContainerParameter(HttpServletResponse response, String containerName) {
        if (containerName == null || containerName.trim().isEmpty()) {
            this.writeError(response, 400, "missing_parameter", "Container parameter is required");
            return false;
        }
        return true;
    }

    @FunctionalInterface
    protected static interface ArchiveStreamHandler {
        public void handle(BackupArchiveStreamWriter var1) throws IOException, JournalProcessingException;
    }

    protected static class BackupParams {
        final String containerName;
        final boolean includeBennoHeader;
        final BackupFormat format;
        final ArchiveFormat archiveFormat;

        protected BackupParams(String containerName, String headerParam, String formatParam, String archiveFormatParam) {
            this.containerName = containerName;
            this.includeBennoHeader = BaseBackupServlet.parseIncludeHeader(headerParam);
            this.format = BackupFormat.fromParam((String)formatParam);
            this.archiveFormat = ArchiveFormat.fromParam((String)archiveFormatParam);
        }
    }
}

