/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.rest.api.MultipartItem;
import de.lwsystems.mailarchive.rest.api.SearchError;
import de.lwsystems.mailarchive.rest.utils.BennoHttpSessionUtils;
import de.lwsystems.mailarchive.rest.utils.JsonUtils;
import de.lwsystems.mailarchive.rest.utils.MimeUtils;
import de.lwsystems.mailarchive.rest.utils.ScidUtils;
import de.lwsystems.mailarchive.utils.UniversalAttachmentExtractor;
import de.proite.mailarchive.rest.tools.ContentType;
import de.proite.mailarchive.rest.tools.JsonBuilder;
import de.proite.mailarchive.rest.tools.MimePartResolver;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;

public class BennoAttachmentServlet
extends HttpServlet {
    private static final Logger LOGGER = LogManager.getLogger(BennoAttachmentServlet.class);
    private final BennoRest bennoRest;
    private final Benno benno;

    public BennoAttachmentServlet(BennoRest bennoRest, Benno benno) {
        this.bennoRest = bennoRest;
        this.benno = benno;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doProccess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doProccess(request, response);
    }

    private void doProccess(HttpServletRequest request, HttpServletResponse response) {
        block34: {
            response.setContentType("application/json; charset=UTF-8");
            HttpSession session = request.getSession();
            String searchArchive = request.getParameter("archive");
            String searchId = request.getParameter("id");
            String attachment = request.getParameter("attachment");
            String searchSCID = "";
            if (request.getParameter("scid") != null) {
                searchSCID = request.getParameter("scid");
            }
            Integer attachmentId = null;
            if (request.getParameterMap().containsKey("attachmentId")) {
                attachmentId = Integer.parseInt(request.getParameter("attachmentId"));
            }
            try {
                int bytesRead;
                IContainer myContainer = null;
                if (!BennoHttpSessionUtils.existsContainerSession(session, searchArchive, "myContainer")) {
                    session.setAttribute("lastQuery", null);
                }
                if ((myContainer = BennoHttpSessionUtils.getContainer(session, searchArchive, this.benno, "myContainer")).isScidActive() && (!ScidUtils.isScidQueryValid(searchSCID) || searchSCID.equals(""))) {
                    throw new FileNotFoundException("SCID is active. Please add a correct SCID parameter to your query");
                }
                MailDocumentId documentId = new MailDocumentId(searchId, searchSCID);
                MailDocument myDoc = myContainer.getBox(documentId.getInternalBoxIndentifier()).getDocument(documentId);
                if (myDoc == null) {
                    throw new FileNotFoundException("Mail with id '" + searchId + "' not found!");
                }
                if (!myContainer.isScidActive() && !myDoc.getMetaData().getScid().equals("")) {
                    throw new FileNotFoundException("SCID is not active but the mail has a SCID parameter. Please active SCID in benno.xml");
                }
                MimeMultipart multipart = null;
                ArrayList<MultipartItem> attachmentList = new ArrayList<MultipartItem>();
                ArrayList<MultipartItem> bodyList = new ArrayList<MultipartItem>();
                if (!MimeUtils.getMimeMesage(myDoc).getContent().getClass().equals(String.class)) {
                    multipart = JsonBuilder.buildMimeMultipart(myDoc, multipart, attachmentList);
                }
                if (multipart != null) {
                    MimePartResolver.resolveMimeParts(multipart, attachmentList, bodyList, 0);
                }
                boolean found = false;
                for (MultipartItem tmp : attachmentList) {
                    try {
                        if (tmp.getAttachmentId().equals(attachmentId)) {
                            found = true;
                            continue;
                        }
                        if (!tmp.getName().equals(attachment)) continue;
                        found = true;
                    }
                    catch (JSONException ex) {
                        LOGGER.debug("MIME part without filename");
                    }
                    catch (NullPointerException ex) {
                        LOGGER.debug("MIME part is broken");
                    }
                }
                if (!found) {
                    response.resetBuffer();
                    response.setStatus(404);
                    try {
                        SearchError errResult = new SearchError();
                        errResult.setError("attachment not found");
                        JsonUtils.write(errResult, response.getWriter());
                        response.flushBuffer();
                    }
                    catch (Exception ex) {
                        LOGGER.fatal("Uncaught Excpetion", (Throwable)ex);
                    }
                }
                LOGGER.debug((Object)multipart);
                if (multipart != null) {
                    ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>();
                    MimePartResolver.getBodyPartList(multipart, bodyParts);
                    String fileName = "";
                    int attachmentCounter = 0;
                    for (BodyPart bodyPart : bodyParts) {
                        int bytesRead2;
                        try {
                            fileName = UniversalAttachmentExtractor.extractFilename((BodyPart)bodyPart);
                            if (fileName != null && !fileName.equals("") || bodyPart.getFileName() != null && !bodyPart.getFileName().equals("") && attachmentId != null) {
                                if (!attachmentId.equals(attachmentCounter)) {
                                    ++attachmentCounter;
                                }
                            } else {
                                if (bodyPart.getFileName() == null || bodyPart.getFileName().equals("") || bodyPart.getFileName() != null && !bodyPart.getFileName().equalsIgnoreCase(attachment)) continue;
                                if (bodyPart.getDisposition() == null) {
                                }
                            }
                        }
                        catch (Exception ex) {}
                        continue;
                        LOGGER.debug("{} Requested attachment '{}' for mail id '{}' - multipart: yes", (Object)request.getSession().getId(), (Object)attachment, (Object)searchId);
                        response.resetBuffer();
                        response.setContentType(bodyPart.getContentType());
                        response.addHeader("Content-Disposition", "attachment; filename=" + attachment);
                        InputStream is = bodyPart.getInputStream();
                        byte[] buf = new byte[4096];
                        while ((bytesRead2 = is.read(buf)) != -1) {
                            response.getOutputStream().write(buf, 0, bytesRead2);
                        }
                        ++attachmentCounter;
                    }
                    break block34;
                }
                LOGGER.debug("{} Requested attachment '{}' for mail id '{}' - multipart: no", (Object)request.getSession().getId(), (Object)attachment, (Object)searchId);
                response.resetBuffer();
                String ct = ContentType.bareType(MimeUtils.getMimeMesage(myDoc).getContentType());
                response.setContentType(ct);
                response.addHeader("Content-Disposition", "attachment; filename=" + attachment);
                InputStream is = MimeUtils.getMimeMesage(myDoc).getInputStream();
                byte[] buf = new byte[4096];
                while ((bytesRead = is.read(buf)) != -1) {
                    response.getOutputStream().write(buf, 0, bytesRead);
                }
            }
            catch (ContainerNotFoundException ex) {
                try {
                    SearchError errResult = new SearchError();
                    errResult.setError("container not found");
                    JsonUtils.write(errResult, response.getWriter());
                }
                catch (Exception iex) {
                    LOGGER.fatal("Uncaught Excpetion", (Throwable)iex);
                }
                LOGGER.warn(ex.getMessage());
            }
            catch (FileNotFoundException fnfe) {
                LOGGER.debug("File for ID '" + searchId + "' not found! Continer:" + searchArchive, (Throwable)fnfe);
                response.resetBuffer();
                response.setStatus(404);
                try {
                    SearchError errResult = new SearchError();
                    errResult.setError("file not found");
                    JsonUtils.write(errResult, response.getWriter());
                }
                catch (Exception ex) {
                    LOGGER.fatal("Uncaught Excpetion", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                LOGGER.fatal("Uncaught Excpetion", (Throwable)ex);
            }
        }
    }
}

