/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.backup.ChecksumListIterator;
import de.lwsystems.mailarchive.journal.ChecksumBoundary;
import de.lwsystems.mailarchive.journal.ChecksumEntry;
import de.lwsystems.mailarchive.journal.ChecksumStreamingIterator;
import de.lwsystems.mailarchive.journal.JournalChecksumService;
import de.lwsystems.mailarchive.journal.JournalProcessingException;
import de.lwsystems.mailarchive.rest.exception.ResourceNotFoundException;
import de.lwsystems.mailarchive.rest.servlets.BaseBackupServlet;
import de.proite.mailarchive.rest.tools.IpAddressExtractor;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BennoBackupByChecksumsServlet
extends BaseBackupServlet {
    private static final Logger LOGGER = LogManager.getLogger(BennoBackupByChecksumsServlet.class);
    private static final String CONTENT_TYPE_MULTIPART = "multipart/form-data";
    private static final String MULTIPART_FIELD_NAME = "checksums";
    private final JournalChecksumService journalService = new JournalChecksumService();

    public BennoBackupByChecksumsServlet(Benno benno, IpAddressExtractor ipAddressExtractor) {
        super(benno, ipAddressExtractor);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.process(request, response);
    }

    private void process(HttpServletRequest request, HttpServletResponse response) {
        BackupByChecksumsParams params;
        try {
            params = this.extractRequestParameters(request);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Invalid request parameters: {}", (Object)e.getMessage());
            this.writeError(response, 400, "invalid_parameter", e.getMessage());
            return;
        }
        String ip = this.ipAddressExtractor.extractIpAddress(request);
        LOGGER.info("Backup by checksums request from {} for container: {}", (Object)ip, (Object)params.containerName);
        if (!this.validateRequestParameters(response, params)) {
            return;
        }
        HttpSession session = request.getSession();
        IContainer container = this.getContainerOrSendError(response, session, params.containerName, "backupByChecksumsContainer_");
        if (container == null) {
            return;
        }
        try {
            this.processBackup(request, response, params, container);
        }
        catch (ResourceNotFoundException e) {
            LOGGER.info("No emails found for backup-by-checksums request in container {}: {}", (Object)params.containerName, (Object)e.getMessage());
            this.writeError(response, 404, "emails_not_found", e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processBackup(HttpServletRequest request, HttpServletResponse response, BackupByChecksumsParams params, IContainer container) {
        InputStream checksumInputStream = null;
        try {
            String contentType = request.getContentType();
            if (contentType != null && contentType.toLowerCase(Locale.ROOT).startsWith(CONTENT_TYPE_MULTIPART)) {
                checksumInputStream = this.getMultipartInputStream(request);
                if (checksumInputStream == null) {
                    this.writeError(response, 400, "missing_file", "No file uploaded in multipart request. Expected field name: 'checksums'");
                    return;
                }
            } else {
                checksumInputStream = request.getInputStream();
            }
            this.streamBackupFromChecksums(response, params, container, checksumInputStream);
        }
        catch (IOException e) {
            LOGGER.error("Failed to read checksum input for container {}: {}", (Object)params.containerName, (Object)e.getMessage(), (Object)e);
        }
        catch (ServletException e) {
            LOGGER.error("Multipart processing failed for container {}: {}", (Object)params.containerName, (Object)e.getMessage(), (Object)e);
            this.writeError(response, 500, "multipart_error", "Failed to process multipart request: " + e.getMessage());
        }
        catch (JournalProcessingException e) {
            LOGGER.error("Unexpected journal processing error for container {}: {}", (Object)params.containerName, (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (checksumInputStream != null) {
                try {
                    checksumInputStream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private InputStream getMultipartInputStream(HttpServletRequest request) throws IOException, ServletException {
        Part filePart = request.getPart(MULTIPART_FIELD_NAME);
        if (filePart == null) {
            LOGGER.warn("Multipart request missing expected field: {}", (Object)MULTIPART_FIELD_NAME);
            return null;
        }
        long fileSize = filePart.getSize();
        LOGGER.info("Processing multipart file upload: {} bytes", (Object)fileSize);
        return filePart.getInputStream();
    }

    private void streamBackupFromChecksums(HttpServletResponse response, BackupByChecksumsParams params, IContainer container, InputStream checksumInputStream) throws JournalProcessingException {
        ChecksumSelection selection;
        try {
            selection = this.parseRequestedChecksums(checksumInputStream);
        }
        catch (IOException parseError) {
            LOGGER.error("Failed to parse checksum list for container {}: {}", (Object)params.containerName, (Object)parseError.getMessage(), (Object)parseError);
            return;
        }
        LOGGER.info("Starting backup by checksums for container {} (requested: {}, valid lines: {}, invalid lines: {}, comments: {}, empty: {})", (Object)params.containerName, (Object)selection.getRequestedCount(), (Object)selection.getValidLines(), (Object)selection.getInvalidLines(), (Object)selection.getCommentLines(), (Object)selection.getEmptyLines());
        if (selection.getRequestedCount() == 0L) {
            throw new ResourceNotFoundException(String.format(Locale.ROOT, "No emails found in container '%s' because no valid checksums were provided.", params.containerName));
        }
        try (ChecksumStreamingIterator journalIterator = this.journalService.streamChecksumsFromContainer(container, (ChecksumBoundary)null, (ChecksumBoundary)null);){
            FilteringJournalIterator filteredIterator = new FilteringJournalIterator(journalIterator, selection);
            if (!filteredIterator.hasNext()) {
                throw new ResourceNotFoundException(String.format(Locale.ROOT, "No emails found in container '%s' matching the provided checksums.", params.containerName));
            }
            this.setArchiveResponseHeaders(response, "backup-checksums", params.containerName, params.archiveFormat);
            this.withArchiveOutputStream(response, params.archiveFormat, writer -> {
                int successCount = this.backupArchiveService.streamEntries(container, (Iterator)filteredIterator, params.includeBennoHeader, writer, params.format);
                long matched = selection.getMatchedCount();
                long missing = selection.getRemainingCount();
                LOGGER.info("Backup by checksums finished for container {}. Entries written: {}, Matched checksums: {}, Missing in journal: {}, Invalid lines: {}, Total lines: {}", (Object)params.containerName, (Object)successCount, (Object)matched, (Object)missing, (Object)selection.getInvalidLines(), (Object)selection.getTotalLines());
                if (missing > 0L) {
                    LOGGER.warn("Backup completed with {} requested checksums not found in journal for container {}", (Object)missing, (Object)params.containerName);
                }
                if (selection.getInvalidLines() > 0L) {
                    LOGGER.warn("Checksum list contained {} invalid lines for container {}", (Object)selection.getInvalidLines(), (Object)params.containerName);
                }
                LOGGER.debug("Checksum list statistics: {}", (Object)selection.getStatisticsSummary());
            });
        }
        catch (IOException e) {
            LOGGER.error("Backup streaming failed for container {}: {}", (Object)params.containerName, (Object)e.getMessage(), (Object)e);
            this.writeError(response, 500, "streaming_error", "Backup streaming failed: " + e.getMessage());
        }
    }

    private BackupByChecksumsParams extractRequestParameters(HttpServletRequest request) {
        return new BackupByChecksumsParams(request.getParameter("archive"), request.getParameter("header"), request.getParameter("format"), request.getParameter("archiveFormat"));
    }

    private ChecksumSelection parseRequestedChecksums(InputStream checksumInputStream) throws IOException {
        ChecksumSelection selection = new ChecksumSelection();
        try (ChecksumListIterator checksumIterator = new ChecksumListIterator(checksumInputStream);){
            while (checksumIterator.hasNext()) {
                ChecksumEntry entry = checksumIterator.next();
                selection.add(entry);
            }
            selection.captureStats(checksumIterator);
        }
        return selection;
    }

    private boolean validateRequestParameters(HttpServletResponse response, BackupByChecksumsParams params) {
        return this.validateContainerParameter(response, params.containerName);
    }

    private static class BackupByChecksumsParams
    extends BaseBackupServlet.BackupParams {
        BackupByChecksumsParams(String containerName, String headerParam, String formatParam, String archiveFormatParam) {
            super(containerName, headerParam, formatParam, archiveFormatParam);
        }
    }

    private static class ChecksumSelection {
        private final Map<String, Integer> remainingCounts = new LinkedHashMap<String, Integer>();
        private long requestedCount;
        private long matchedCount;
        private long totalLines;
        private long validLines;
        private long invalidLines;
        private long commentLines;
        private long emptyLines;
        private String statisticsSummary = "Total lines: 0, Valid: 0, Invalid: 0, Comments: 0, Empty: 0";

        private ChecksumSelection() {
        }

        void add(ChecksumEntry entry) {
            this.remainingCounts.merge(entry.checksum(), 1, Integer::sum);
            ++this.requestedCount;
        }

        void captureStats(ChecksumListIterator iterator) {
            this.totalLines = iterator.getTotalLines();
            this.validLines = iterator.getValidLines();
            this.invalidLines = iterator.getInvalidLines();
            this.commentLines = iterator.getCommentLines();
            this.emptyLines = iterator.getEmptyLines();
            this.statisticsSummary = iterator.getStatisticsSummary();
        }

        boolean markMatched(ChecksumEntry entry) {
            Integer remaining = this.remainingCounts.get(entry.checksum());
            if (remaining == null || remaining == 0) {
                return false;
            }
            ++this.matchedCount;
            if (remaining == 1) {
                this.remainingCounts.remove(entry.checksum());
            } else {
                this.remainingCounts.put(entry.checksum(), remaining - 1);
            }
            return true;
        }

        long getRemainingCount() {
            return this.requestedCount - this.matchedCount;
        }

        long getRequestedCount() {
            return this.requestedCount;
        }

        long getMatchedCount() {
            return this.matchedCount;
        }

        long getTotalLines() {
            return this.totalLines;
        }

        long getValidLines() {
            return this.validLines;
        }

        long getInvalidLines() {
            return this.invalidLines;
        }

        long getCommentLines() {
            return this.commentLines;
        }

        long getEmptyLines() {
            return this.emptyLines;
        }

        String getStatisticsSummary() {
            return this.statisticsSummary;
        }

        boolean allMatched() {
            return this.matchedCount >= this.requestedCount;
        }
    }

    private static class FilteringJournalIterator
    implements Iterator<ChecksumEntry> {
        private final ChecksumStreamingIterator delegate;
        private final ChecksumSelection selection;
        private ChecksumEntry nextEntry;
        private boolean finished;

        FilteringJournalIterator(ChecksumStreamingIterator delegate, ChecksumSelection selection) {
            this.delegate = delegate;
            this.selection = selection;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public ChecksumEntry next() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException("No more matching checksums available");
            }
            ChecksumEntry current = this.nextEntry;
            this.advance();
            return current;
        }

        private void advance() {
            this.nextEntry = null;
            if (this.finished || this.selection.allMatched()) {
                this.finished = true;
                return;
            }
            while (this.delegate.hasNext()) {
                ChecksumEntry candidate = this.delegate.next();
                if (!this.selection.markMatched(candidate)) continue;
                this.nextEntry = candidate;
                return;
            }
            this.finished = true;
        }
    }
}

