/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.backup.service.BackupArchiveService;
import de.lwsystems.mailarchive.journal.ChecksumBoundary;
import de.lwsystems.mailarchive.journal.ChecksumStreamingIterator;
import de.lwsystems.mailarchive.journal.JournalChecksumService;
import de.lwsystems.mailarchive.journal.JournalProcessingException;
import de.lwsystems.mailarchive.rest.exception.ResourceNotFoundException;
import de.lwsystems.mailarchive.rest.exception.SizeLimitExceededException;
import de.lwsystems.mailarchive.rest.servlets.BaseBackupServlet;
import de.lwsystems.mailarchive.rest.utils.SizeParser;
import de.lwsystems.mailarchive.rest.utils.ValidationUtils;
import de.proite.mailarchive.rest.tools.IpAddressExtractor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BennoBackupServlet
extends BaseBackupServlet {
    private static final Logger LOGGER = LogManager.getLogger(BennoBackupServlet.class);
    private final JournalChecksumService journalService = new JournalChecksumService();

    public BennoBackupServlet(Benno benno, IpAddressExtractor ipAddressExtractor) {
        super(benno, ipAddressExtractor);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.process(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.process(request, response);
    }

    private void process(HttpServletRequest request, HttpServletResponse response) {
        BackupRequestParams params;
        try {
            params = this.extractRequestParameters(request);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Invalid request parameters: {}", (Object)e.getMessage());
            this.writeError(response, 400, "invalid_parameter", e.getMessage());
            return;
        }
        String ip = this.ipAddressExtractor.extractIpAddress(request);
        LOGGER.info("Backup request from {} for container: {}", (Object)ip, (Object)params.containerName);
        if (!this.validateRequestParameters(response, params)) {
            return;
        }
        HttpSession session = request.getSession();
        IContainer container = this.getContainerOrSendError(response, session, params.containerName, "backupContainer_");
        if (container == null) {
            return;
        }
        try {
            this.backupHandling(response, params, container);
        }
        catch (ResourceNotFoundException e) {
            LOGGER.info("No emails found for backup request in container {}: {}", (Object)params.containerName, (Object)e.getMessage());
            this.writeError(response, 404, "emails_not_found", e.getMessage());
        }
        catch (SizeLimitExceededException e) {
            LOGGER.warn("Size limit exceeded for backup request in container {}: {}", (Object)params.containerName, (Object)e.getMessage());
            this.writeError(response, 500, "size_limit_exceeded", e.getMessage());
        }
    }

    private void backupHandling(HttpServletResponse response, BackupRequestParams params, IContainer container) {
        try (ChecksumStreamingIterator checksumIterator = this.journalService.streamChecksumsFromContainer(container, params.startBoundary, params.endBoundary);){
            if (!checksumIterator.hasNext()) {
                throw new ResourceNotFoundException(String.format(Locale.ROOT, "No emails found in container '%s' for the specified checksum range.", params.containerName));
            }
            this.setArchiveResponseHeaders(response, "backup", params.containerName, params.archiveFormat);
            this.withArchiveOutputStream(response, params.archiveFormat, writer -> {
                LOGGER.info("Backup stream starting for container {} (start: {}, end: {}, format: {}, archiveFormat: {}, maxSize: {} bytes)", (Object)params.containerName, (Object)params.startBoundary, (Object)params.endBoundary, (Object)params.format, (Object)params.archiveFormat, params.maxSizeBytes > 0L ? Long.valueOf(params.maxSizeBytes) : "unlimited");
                BackupArchiveService.StreamingResult result = this.backupArchiveService.streamEntries(container, (Iterator)checksumIterator, params.includeBennoHeader, writer, params.maxSizeBytes, params.format);
                if (result.successCount() == 0 && result.truncated()) {
                    throw new SizeLimitExceededException(String.format(Locale.ROOT, "First email exceeds maxSize limit of %d bytes. No emails can be exported with this size constraint.", params.maxSizeBytes));
                }
                LOGGER.info("Backup stream finished. Entries written: {}, total size: {} bytes, truncated: {}, last checksum: {} (total processed: {}, errors: {})", (Object)result.successCount(), (Object)result.totalSize(), (Object)result.truncated(), (Object)result.lastChecksum(), (Object)checksumIterator.getTotalProcessed(), (Object)checksumIterator.getErrors().size());
                if (!checksumIterator.getErrors().isEmpty()) {
                    LOGGER.warn("Backup completed with {} errors for container {}", (Object)checksumIterator.getErrors().size(), (Object)params.containerName);
                }
            });
        }
        catch (ResourceNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            LOGGER.error("Backup streaming failed for container {}: {}", (Object)params.containerName, (Object)e.getMessage(), (Object)e);
            this.writeError(response, 500, "streaming_error", "Backup streaming failed: " + e.getMessage());
        }
        catch (JournalProcessingException e) {
            LOGGER.error("Error in journal processing for container {}, {}", (Object)params.containerName, (Object)e.getMessage(), (Object)e);
        }
    }

    private BackupRequestParams extractRequestParameters(HttpServletRequest request) {
        String rawStartAt = request.getParameter("startAt");
        String rawStartAfter = request.getParameter("startAfter");
        String rawEndAt = request.getParameter("endAt");
        String rawEndBefore = request.getParameter("endBefore");
        String maxSizeParam = request.getParameter("maxSize");
        String formatParam = request.getParameter("format");
        String archiveFormatParam = request.getParameter("archiveFormat");
        return new BackupRequestParams(request.getParameter("archive"), request.getParameter("header"), formatParam, archiveFormatParam, rawStartAt, rawStartAfter, rawEndAt, rawEndBefore, maxSizeParam);
    }

    private boolean validateRequestParameters(HttpServletResponse response, BackupRequestParams params) {
        String rawEnd;
        String rawStart;
        if (!this.validateContainerParameter(response, params.containerName)) {
            return false;
        }
        if (params.rawStartAt != null && params.rawStartAfter != null) {
            this.writeError(response, 400, "invalid_parameters", "Cannot specify both 'startAt' and 'startAfter'. Use only one start boundary parameter.");
            return false;
        }
        if (params.rawEndAt != null && params.rawEndBefore != null) {
            this.writeError(response, 400, "invalid_parameters", "Cannot specify both 'endAt' and 'endBefore'. Use only one end boundary parameter.");
            return false;
        }
        String string = rawStart = params.rawStartAt != null ? params.rawStartAt : params.rawStartAfter;
        if (!ValidationUtils.isValidChecksum(rawStart)) {
            this.writeError(response, 400, "invalid_checksum", String.format("Invalid start checksum format: %s", BennoBackupServlet.displayValue(rawStart)));
            return false;
        }
        String string2 = rawEnd = params.rawEndAt != null ? params.rawEndAt : params.rawEndBefore;
        if (!ValidationUtils.isValidChecksum(rawEnd)) {
            this.writeError(response, 400, "invalid_checksum", String.format("Invalid end checksum format: %s", BennoBackupServlet.displayValue(rawEnd)));
            return false;
        }
        return true;
    }

    private static String displayValue(String value) {
        return value == null ? "<null>" : value;
    }

    private static class BackupRequestParams
    extends BaseBackupServlet.BackupParams {
        final ChecksumBoundary startBoundary;
        final ChecksumBoundary endBoundary;
        final String rawStartAt;
        final String rawStartAfter;
        final String rawEndAt;
        final String rawEndBefore;
        final long maxSizeBytes;

        BackupRequestParams(String containerName, String headerParam, String formatParam, String archiveFormatParam, String rawStartAt, String rawStartAfter, String rawEndAt, String rawEndBefore, String maxSize) {
            super(containerName, headerParam, formatParam, archiveFormatParam);
            String normalized;
            this.rawStartAt = rawStartAt;
            this.rawStartAfter = rawStartAfter;
            this.rawEndAt = rawEndAt;
            this.rawEndBefore = rawEndBefore;
            this.maxSizeBytes = SizeParser.parseToBytes(maxSize);
            this.startBoundary = rawStartAt != null && !rawStartAt.isBlank() ? ((normalized = ValidationUtils.normalizeChecksumBoundary(rawStartAt)) != null ? ChecksumBoundary.at((String)normalized) : null) : (rawStartAfter != null && !rawStartAfter.isBlank() ? ((normalized = ValidationUtils.normalizeChecksumBoundary(rawStartAfter)) != null ? ChecksumBoundary.exclusive((String)normalized) : null) : null);
            this.endBoundary = rawEndAt != null && !rawEndAt.isBlank() ? ((normalized = ValidationUtils.normalizeChecksumBoundary(rawEndAt)) != null ? ChecksumBoundary.at((String)normalized) : null) : (rawEndBefore != null && !rawEndBefore.isBlank() ? ((normalized = ValidationUtils.normalizeChecksumBoundary(rawEndBefore)) != null ? ChecksumBoundary.exclusive((String)normalized) : null) : null);
        }
    }
}

