/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.rest.api.MailResult;
import de.lwsystems.mailarchive.rest.utils.BennoHttpSessionUtils;
import de.lwsystems.mailarchive.rest.utils.BennoMailResponse;
import de.lwsystems.mailarchive.rest.utils.JsonUtils;
import de.lwsystems.mailarchive.rest.utils.ScidUtils;
import de.proite.mailarchive.rest.tools.IpAddressExtractor;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.FileNotFoundException;
import java.io.Writer;
import javax.mail.internet.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class BennoMailServlet
extends HttpServlet {
    private static final Logger LOGGER = LogManager.getLogger(BennoMailServlet.class);
    private final BennoRest bennoRest;
    private final Benno benno;
    private final IpAddressExtractor ipAddressExtractor;
    boolean debugEnabled = LOGGER.isDebugEnabled();

    public BennoMailServlet(BennoRest bennoRest, Benno benno, IpAddressExtractor ipAddressExtractor) {
        this.bennoRest = bennoRest;
        this.benno = benno;
        this.ipAddressExtractor = ipAddressExtractor;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doProccess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doProccess(request, response);
    }

    private void doProccess(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json; charset=UTF-8");
        response.setStatus(200);
        HttpSession session = request.getSession();
        String searchArchive = request.getParameter("archive");
        String searchId = request.getParameter("id");
        String searchSCID = "";
        if (request.getParameter("scid") != null) {
            searchSCID = request.getParameter("scid");
        }
        String ipAddress = this.ipAddressExtractor.extractIpAddress(request);
        LOGGER.info("Request from {} to container {}", (Object)ipAddress, (Object)request.getParameter("archive"));
        String responseFormat = "maildata";
        boolean raw = false;
        boolean header = false;
        boolean skipUtf8Recode = false;
        boolean onlyMailHeaders = false;
        boolean reimport = false;
        if (request.getParameter("format") != null) {
            responseFormat = request.getParameter("format");
            if (responseFormat.equals("raw")) {
                raw = true;
                if (request.getParameter("skipUTF8Recode") != null && request.getParameter("skipUTF8Recode").equals("true")) {
                    skipUtf8Recode = true;
                }
            } else if (responseFormat.equals("headers")) {
                onlyMailHeaders = true;
            } else if (responseFormat.equals("reimport")) {
                reimport = true;
                header = true;
            }
        }
        if (request.getParameter("header") != null && (responseFormat = request.getParameter("header")).equals("true")) {
            header = true;
        }
        try {
            IContainer myContainer;
            if (!BennoHttpSessionUtils.existsContainerSession(session, searchArchive, "myContainer")) {
                session.setAttribute("lastQuery", null);
            }
            if ((myContainer = BennoHttpSessionUtils.getContainer(session, searchArchive, this.benno, "myContainer")).isScidActive() && (!ScidUtils.isScidQueryValid(searchSCID) || searchSCID.equals(""))) {
                throw new FileNotFoundException("SCID is active. Please add a correct SCID parameter to your query");
            }
            if (this.debugEnabled) {
                LOGGER.debug("Load email from repository " + searchId);
            }
            MailDocumentId documentId = new MailDocumentId(searchId, searchSCID);
            IBox box = myContainer.getBox(documentId.getInternalBoxIndentifier());
            MailDocument myDoc = null;
            myDoc = !header ? box.getDocument(documentId) : box.getFullDocument(documentId);
            if (myDoc == null) {
                throw new FileNotFoundException("Mail with id '" + searchId + "' not found!");
            }
            if (!myContainer.isScidActive() && !myDoc.getMetaData().getScid().equals("")) {
                throw new FileNotFoundException("SCID is not active but the mail has a SCID parameter. Please active SCID in benno.xml");
            }
            if (raw) {
                response.setContentType("text/plain;charset=UTF-8");
                BennoMailResponse.buildRawResponse(response, skipUtf8Recode, myDoc, false);
            } else if (onlyMailHeaders) {
                BennoMailResponse.buildHeadersOnlyJsonResponse(response, myDoc);
            } else if (reimport) {
                BennoMailResponse.buildRawResponse(response, skipUtf8Recode, myDoc, true);
            } else {
                MailResult result = BennoMailResponse.buildFullJsonResponse(response, myDoc);
                JsonUtils.write(result, response.getWriter());
            }
            LOGGER.debug("Client: '" + request.getRemoteAddr() + "' requested Mail '" + searchId + "' Archive: '" + searchArchive + "' Response: " + responseFormat + " and it was successfull!");
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.debug("File for ID '" + searchId + "' not found! Continer:" + searchArchive, (Throwable)fnfe);
            response.resetBuffer();
            response.setStatus(404);
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"file not found");
                errResult.write((Writer)response.getWriter());
            }
            catch (Exception ex) {
                LOGGER.fatal("Uncaught Excpetion", (Throwable)ex);
            }
        }
        catch (ContainerNotFoundException ex) {
            LOGGER.warn(ex.getMessage());
            response.resetBuffer();
            response.setStatus(404);
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"container not found");
                errResult.write((Writer)response.getWriter());
                JsonUtils.write(errResult, response.getWriter());
            }
            catch (Exception iex) {
                LOGGER.fatal("Uncaught Exception", (Throwable)iex);
            }
            LOGGER.warn(ex.getMessage());
        }
        catch (ParseException ex) {
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"Could not parse mailfile");
                errResult.write((Writer)response.getWriter());
            }
            catch (Exception iex) {
                LOGGER.fatal("Uncaught Excpetion", (Throwable)iex);
            }
            LOGGER.warn("Could not parse mail with ID: " + searchId);
            LOGGER.warn(ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.fatal("Uncaught Excpetion", (Throwable)ex);
        }
    }
}

