/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.ContainerNotInitializedException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.rest.api.BennoSearchApi;
import de.lwsystems.mailarchive.rest.api.InitError;
import de.lwsystems.mailarchive.rest.api.SearchAnswer;
import de.lwsystems.mailarchive.rest.api.SearchError;
import de.lwsystems.mailarchive.rest.api.SearchHit;
import de.lwsystems.mailarchive.rest.servlets.ServletTools;
import de.lwsystems.mailarchive.rest.utils.BennoHttpSessionUtils;
import de.lwsystems.mailarchive.rest.utils.JsonUtils;
import de.lwsystems.mailarchive.rest.utils.ScidUtils;
import de.lwsystems.mailarchive.search.BadRequestException;
import de.lwsystems.mailarchive.search.IEmailIndex;
import de.lwsystems.mailarchive.search.IFullSearchHit;
import de.lwsystems.mailarchive.search.ISearchHit;
import de.lwsystems.mailarchive.search.ISearchResult;
import de.lwsystems.mailarchive.search.NoSuchObjectException;
import de.lwsystems.mailarchive.search.lucene.LuceneEmailIndex;
import de.lwsystems.mailarchive.utils.Clock;
import de.lwsystems.mailarchive.utils.ILicense;
import de.proite.mailarchive.rest.tools.IBennoLicense;
import de.proite.mailarchive.rest.tools.IpAddressExtractor;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.queryParser.ParseException;
import org.json.JSONException;

public class BennoSearchServlet
extends HttpServlet {
    private static final Logger LOGGER = LogManager.getLogger(BennoSearchServlet.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();
    private final BennoRest bennoRest;
    private final Benno benno;
    private final String plugin;
    private final ILicense license;
    private final IBennoLicense bennoLicense;
    private final IpAddressExtractor ipAddressExtractor;

    public BennoSearchServlet(BennoRest bennoRest, Benno benno, ILicense license, String plugin, IBennoLicense bennoLicense, IpAddressExtractor ipAddressExtractor) {
        this.bennoRest = bennoRest;
        this.benno = benno;
        this.license = license;
        this.plugin = plugin;
        this.bennoLicense = bennoLicense;
        this.ipAddressExtractor = ipAddressExtractor;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    private void doProcess(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        String sessionId = session.getId();
        String ipAddress = this.ipAddressExtractor.extractIpAddress(request);
        LOGGER.info("Request from {} to container {}", (Object)ipAddress, (Object)request.getParameter("archive"));
        response.setContentType("application/json; charset=UTF-8");
        response.setStatus(200);
        try {
            BennoConfig config = this.bennoRest.getBennoConfig();
            if (!(this.plugin == null || this.license.getPlugin() != null && this.license.getPlugin().contains(this.plugin))) {
                LOGGER.error(sessionId + "License is not working with " + this.plugin);
                BennoSearchServlet.badRequest(response, "License is not compatible", "License is not working with " + this.plugin, 407);
                return;
            }
            String queryString = request.getParameter("query");
            try {
                if (queryString.contains("Date:[")) {
                    queryString = queryString.replaceAll("Date:\\[", "SortableDate:[");
                }
            }
            catch (NullPointerException npe) {
                LOGGER.error(session.getId() + "Parameter \"query\" empty or not set.");
                BennoSearchServlet.badRequest(response, "Parameter query not set", "Parameter query must be given in request", 400);
            }
            String searchSCID = "";
            if (request.getParameter("scid") != null) {
                searchSCID = request.getParameter("scid");
            }
            String filterQuery = request.getParameter("filterQuery");
            try {
                if (filterQuery.contains("Date:[")) {
                    filterQuery = filterQuery.replaceAll("Date:\\[", "SortableDate:[");
                }
            }
            catch (NullPointerException npe) {
                LOGGER.error(session.getId() + "Parameter \"filterQuery\" empty or not set.");
                BennoSearchServlet.badRequest(response, "Parameter filterQuery not set", "Parameter filterQuery must be given in request", 400);
            }
            SearchAnswer answer = new BennoSearchApiImpl(response, session, config).search(request.getParameter("archive"), queryString, filterQuery, this.getLimitRequestParameter(request, sessionId), this.getSortFieldFromRequest(request, "SortableDate"), this.getFullRequestParameter(request, false), this.getSortDirectionFromRequest(request, false), this.getStartRequestParameter(request, session.getId()), searchSCID);
            response.resetBuffer();
            JsonUtils.write(answer, response.getWriter());
        }
        catch (ContainerNotFoundException cnfe) {
            LOGGER.warn(cnfe.getMessage());
            response.resetBuffer();
            response.setStatus(404);
            try {
                SearchError errResult = new SearchError();
                errResult.setError("container not found");
                JsonUtils.write(errResult, response.getWriter());
            }
            catch (Exception ex) {
                LOGGER.fatal("Uncaught Excpetion", (Throwable)ex);
            }
        }
        catch (ContainerNotInitializedException cnie) {
            LOGGER.warn(cnie.getMessage());
            response.resetBuffer();
            response.setStatus(404);
            try {
                InitError initError = new InitError("container not initialized", cnie.getName());
                JsonUtils.write(initError, response.getWriter());
            }
            catch (Exception ex) {
                LOGGER.fatal("Uncaught Excpetion", (Throwable)ex);
            }
        }
        catch (ParseException pex) {
            try {
                response.setStatus(400);
                SearchError errResult = new SearchError();
                errResult.setError("Invalid query");
                JsonUtils.write(errResult, response.getWriter());
                LOGGER.warn(session.getId() + " Invalid query string: " + request.getParameter("query"));
            }
            catch (Exception ex) {
                LOGGER.warn("Uncaught Exception", (Throwable)ex);
            }
        }
        catch (IllegalStateException e) {
            response.setStatus(503);
            LOGGER.debug("Illegal state: ", (Throwable)e);
        }
        catch (Exception e) {
            response.setStatus(404);
            LOGGER.fatal("Uncaught Exception", (Throwable)e);
        }
    }

    private IEmailIndex getIndex(IContainer myContainer, String searchArchive) {
        return new LuceneEmailIndex(myContainer, searchArchive);
    }

    private boolean isResultCachedInSession(HttpSession session, String queryString, String sortField, boolean sortAsc, String filterQuery) {
        return session.getAttribute("lastQuery") != null && session.getAttribute("lastQuery").equals(queryString) && session.getAttribute("lastSortField") != null && session.getAttribute("lastSortField").equals(sortField) && session.getAttribute("lastSortAsc") != null && session.getAttribute("lastSortAsc").equals(sortAsc) && session.getAttribute("lastFilterQuery").equals(filterQuery) && session.getAttribute("lastFirst") != null;
    }

    private boolean getFullRequestParameter(HttpServletRequest request, boolean full) {
        if (request.getParameter("full") != null && request.getParameter("full").equals("true")) {
            full = true;
        }
        return full;
    }

    public boolean getSortDirectionFromRequest(HttpServletRequest request, boolean sortAsc) {
        if (request.getParameter("sortAsc") != null && request.getParameter("sortAsc").equals("false")) {
            sortAsc = true;
        }
        return sortAsc;
    }

    public String getSortFieldFromRequest(HttpServletRequest request, String sortField) {
        if (request.getParameter("sort") != null && (((String)(sortField = request.getParameter("sort"))).equals("Date") || ((String)sortField).equals("Subject"))) {
            sortField = "Sortable" + (String)sortField;
        }
        return sortField;
    }

    private int getStartRequestParameter(HttpServletRequest request, String sessionId) {
        int start;
        if (request.getParameter("start") != null) {
            try {
                start = Integer.parseInt(request.getParameter("start"));
                if (start < 1) {
                    start = 1;
                }
            }
            catch (Exception ex) {
                LOGGER.error(sessionId + " Error reading parameter \"start\": " + String.valueOf(ex));
                start = 1;
            }
        } else {
            start = 1;
        }
        return start;
    }

    private int getLimitRequestParameter(HttpServletRequest request, String sessionId) {
        int limit;
        if (request.getParameter("limit") != null) {
            try {
                limit = Integer.parseInt(request.getParameter("limit"));
                if (limit < 0) {
                    limit = 0;
                }
            }
            catch (Exception ex) {
                LOGGER.error(sessionId + " Error reading parameter \"limit\": " + String.valueOf(ex));
                limit = 20;
            }
        } else {
            limit = 20;
        }
        return limit;
    }

    private ISearchResult getResultFromSession(HttpSession session) {
        return (ISearchResult)session.getAttribute("lastResult");
    }

    private static void badRequest(HttpServletResponse response, String title, String content, Integer errorCode) throws IOException {
        response.setStatus(errorCode.intValue());
        response.getWriter().print("<html><head>");
        response.getWriter().print("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>");
        response.getWriter().print("<title>" + title + "</title>");
        response.getWriter().print("<h2>HTTP ERROR: " + errorCode + "</h2>");
        response.getWriter().print("<p>" + content + "</p>");
        response.flushBuffer();
    }

    private void logDebug(String msg) {
        Logger LOGGER = LogManager.getLogger(BennoSearchServlet.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(msg);
        }
    }

    private class BennoSearchApiImpl
    implements BennoSearchApi {
        private final HttpSession session;
        private final BennoConfig config;
        private final HttpServletResponse response;

        BennoSearchApiImpl(HttpServletResponse response, HttpSession session, BennoConfig config) {
            this.response = response;
            this.session = session;
            this.config = config;
        }

        @Override
        public SearchAnswer search(String searchArchive, String queryString, String filterQuery, int limit, String sortField, boolean full, boolean sortAsc, int start, String searchSCID) throws IOException, java.text.ParseException, BadRequestException, ParseException, ContainerNotFoundException {
            SearchAnswer answer = new SearchAnswer();
            String sessionId = this.session.getId();
            try {
                ISearchResult result;
                int hitIndex = start - 1;
                this.session.setAttribute("lastFirst", (Object)start);
                long cacheTTL = this.config.getBennoRestConfig().getIndexCacheTTL();
                IContainer myContainer = null;
                if (!BennoHttpSessionUtils.existsContainerSession(this.session, searchArchive, "myContainer")) {
                    this.session.setAttribute("lastQuery", null);
                    cacheTTL = 0L;
                }
                myContainer = BennoHttpSessionUtils.getContainer(this.session, searchArchive, BennoSearchServlet.this.benno, "myContainer");
                IEmailIndex index = BennoSearchServlet.this.getIndex(myContainer, searchArchive);
                if (BennoSearchServlet.this.plugin != null && BennoSearchServlet.this.license.getPlugin().contains(BennoSearchServlet.this.plugin + "#")) {
                    String timestamp = BennoSearchServlet.this.license.getPlugin().substring(BennoSearchServlet.this.license.getPlugin().indexOf(35) + 1);
                    String pattern = "([2][0-5][0-9][0-9])-([0-1][0-9])-([0-3][0-9])";
                    Pattern datePattern = Pattern.compile("([2][0-5][0-9][0-9])-([0-1][0-9])-([0-3][0-9])");
                    Matcher dateMatch = datePattern.matcher(timestamp);
                    if (dateMatch.find()) {
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-ddHHmmss");
                        Date dt = sdf.parse(timestamp + "235959");
                        long epoch = dt.getTime();
                        BennoSearchServlet.this.bennoLicense.setPluginLicenseExpires(epoch / 1000L);
                    } else {
                        BennoSearchServlet.this.bennoLicense.setPluginLicenseExpires(-1L);
                    }
                }
                BennoSearchServlet.this.bennoLicense.bennoTestPeriodCheck(index);
                String licenseStatus = BennoSearchServlet.this.plugin != null ? BennoSearchServlet.this.bennoLicense.bennoPluginTestPeriodCheck(index, this.response) : BennoSearchServlet.this.bennoLicense.getLicenseStatus();
                if (licenseStatus.equals("INVALID")) {
                    filterQuery = "*";
                    if (BennoSearchServlet.this.plugin != null) {
                        return null;
                    }
                }
                if (myContainer.isScidActive()) {
                    if (!ScidUtils.isScidQueryValid(searchSCID) || searchSCID.equals("")) {
                        LOGGER.error(sessionId + " SCID is active and the parameter is not set in your query.");
                        BennoSearchServlet.badRequest(this.response, "SCID is missing", "Please add the SCID parameter to your query", 400);
                        return null;
                    }
                    filterQuery = (String)filterQuery + " AND (scid:" + searchSCID.replace(" ", "") + ")";
                } else {
                    queryString = (String)queryString + " AND NOT scid:* ";
                }
                answer.setLicenseValid(licenseStatus);
                if (BennoSearchServlet.this.isResultCachedInSession(this.session, (String)queryString, sortField, sortAsc, (String)filterQuery) && Clock.getProvider().newDate().getTime() - (Long)this.session.getAttribute("lastTime") <= 120000L) {
                    result = BennoSearchServlet.this.getResultFromSession(this.session);
                    BennoSearchServlet.this.logDebug(sessionId + " Using cached result - Result from: " + String.valueOf(this.session.getAttribute("lastTime")));
                    BennoSearchServlet.this.logDebug(sessionId + " Time-Diff: " + (Clock.getProvider().newDate().getTime() - (Long)this.session.getAttribute("lastTime")));
                } else {
                    result = index.search(sessionId, sortField, (String)queryString, (String)filterQuery, cacheTTL, sortAsc);
                    this.session.setAttribute("lastTime", (Object)Clock.getProvider().newDate().getTime());
                    this.session.setAttribute("lastQuery", queryString);
                    this.session.setAttribute("lastResult", (Object)result);
                    this.session.setAttribute("lastSortField", (Object)sortField);
                    this.session.setAttribute("lastFilterQuery", filterQuery);
                    this.session.setAttribute("lastSortAsc", (Object)sortAsc);
                }
                ArrayList<SearchHit> results = new ArrayList<SearchHit>();
                answer.setLimit(limit);
                if (!full) {
                    hits = result.getHits(hitIndex, limit);
                    for (ISearchHit hit : hits) {
                        temp = ServletTools.createSearchHit(hit);
                        results.add(temp);
                    }
                } else {
                    hits = result.getFullHits(hitIndex, limit);
                    for (ISearchHit hit : hits) {
                        temp = ServletTools.createSearchHit((IFullSearchHit)hit);
                        results.add(temp);
                    }
                }
                answer.setResults(results);
                answer.setCount(results.size());
                answer.setFound(result.getHitCount());
                answer.setOverall(result.getOverallHitCount());
                answer.setFirst(start);
                answer.setLast(Math.min(limit + start - 1, start + results.size() - 1));
                if (results.size() == 0) {
                    answer.setLast(-1);
                    answer.setFirst(-1);
                }
            }
            catch (NoSuchObjectException nsoe) {
                try {
                    answer.setFound(0);
                    answer.setCount(0);
                    answer.setFirst(-1);
                    answer.setLast(-1);
                    answer.setOverall(nsoe.getOverall());
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            return answer;
        }
    }
}

