/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.utils;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.rest.servlets.ServletTools;
import jakarta.servlet.http.HttpSession;

public class BennoHttpSessionUtils {
    private BennoHttpSessionUtils() {
    }

    public static IContainer getContainer(HttpSession session, String containerName, Benno benno, String sessionKey) throws ContainerNotFoundException {
        IContainer container = (IContainer)session.getAttribute(sessionKey);
        if (container == null || !container.getIdentifier().equals(containerName)) {
            container = ServletTools.getContainer(containerName, benno);
            session.setAttribute(sessionKey, (Object)container);
        }
        return container;
    }

    public static boolean existsContainerSession(HttpSession session, String containerName, String sessionKey) {
        try {
            return session.getAttribute(sessionKey) != null && ((IContainer)session.getAttribute(sessionKey)).getIdentifier().equalsIgnoreCase(containerName);
        }
        catch (NullPointerException ex) {
            return false;
        }
    }
}

