/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.utils;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SizeParser {
    public static final long NO_LIMIT = -1L;
    private static final Pattern SIZE_PATTERN = Pattern.compile("^\\s*(\\d+(?:\\.\\d+)?)\\s*(kb|mb|gb|tb)\\s*$", 2);

    private SizeParser() {
    }

    public static long parseToBytes(String sizeString) {
        long size;
        if (sizeString == null || sizeString.trim().isEmpty()) {
            return -1L;
        }
        Matcher matcher = SIZE_PATTERN.matcher(sizeString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid size format '" + sizeString + "'. Expected format: <number><unit> (e.g., 50GB, 100MB). Supported units: kb, mb, gb, tb");
        }
        String valueStr = matcher.group(1);
        String unit = matcher.group(2).toLowerCase(Locale.ROOT);
        try {
            double doubleValue = Double.parseDouble(valueStr);
            size = Math.round(doubleValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Size must contain a valid number");
        }
        if (size <= 0L) {
            throw new IllegalArgumentException("Size must be a positive value");
        }
        long multiplier = SizeParser.getUnitMultiplier(unit);
        if (size > Long.MAX_VALUE / multiplier) {
            throw new IllegalArgumentException("Size value is too large");
        }
        return size * multiplier;
    }

    private static long getUnitMultiplier(String unit) {
        return switch (unit) {
            case "kb" -> 1000L;
            case "mb" -> 1000000L;
            case "gb" -> 1000000000L;
            case "tb" -> 1000000000000L;
            default -> throw new IllegalArgumentException("Invalid unit '" + unit + "'. Supported units: kb, mb, gb, tb");
        };
    }
}

