/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.utils;

import de.lwsystems.mailarchive.journal.ChecksumValidator;

public class ValidationUtils {
    private static final ChecksumValidator checksumValidator = new ChecksumValidator();

    private ValidationUtils() {
    }

    public static String normalizeChecksumBoundary(String checksum) {
        return ChecksumValidator.normalizeYearBoxAndChecksum((String)checksum);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidChecksum(String checksum) {
        if (checksum == null) return true;
        if (ChecksumValidator.normalizeYearBoxAndChecksum((String)checksum) == null) return false;
        return true;
    }

    public static int parseOffset(String offsetParam, int defaultValue) {
        if (offsetParam == null) {
            return defaultValue;
        }
        try {
            int offset = Integer.parseInt(offsetParam);
            if (offset < 0) {
                throw new IllegalArgumentException("Offset must be >= 0");
            }
            return offset;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Offset must be a valid integer");
        }
    }

    public static int parseLimit(String limitParam, int defaultValue, int maxLimit) {
        if (limitParam == null) {
            return defaultValue;
        }
        try {
            int limit = Integer.parseInt(limitParam);
            if (limit <= 0 || limit > maxLimit) {
                throw new IllegalArgumentException("Limit must be between 1 and " + maxLimit);
            }
            return limit;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Limit must be a valid integer");
        }
    }
}

