/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.journal.FSJournalReader;
import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.rest.servlets.ServletTools;
import de.lwsystems.mailarchive.rest.utils.BennoInstance;
import de.lwsystems.mailarchive.search.BadRequestException;
import de.lwsystems.mailarchive.search.IFullSearchHit;
import de.lwsystems.mailarchive.search.NoSuchObjectException;
import de.lwsystems.mailarchive.utils.InitizalizationMail;
import de.lwsystems.mailarchive.utils.InstanceIdGenerationType;
import de.lwsystems.mailarchive.utils.JournalReaderTools;
import de.proite.mailarchive.rest.tools.BennoInstanceId;
import de.proite.mailarchive.rest.tools.LuceneIndexSearch;
import de.proite.mailarchive.rest.tools.RepoMailTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.queryParser.ParseException;

public class BennoLicenseInstance {
    private static final Logger LOGGER = LogManager.getLogger(BennoLicenseInstance.class);
    private static final String licenseKeyHeader = "X-BENNO-System-Recipient";
    private static final String searchQuery = "(From:*@* To:*@* Recipient:*@* Sender:*@*)";
    private static final String filterQuery = "(From:*@* To:*@* Recipient:*@* Sender:*@*)";
    private InstanceIdGenerationType instanceIdGenerationType = InstanceIdGenerationType.JOURNAL;
    private String instanceId = "";
    private Map<InstanceIdGenerationType, BennoInstance> bennoInstances = new HashMap<InstanceIdGenerationType, BennoInstance>();
    private Benno benno;
    private static BennoLicenseInstance bennoLicenseInstance = null;
    private static final String INITIALIZATION_MAIL_CONTAINER = "SYSDATA";
    private String instanceInfo = "";
    private String mailId = "";

    private BennoLicenseInstance(Benno benno) {
        this.benno = benno;
        try {
            this.generateBennoLicenseInstance();
        }
        catch (Exception ex) {
            this.initializeNewInstallationMail(this.benno);
        }
    }

    public static synchronized BennoLicenseInstance getInstance(Benno benno) throws NoSuchAlgorithmException, ArchiveException, ContainerNotFoundException, IOException, InterruptedException {
        if (bennoLicenseInstance == null || BennoLicenseInstance.bennoLicenseInstance.instanceId.equals("")) {
            bennoLicenseInstance = new BennoLicenseInstance(benno);
        }
        return bennoLicenseInstance;
    }

    private void generateBennoLicenseInstance() throws IOException, NoSuchAlgorithmException, ArchiveException, ContainerNotFoundException {
        for (InstanceIdGenerationType idGenerationType : InstanceIdGenerationType.values()) {
            this.generateBennoInstanceIdAndInstanceInfo(idGenerationType);
        }
        if (this.bennoInstances.containsKey(InstanceIdGenerationType.JOURNAL)) {
            this.instanceId = this.bennoInstances.get(InstanceIdGenerationType.JOURNAL).getInstanceId();
            this.instanceInfo = this.bennoInstances.get(InstanceIdGenerationType.JOURNAL).getInstanceInfo();
            this.mailId = this.bennoInstances.get(InstanceIdGenerationType.JOURNAL).getMailId();
        } else if (this.bennoInstances.containsKey(InstanceIdGenerationType.INDEX)) {
            this.instanceId = this.bennoInstances.get(InstanceIdGenerationType.INDEX).getInstanceId();
            this.instanceInfo = this.bennoInstances.get(InstanceIdGenerationType.INDEX).getInstanceInfo();
            this.mailId = this.bennoInstances.get(InstanceIdGenerationType.INDEX).getMailId();
        }
    }

    public void setInstanceIdGenerationFromType(InstanceIdGenerationType instanceIdGenerationType) {
        this.instanceIdGenerationType = instanceIdGenerationType;
    }

    private Map<String, String> generateBennoInstanceIdAndInstanceInfo(InstanceIdGenerationType instanceIdGenerationType) throws ContainerNotFoundException, ArchiveException, IOException, NoSuchAlgorithmException {
        IContainer systemContainer;
        IBox bennoBox;
        MailDocumentId mailDocumentId;
        Path initializationMailPath;
        Optional<MailDocumentId> initializationMail = this.getInitializationMail(instanceIdGenerationType);
        HashMap<String, String> instanceInformation = new HashMap<String, String>();
        if (initializationMail.isPresent() && Files.exists(initializationMailPath = RepoMailTools.getRepoMailPath(mailDocumentId = initializationMail.get(), bennoBox = (systemContainer = ServletTools.getContainer(INITIALIZATION_MAIL_CONTAINER, this.benno)).getBox(mailDocumentId.getInternalBoxIndentifier())), new LinkOption[0])) {
            BennoInstance bennoInstance = new BennoInstance(BennoInstanceId.createInstanceId(mailDocumentId, bennoBox), mailDocumentId.toString(), RepoMailTools.getLastModifiedTime(mailDocumentId, bennoBox), instanceIdGenerationType);
            this.bennoInstances.put(instanceIdGenerationType, bennoInstance);
        }
        return instanceInformation;
    }

    private Optional<MailDocumentId> getInitializationMail(InstanceIdGenerationType instanceIdGenerationType) {
        try {
            switch (instanceIdGenerationType) {
                case INDEX: {
                    return this.findInitializationMailFromIndex();
                }
                case JOURNAL: {
                    return this.findInitializationMailFromJournal();
                }
            }
        }
        catch (ArchiveException | ContainerNotFoundException | BadRequestException | NoSuchObjectException | IOException | NoSuchAlgorithmException | ParseException ex) {
            LOGGER.error("Can't create benno instance id", ex);
            BennoInstance bennoInstance = new BennoInstance("", "", FileTime.from(Instant.now()), instanceIdGenerationType);
            this.bennoInstances.put(instanceIdGenerationType, bennoInstance);
        }
        return Optional.empty();
    }

    @Deprecated
    private Optional<MailDocumentId> findInitializationMailFromIndex() throws ArchiveException, IOException, ContainerNotFoundException, BadRequestException, NoSuchObjectException, ParseException {
        LuceneIndexSearch luceneIndexSearch = new LuceneIndexSearch(this.benno, INITIALIZATION_MAIL_CONTAINER);
        try {
            Iterable<IFullSearchHit> initializationMailSearchHits = luceneIndexSearch.searchInIndex("License", "IndexTS", "(From:*@* To:*@* Recipient:*@* Sender:*@*)", "(From:*@* To:*@* Recipient:*@* Sender:*@*)", 0, false).getFullHits(0, 100000);
            for (IFullSearchHit searchHit : initializationMailSearchHits) {
                Header[] mailHeaders;
                MailDocumentId documentId = new MailDocumentId(searchHit.getId(), "");
                IContainer container = ServletTools.getContainer(INITIALIZATION_MAIL_CONTAINER, this.benno);
                IBox box = container.getBox(documentId.getInternalBoxIndentifier());
                Optional<MailDocument> optInitializationMailDocument = Optional.ofNullable(box.getDocument(documentId));
                if (!optInitializationMailDocument.isPresent()) continue;
                MailDocument initializationMailDocument = optInitializationMailDocument.get();
                for (Header mailHeader : mailHeaders = initializationMailDocument.getMetaData().getHeaders()) {
                    if (!mailHeader.getName().equalsIgnoreCase(licenseKeyHeader)) continue;
                    return Optional.ofNullable(documentId);
                }
            }
        }
        catch (BadRequestException | NoSuchObjectException | IOException | ParseException ex) {
            return Optional.empty();
        }
        return Optional.empty();
    }

    private Optional<MailDocumentId> findInitializationMailFromJournal() throws ContainerNotFoundException, ArchiveException, IOException, BadRequestException, NoSuchObjectException, NoSuchAlgorithmException, ParseException {
        IContainer container = ServletTools.getContainer(INITIALIZATION_MAIL_CONTAINER, this.benno);
        Optional<MailDocumentId> initializationMail = Optional.empty();
        FSJournalReader journalReader = new FSJournalReader();
        try {
            Optional firstMail = Optional.empty();
            List journalFiles = journalReader.getAllJournalFiles(Paths.get(container.getBoxGenerator().getState().getActualBox().getRepoPath(), new String[0]));
            Iterator journalIterator = journalFiles.iterator();
            while (journalIterator.hasNext() && !firstMail.isPresent()) {
                IBox box;
                Path firstMailPath = (Path)journalIterator.next();
                firstMail = JournalReaderTools.getFirstBennoIdInJournal((BufferedReader)journalReader.createBufferedReaderFromPath(firstMailPath));
                if (!firstMail.isPresent()) continue;
                long count = container.getBoxGenerator().getState().getActualBox().getRepoPath().chars().filter(ch -> ch == 47).count();
                String firstMailBennoId = (String)firstMail.get();
                MailDocumentId documentId = firstMailBennoId.contains(":") ? new MailDocumentId(firstMailBennoId, "") : new MailDocumentId(String.valueOf(firstMailPath.subpath((int)count, (int)count + 1)) + ":" + firstMailBennoId, "");
                Path repoMail = RepoMailTools.getRepoMailPath(documentId, box = container.getBox(documentId.getInternalBoxIndentifier()));
                if (!Files.exists(repoMail, new LinkOption[0])) continue;
                initializationMail = Optional.ofNullable(documentId);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Can't find journal file for license detection", (Throwable)ex);
        }
        return initializationMail;
    }

    public String getInstanceInfo() {
        if (!this.bennoInstances.containsKey(this.instanceIdGenerationType)) {
            return this.instanceInfo;
        }
        return this.bennoInstances.get(this.instanceIdGenerationType).getInstanceInfo();
    }

    public String getInstanceInfo(InstanceIdGenerationType instanceIdGenerationType) {
        if (!this.bennoInstances.containsKey(instanceIdGenerationType)) {
            return this.instanceInfo;
        }
        return this.bennoInstances.get(instanceIdGenerationType).getInstanceInfo();
    }

    public String getInstanceId() {
        if (!this.bennoInstances.containsKey(this.instanceIdGenerationType)) {
            return this.instanceId;
        }
        return this.bennoInstances.get(this.instanceIdGenerationType).getInstanceId();
    }

    public String getInstanceId(InstanceIdGenerationType instanceIdGenerationType) {
        if (!this.bennoInstances.containsKey(instanceIdGenerationType)) {
            return this.instanceId;
        }
        return this.bennoInstances.get(instanceIdGenerationType).getInstanceId();
    }

    public String getBennoIdFromInitializationMail() {
        if (!this.bennoInstances.containsKey(this.instanceIdGenerationType)) {
            return this.mailId;
        }
        return this.bennoInstances.get(this.instanceIdGenerationType).getMailId();
    }

    public String getBennoIdFromInitializationMail(InstanceIdGenerationType instanceIdGenerationType) {
        if (!this.bennoInstances.containsKey(instanceIdGenerationType)) {
            return this.mailId;
        }
        return this.bennoInstances.get(instanceIdGenerationType).getMailId();
    }

    public boolean initializeNewInstallationMail(Benno benno) {
        try {
            if (this.instanceId.isEmpty()) {
                InitizalizationMail.createInitializationMailMessage((Benno)benno);
                return true;
            }
        }
        catch (Exception nso) {
            return false;
        }
        return false;
    }
}

