/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.search.lucene;

import de.lwsystems.mailarchive.search.ISearchHit;
import de.proite.mailarchive.rest.tools.RecipientResolver;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.lucene.document.Document;

public class LuceneSearchHit
implements ISearchHit {
    private Document hitDoc;
    private RecipientResolver rr;

    public LuceneSearchHit(Document hitDoc) {
        this.hitDoc = hitDoc;
        this.rr = new RecipientResolver(hitDoc.getFieldables("To"), hitDoc.getFieldables("Cc"), hitDoc.getFieldables("Recipient"));
    }

    public String[] getTo() {
        return this.rr.getToArray();
    }

    public String[] getCc() {
        return this.rr.getCcArray();
    }

    public String[] getBcc() {
        return this.rr.getBccArray();
    }

    public Date getDate() {
        String dateString = this.hitDoc.get("Date");
        if (dateString != null) {
            try {
                return new SimpleDateFormat("yyyyMMddHHmm").parse(dateString);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    public String getSubject() {
        return this.hitDoc.get("Subject");
    }

    public String getFrom() {
        return this.hitDoc.get("From");
    }

    public String getId() {
        return this.hitDoc.get("id");
    }

    public boolean hasAttachment() {
        if (this.hitDoc.get("hasAttachment") == null) {
            return false;
        }
        return this.hitDoc.get("hasAttachment").equals("1");
    }
}

