/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.proite.mailarchive.rest.tools.MailAttachment;
import de.proite.mailarchive.rest.tools.MimePartResolver;
import de.proite.mailarchive.rest.tools.RecipientResolver;
import java.io.IOException;
import java.util.ArrayList;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonBuilder {
    private static final Logger LOGGER = Logger.getLogger(JsonBuilder.class);

    public static JSONObject createFullJsonDocument(MailDocument myDoc) throws JSONException, IOException, MessagingException {
        JSONArray attachments = new JSONArray();
        JSONArray bodies = new JSONArray();
        JSONObject temp = new JSONObject();
        JSONObject result = new JSONObject();
        JsonBuilder.addCommonHeaderData(myDoc, temp);
        result.put("header", (Object)temp);
        MimeMultipart multipart = null;
        String textPart = null;
        ArrayList<JSONObject> attachmentList = new ArrayList<JSONObject>();
        ArrayList<JSONObject> bodyList = new ArrayList<JSONObject>();
        if (!myDoc.getMimeMesage().getContent().getClass().equals(String.class)) {
            if (!myDoc.getMimeMesage().getContentType().contains("multipart/") && !myDoc.getMimeMesage().getContentType().contains("text/")) {
                JSONObject tmpAttach = new JSONObject();
                MailAttachment tmpAttachment = new MailAttachment(myDoc.getMimeMesage().getContentType(), myDoc.getMimeMesage().getSize());
                tmpAttach.put("name", (Object)tmpAttachment.getFilename());
                tmpAttach.put("content-type", (Object)tmpAttachment.getContentType());
                tmpAttach.put("size", tmpAttachment.getSize());
                attachmentList.add(tmpAttach);
            } else {
                multipart = (MimeMultipart)myDoc.getMimeMesage().getContent();
            }
        } else {
            textPart = (String)myDoc.getMimeMesage().getContent();
        }
        if (multipart != null) {
            MimePartResolver.resolveMimeParts(multipart, attachmentList, bodyList);
        } else {
            JSONObject tmpFile = new JSONObject();
            tmpFile.put("content-type", (Object)myDoc.getMimeMesage().getContentType());
            tmpFile.put("data", (Object)textPart);
            bodyList.add(tmpFile);
        }
        for (JSONObject jo : attachmentList) {
            attachments.put((Object)jo);
        }
        result.put("attachments", (Object)attachments);
        for (JSONObject jo : bodyList) {
            bodies.put((Object)jo);
        }
        result.put("body", (Object)bodies);
        return result;
    }

    public static JSONObject createHeadersOnlyJsonDocument(MailDocument myDoc) throws JSONException {
        JSONObject result = new JSONObject();
        JsonBuilder.addCommonHeaderData(myDoc, result);
        return result;
    }

    private static void addCommonHeaderData(MailDocument myDoc, JSONObject result) throws JSONException {
        String[] recipients;
        String ccList = "";
        String toList = "";
        JSONArray bccList = new JSONArray();
        for (Header header : myDoc.getMetaData().getHeaders()) {
            if (header.getName().equals("Cc")) {
                ccList = header.getBody();
                continue;
            }
            if (header.getName().equals("To")) {
                toList = header.getBody();
                continue;
            }
            result.put(header.getName(), (Object)header.getBody());
        }
        for (String aktRecipient : recipients = myDoc.getMetaData().getRecipients()) {
            if (toList.contains(aktRecipient) || ccList.contains(aktRecipient)) continue;
            bccList.put((Object)aktRecipient);
        }
        result.put("Bcc", (Object)bccList);
        result.put("Cc", (Object)RecipientResolver.getJSONArrayFromString(ccList));
        result.put("To", (Object)RecipientResolver.getJSONArrayFromString(toList));
        result.put("Size", myDoc.getMetaData().getSize());
        result.put("HashCheckPassed", myDoc.getMetaData().hashesMatch());
    }
}

