/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import de.proite.mailarchive.rest.tools.ContentType;
import de.proite.mailarchive.rest.tools.MailAttachment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.eclipse.jetty.io.WriterOutputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class MimePartResolver {
    private static final Logger LOGGER = Logger.getLogger(MimePartResolver.class);

    public static void resolveMimeParts(MimeMultipart mm, ArrayList<JSONObject> attachments, ArrayList<JSONObject> bodies) throws MessagingException, IOException {
        int[] bodyPartCount = new int[]{0, 0};
        MimePartResolver.resolveMimeParts(mm, attachments, bodies, bodyPartCount);
    }

    public static void resolveMimeParts(MimeMultipart mm, ArrayList<JSONObject> attachments, ArrayList<JSONObject> bodies, int[] bodyPartCount) throws MessagingException, IOException {
        for (int i = 0; i < mm.getCount(); ++i) {
            BodyPart bp = mm.getBodyPart(i);
            boolean isMultiPart = false;
            try {
                if (bp.getContent().getClass().equals(MimeMultipart.class)) {
                    isMultiPart = true;
                }
            }
            catch (UnsupportedEncodingException ex) {
                isMultiPart = false;
                bp.setHeader("Content-Type", ContentType.bareType(bp));
                LOGGER.info((Object)("Detected unsupported charset in Content-Type-Header. Force Content-Type to: " + ContentType.bareType(bp)));
            }
            if (isMultiPart) {
                MimePartResolver.resolveMimeParts((MimeMultipart)bp.getContent(), attachments, bodies);
                continue;
            }
            JSONObject file = new JSONObject();
            String fileName = null;
            try {
                fileName = bp.getFileName();
            }
            catch (ParseException exception) {
                fileName = "";
            }
            if (fileName != null) {
                MailAttachment tmpAttachment = new MailAttachment(bp);
                MimePartResolver.putAttribute(file, "content-type", tmpAttachment.getContentType());
                MimePartResolver.putAttribute(file, "name", tmpAttachment.getFilename());
                MimePartResolver.putAttribute(file, "size", tmpAttachment.getSize());
                attachments.add(file);
                continue;
            }
            MimePartResolver.putAttribute(file, "content-type", ContentType.bareType(bp));
            MimePartResolver.putAttribute(file, "data", MimePartResolver.decodeContent(bp));
            if (ContentType.bareType(bp).toLowerCase().equals("text/plain")) {
                int n = bodyPartCount[0];
                bodyPartCount[0] = n + 1;
                if (n < 1) {
                    bodies.add(file);
                    continue;
                }
                attachments.add(file);
                continue;
            }
            if (ContentType.bareType(bp).toLowerCase().equals("text/html")) {
                int n = bodyPartCount[1];
                bodyPartCount[1] = n + 1;
                if (n < 1) {
                    bodies.add(file);
                    continue;
                }
                attachments.add(file);
                continue;
            }
            attachments.add(file);
        }
    }

    public static String decodeContent(BodyPart bp) {
        String returnContent;
        try {
            Object content = bp.getContent();
            if (content instanceof BASE64DecoderStream) {
                BASE64DecoderStream stream = (BASE64DecoderStream)content;
                StringWriter writer = new StringWriter();
                BASE64EncoderStream base64Stream = new BASE64EncoderStream((OutputStream)new WriterOutputStream((Writer)writer));
                IOUtils.copy((InputStream)stream, (OutputStream)base64Stream);
                returnContent = writer.getBuffer().toString();
            } else {
                returnContent = content.toString();
            }
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)"Error decode body content: ", (Throwable)ex);
            returnContent = "";
        }
        return returnContent;
    }

    public static void putAttribute(JSONObject json, String attr, String value) {
        try {
            json.put(attr, (Object)value);
        }
        catch (JSONException ex) {
            LOGGER.warn((Object)("Cannot set string attribute " + attr + " to " + value + ": "), (Throwable)ex);
        }
    }

    public static void putAttribute(JSONObject json, String attr, int value) {
        try {
            json.put(attr, value);
        }
        catch (JSONException ex) {
            LOGGER.warn((Object)("Cannot set integer attribute " + attr + " to " + value + ": "), (Throwable)ex);
        }
    }

    public static void getBodyPartList(MimeMultipart mm, ArrayList<BodyPart> bodyParts) throws MessagingException, IOException {
        ArrayList bodyPart = new ArrayList();
        for (int i = 0; i < mm.getCount(); ++i) {
            BodyPart bp = mm.getBodyPart(i);
            boolean isMultiPart = false;
            try {
                if (bp.getContent().getClass().equals(MimeMultipart.class)) {
                    isMultiPart = true;
                }
            }
            catch (UnsupportedEncodingException ex) {
                isMultiPart = false;
                bp.setHeader("Content-Type", ContentType.bareType(bp));
                LOGGER.info((Object)("Detected unsupported charset in Content-Type-Header. Force Content-Type to: " + bp.getContentType()));
            }
            if (isMultiPart) {
                MimePartResolver.getBodyPartList((MimeMultipart)bp.getContent(), bodyParts);
                continue;
            }
            bodyParts.add(bp);
        }
    }
}

