/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.IBennoApplication;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.rest.servlets.BennoAdminServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoAttachmentServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoEmlTestServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoLicenseServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoLogoutServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoMailServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoPluginSearchServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoSearchServlet;
import de.lwsystems.mailarchive.rest.servlets.BennoStatsServlet;
import de.lwsystems.mailarchive.utils.CommandLineUtil;
import de.lwsystems.mailarchive.utils.ILicense;
import de.lwsystems.mailarchive.utils.License;
import de.lwsystems.mailarchive.utils.RunUtil;
import de.proite.mailarchive.rest.tools.BennoLicense;
import de.proite.mailarchive.rest.tools.IBennoLicense;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.servlet.Servlet;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.eclipse.jetty.http.security.Constraint;
import org.eclipse.jetty.http.security.Credential;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.security.SecurityHandler;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class BennoRest
implements IBennoApplication {
    private static final Logger LOGGER = Logger.getLogger(BennoRest.class);
    private transient Benno benno;
    private String jettyConfig = "/etc/benno/jetty.xml";
    private String bennoConfigFile = "/etc/benno/benno.xml";
    private String bennoLicenseFile = "/etc/benno/benno.lic";
    private String myHostname = "";
    private String myAddress = "";
    private String buildInfo = "";
    private ILicense bennoLicense;
    private IBennoLicense bennoLicenseRest;
    private BennoConfig bennoConfig;
    private int restPort = 0;
    private transient Server jetty = null;

    public static void main(String[] args) throws Exception {
        boolean success = false;
        try {
            Benno.configureLogging();
            BennoRest rest = new BennoRest();
            if (rest.getBenno(args, false)) {
                rest.runJetty();
            }
        }
        catch (Throwable ex) {
            System.err.println(ex.toString());
            LOGGER.fatal((Object)ex.toString());
        }
    }

    public BennoRest(int restPort) {
        this.restPort = restPort;
    }

    public BennoRest() {
    }

    public void setBenno(Benno benno) {
        this.benno = benno;
        this.bennoConfig = benno.getConfig();
    }

    private boolean getBenno(String[] args, boolean readOnly) throws Exception {
        boolean success = false;
        BennoConfig config = null;
        PosixParser parser = new PosixParser();
        Options options = new Options();
        OptionBuilder.withArgName((String)"PORT");
        OptionBuilder.withLongOpt((String)"port");
        OptionBuilder.withDescription((String)"start rest interface on port PORT");
        OptionBuilder.hasArg();
        OptionBuilder.withType(Integer.class);
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withArgName((String)"CONFIGFILE");
        OptionBuilder.withLongOpt((String)"config");
        OptionBuilder.withDescription((String)"use configuraton from CONFIGFILE");
        OptionBuilder.hasArg();
        OptionBuilder.withType(String.class);
        options.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print this description");
        options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"print-config");
        OptionBuilder.withDescription((String)"print out actual configuration");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"host-info");
        OptionBuilder.withDescription((String)"print out current host info");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"default-config");
        OptionBuilder.withDescription((String)"print out default configuration");
        options.addOption(OptionBuilder.create());
        try {
            InetAddress iaddr = InetAddress.getLocalHost();
            String hostname = iaddr.getCanonicalHostName();
            this.myHostname = hostname.indexOf(".") == -1 ? "ERR_FQDN: " + hostname : hostname;
            String address = iaddr.getHostAddress();
            this.myAddress = address.startsWith("127.") ? "ERR_LOOPBACK: " + address : address;
            this.buildInfo = RunUtil.buildInfo();
            CommandLine cmdl = parser.parse(options, args, true);
            if (cmdl.hasOption("h")) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp("java -jar bennorest.jar", options);
                Runtime.getRuntime().exit(0);
            } else if (cmdl.hasOption("host-info")) {
                boolean error = false;
                if (this.myHostname.indexOf(".") == -1) {
                    System.out.println("ERROR: Hostname not fully qualified: " + this.myHostname);
                    LOGGER.error((Object)("No fully-qualified hostname found: " + this.myHostname));
                    error = true;
                }
                if (this.myAddress.startsWith("127.")) {
                    System.out.println("ERROR: Loopback address detected for hostname \"" + this.myHostname + "\": " + this.myAddress);
                    LOGGER.error((Object)("IP address points to loopback device: " + this.myAddress));
                    error = true;
                }
                if (error) {
                    Runtime.getRuntime().exit(1);
                }
                System.out.println("Host-Info: " + this.myAddress + "/" + this.myHostname);
                System.out.println("Build-Info: " + RunUtil.buildInfo());
                Runtime.getRuntime().exit(0);
            } else {
                File configfile = CommandLineUtil.findConfigFile((CommandLine)cmdl);
                if (configfile == null) {
                    System.err.println("No configfile found, exiting");
                    LOGGER.fatal((Object)"No configfile found, exiting");
                    Runtime.getRuntime().exit(99);
                }
                config = (BennoConfig)Benno.getPersister().read(BennoConfig.class, configfile);
                StringWriter writer = new StringWriter();
                Benno.getPersister().write((Object)config, (Writer)writer);
                LOGGER.debug((Object)writer.toString());
                if (cmdl.hasOption("p")) {
                    this.restPort = (Integer)cmdl.getParsedOptionValue("p");
                }
                if (cmdl.hasOption("print-config")) {
                    Benno.getPersister().write((Object)config, (OutputStream)System.out);
                    Runtime.getRuntime().exit(0);
                }
            }
        }
        catch (UnknownHostException exp) {
            String message = "Cannot determine local hostname. Please check hostname configuration.";
            System.err.println(message);
            LOGGER.fatal((Object)message);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error starting REST daemon. ", (Throwable)exp);
            }
        }
        catch (XMLStreamException exp) {
            String message = "Cannot parse config file: " + exp;
            System.err.println(message);
            LOGGER.fatal((Object)message);
            config = null;
        }
        catch (Exception exp) {
            HelpFormatter formatter = new HelpFormatter();
            StringWriter sWriter = new StringWriter();
            PrintWriter writer = new PrintWriter(sWriter);
            formatter.printHelp(writer, 80, "benno " + Benno.class.getPackage().getImplementationVersion(), "Commandline usage:", options, 1, 1, "Unexpected exception:" + exp.getMessage(), true);
            writer.flush();
            String message = sWriter.toString();
            System.err.println(message);
            LOGGER.fatal((Object)message);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Error starting REST daemon. ", (Throwable)exp);
            }
            config = null;
        }
        if (config != null) {
            this.benno = null;
            this.benno = new Benno(config, true, null, (ApplicationContext)new ClassPathXmlApplicationContext("/spring/applicationContext.xml"));
            this.bennoConfig = config;
            if (this.benno != null) {
                success = true;
                if (config.bennoRestConfig != null) {
                    this.jettyConfig = config.bennoRestConfig.getJettyConfig();
                }
            }
        }
        this.bennoLicenseRest = new BennoLicense();
        this.bennoLicense = new License(this.bennoLicenseFile);
        return success;
    }

    public void runJetty() {
        this.runJetty(this.benno, this.bennoLicense, this.bennoLicenseRest);
    }

    public void runJetty(Benno benno, ILicense license, IBennoLicense bennoLicenseRest) {
        LOGGER.info((Object)("Starting Jetty server from file " + this.jettyConfig));
        try {
            if (this.restPort == 0) {
                XmlConfiguration configuration = new XmlConfiguration((InputStream)new FileInputStream(new File(this.jettyConfig)));
                this.jetty = (Server)configuration.configure();
            } else {
                this.jetty = new Server();
                SelectChannelConnector connector = new SelectChannelConnector();
                connector.setPort(this.restPort);
                this.jetty.addConnector((Connector)connector);
            }
            ServletContextHandler bennoContext = new ServletContextHandler(1);
            bennoContext.setContextPath("/");
            this.jetty.setHandler((Handler)bennoContext);
            String secret = null;
            String passwdFilename = "/etc/benno/rest.secret";
            try {
                passwdFilename = this.bennoConfig.bennoRestConfig.getPasswdFile();
                File passwdFile = new File(passwdFilename);
                LOGGER.info((Object)("Read shared secret from " + passwdFilename));
                secret = new BufferedReader(new FileReader(passwdFile)).readLine().trim();
            }
            catch (FileNotFoundException ex) {
                LOGGER.warn((Object)("Password file " + passwdFilename + " not found. Read from main configfile."));
                secret = this.bennoConfig.bennoRestConfig.getSharedSecret();
            }
            if (secret.equals("notset")) {
                LOGGER.fatal((Object)" Shared secret not set. Exit.");
                System.err.println("Shared secret not set. Exit.");
                Runtime.getRuntime().exit(254);
            }
            if (secret.length() < 8) {
                LOGGER.fatal((Object)" Shared secret shorter than 8 chars. Exit.");
                System.err.println("Shared secret shorter than 8 chars. Exit.");
                Runtime.getRuntime().exit(254);
            }
            bennoContext.setSecurityHandler(BennoRest.basicAuth("benno2", secret, "benno"));
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoSearchServlet(this, benno, bennoLicenseRest)), "/search/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoMailServlet(this, benno)), "/mail/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoAttachmentServlet(this, benno)), "/attachment/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoLogoutServlet(this, benno)), "/logout/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoLicenseServlet(this, benno, license, bennoLicenseRest)), "/license/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoEmlTestServlet(this, benno, license)), "/testeml/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoAdminServlet(this, benno)), "/admin/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoStatsServlet(this, benno)), "/stats/*");
            bennoContext.addServlet(new ServletHolder((Servlet)new BennoPluginSearchServlet(this, benno, license, "kopano", bennoLicenseRest)), "/kopano/*");
            this.jetty.start();
            this.jetty.join();
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)("Could not open Jetty from file " + this.jettyConfig), (Throwable)ex);
            System.exit(255);
        }
    }

    void stop() {
        try {
            this.jetty.stop();
        }
        catch (Exception ex) {
            LOGGER.error((Object)"Error closing Jetty", (Throwable)ex);
        }
    }

    public void start() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void shutDown() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getIdentifier() {
        return "Bennorest" + (this.benno == null ? "" : " " + this.benno.getIdentifier());
    }

    public BennoConfig getBennoConfig() {
        return this.bennoConfig;
    }

    private static final SecurityHandler basicAuth(String username, String password, String realm) {
        HashLoginService l = new HashLoginService();
        l.putUser(username, Credential.getCredential((String)password), new String[]{"user"});
        l.setName(realm);
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"user"});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        ConstraintSecurityHandler csh = new ConstraintSecurityHandler();
        csh.setAuthenticator((Authenticator)new BasicAuthenticator());
        csh.setRealmName("myrealm");
        csh.addConstraintMapping(cm);
        csh.setLoginService((LoginService)l);
        return csh;
    }

    public String getMyHostname() {
        return this.myHostname;
    }

    public String getMyAddress() {
        return this.myAddress;
    }

    public String getBuildInfo() {
        return this.buildInfo;
    }
}

