/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.search.lucene;

import de.lwsystems.mailarchive.search.ISearchHit;
import de.proite.mailarchive.rest.tools.RecipientResolver;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.lucene.document.Document;

public class LuceneSearchHit
implements ISearchHit {
    private Document hitDoc;
    private RecipientResolver rr;

    public LuceneSearchHit(Document hitDoc) {
        this.hitDoc = hitDoc;
        this.rr = new RecipientResolver(hitDoc.getFieldables("To"), hitDoc.getFieldables("Cc"), hitDoc.getFieldables("Recipient"));
    }

    @Override
    public String[] getTo() {
        return this.rr.getToArray();
    }

    @Override
    public String[] getCc() {
        return this.rr.getCcArray();
    }

    @Override
    public String[] getBcc() {
        return this.rr.getBccArray();
    }

    @Override
    public Date getDate() {
        String dateString = this.hitDoc.get("Date");
        if (dateString != null) {
            try {
                return new SimpleDateFormat("yyyyMMddHHmm").parse(dateString);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getSubject() {
        return this.hitDoc.get("Subject");
    }

    @Override
    public String getFrom() {
        return this.hitDoc.get("From");
    }

    @Override
    public String getId() {
        return this.hitDoc.get("id");
    }

    @Override
    public boolean hasAttachment() {
        if (this.hitDoc.get("hasAttachment") == null) {
            return false;
        }
        return this.hitDoc.get("hasAttachment").equals("1");
    }
}

