/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ConfiguredArchiveGenerator;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.IBennoConfig;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.proite.mailarchive.rest.tools.ContentType;
import de.proite.mailarchive.rest.tools.MailAttachment;
import de.proite.mailarchive.rest.tools.MimePartResolver;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMultipart;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class BennoAttachmentServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(BennoAttachmentServlet.class);
    private final BennoRest bennoRest;
    private final Benno benno;

    public BennoAttachmentServlet(BennoRest bennoRest, Benno benno) {
        this.bennoRest = bennoRest;
        this.benno = benno;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProccess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProccess(request, response);
    }

    protected void doProccess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block35: {
            response.setContentType("application/json; charset=UTF-8");
            IBennoConfig config = this.bennoRest.getBennoConfig();
            String searchArchive = request.getParameter("archive");
            String searchId = request.getParameter("id");
            String attachment = request.getParameter("attachment");
            String attachmentId = "";
            if (request.getParameterMap().containsKey("attachmentId")) {
                attachmentId = request.getParameter("attachmentId").toString();
            }
            try {
                int bytesRead;
                IContainer myContainer = null;
                for (IArchive aktArchive : new ConfiguredArchiveGenerator(this.benno, config.getArchiveGenerator(), true).getArchives()) {
                    IContainerGenerator containerGen = aktArchive.getContainerGenerator();
                    try {
                        myContainer = containerGen.getContainer(searchArchive);
                        break;
                    }
                    catch (Exception searchEx) {
                    }
                }
                if (myContainer == null) {
                    throw new ContainerNotFoundException(searchArchive);
                }
                MailDocument myDoc = myContainer.getBox().getDocument(searchId);
                if (myDoc == null) {
                    throw new FileNotFoundException("Mail with id '" + searchId + "' not found!");
                }
                MimeMultipart multipart = null;
                ArrayList<JSONObject> attachmentList = new ArrayList<JSONObject>();
                ArrayList<JSONObject> bodyList = new ArrayList<JSONObject>();
                if (!myDoc.getMimeMesage().getContent().getClass().equals(String.class)) {
                    if (!myDoc.getMimeMesage().getContentType().contains("multipart/") && !myDoc.getMimeMesage().getContentType().contains("text/")) {
                        JSONObject tmpAttach = new JSONObject();
                        MailAttachment tmpAttachment = new MailAttachment(myDoc.getMimeMesage().getContentType(), myDoc.getMimeMesage().getSize());
                        tmpAttach.put("name", (Object)tmpAttachment.getFilename());
                        tmpAttach.put("content-type", (Object)tmpAttachment.getContentType());
                        tmpAttach.put("size", tmpAttachment.getSize());
                        attachmentList.add(tmpAttach);
                    } else {
                        multipart = (MimeMultipart)myDoc.getMimeMesage().getContent();
                    }
                }
                if (multipart != null) {
                    MimePartResolver.resolveMimeParts(multipart, attachmentList, bodyList, 0);
                }
                boolean found = false;
                for (JSONObject tmp : attachmentList) {
                    try {
                        if (tmp.get("attachmentId").equals(attachmentId)) {
                            found = true;
                            continue;
                        }
                        if (!tmp.get("name").equals(attachment)) continue;
                        found = true;
                    }
                    catch (JSONException ex) {
                        LOGGER.debug((Object)"MIME part without filename");
                    }
                }
                if (!found) {
                    response.resetBuffer();
                    response.setStatus(404);
                    try {
                        JSONObject errResult = new JSONObject();
                        errResult.put("error", (Object)"attachment not found");
                        errResult.write((Writer)response.getWriter());
                        response.flushBuffer();
                    }
                    catch (Exception ex) {
                        LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
                    }
                }
                LOGGER.debug((Object)multipart);
                if (multipart != null) {
                    ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>();
                    MimePartResolver.getBodyPartList(multipart, bodyParts);
                    int attachmentCounter = 0;
                    for (int i = 0; i < bodyParts.size(); ++i) {
                        int bytesRead2;
                        BodyPart bodyPart = bodyParts.get(i);
                        try {
                            if (bodyPart.getFileName() != null && bodyPart.getFileName() != "" && !attachmentId.equals("")) {
                                if (!attachmentId.equals(Integer.toString(attachmentCounter))) {
                                    ++attachmentCounter;
                                }
                            } else {
                                if (bodyPart.getFileName() == "" || bodyPart.getFileName() == null || bodyPart.getFileName() != null && !bodyPart.getFileName().equalsIgnoreCase(attachment)) continue;
                                if (bodyPart.getDisposition() == null) {
                                }
                            }
                        }
                        catch (Exception ex) {}
                        continue;
                        response.resetBuffer();
                        response.setContentType(bodyPart.getContentType());
                        response.addHeader("Content-Disposition", "attachment; filename=" + attachment);
                        InputStream is = bodyPart.getInputStream();
                        byte[] buf = new byte[4096];
                        while ((bytesRead2 = is.read(buf)) != -1) {
                            response.getOutputStream().write(buf, 0, bytesRead2);
                        }
                        ++attachmentCounter;
                        LOGGER.debug((Object)(request.getSession().getId() + " Requested attachment '" + attachment + "' for mail id '" + searchId + "' - multipart: yes"));
                    }
                    break block35;
                }
                response.resetBuffer();
                String ct = ContentType.bareType(myDoc.getMimeMesage().getContentType());
                response.setContentType(ct);
                response.addHeader("Content-Disposition", "attachment; filename=" + attachment);
                InputStream is = myDoc.getMimeMesage().getInputStream();
                byte[] buf = new byte[4096];
                while ((bytesRead = is.read(buf)) != -1) {
                    response.getOutputStream().write(buf, 0, bytesRead);
                }
                LOGGER.debug((Object)(request.getSession().getId() + " Requested attachment '" + attachment + "' for mail id '" + searchId + "' - multipart: no"));
            }
            catch (ContainerNotFoundException ex) {
                try {
                    JSONObject errResult = new JSONObject();
                    errResult.put("error", (Object)"container not found");
                    errResult.write((Writer)response.getWriter());
                }
                catch (Exception iex) {
                    LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)iex);
                }
                LOGGER.warn((Object)ex.getMessage());
            }
            catch (FileNotFoundException fnfe) {
                LOGGER.debug((Object)("File for ID '" + searchId + "' not found! Continer:" + searchArchive), (Throwable)fnfe);
                response.resetBuffer();
                response.setStatus(404);
                try {
                    JSONObject errResult = new JSONObject();
                    errResult.put("error", (Object)"file not found");
                    errResult.write((Writer)response.getWriter());
                }
                catch (Exception ex) {
                    LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
            }
        }
    }
}

