#!/bin/sh
# postinst script for benno-rest
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    configure)
    if [ ! -f /etc/benno/rest.secret ];then
        if [ -f /etc/benno-web/rest.conf ];then
            cat /etc/benno-web/rest.conf | grep ^SHARED_SECRET |perl -pe 's/^.+=\s*//' >> /etc/benno/rest.secret
        else
            cat /dev/urandom | tr -dc 'a-zA-Z0-9' | fold -w 20 | head -n 1 > /etc/benno/rest.secret
        fi
    fi
    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

chown benno.benno /var/log/benno

if [ -x "/etc/init.d/benno-rest" ]; then
    update-rc.d benno-rest defaults >/dev/null
    if [ -x "`which invoke-rc.d 2>/dev/null`" ]; then
        invoke-rc.d benno-rest start || exit $?
    else
        /etc/init.d/benno-rest start || exit $?
    fi
fi

exit 0
