/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.config.IBennoConfig;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.rest.servlets.ServletTools;
import de.lwsystems.mailarchive.search.IEmailIndex;
import de.lwsystems.mailarchive.search.IFullSearchHit;
import de.lwsystems.mailarchive.search.ISearchHit;
import de.lwsystems.mailarchive.search.ISearchResult;
import de.lwsystems.mailarchive.search.NoSuchObjectException;
import de.lwsystems.mailarchive.search.lucene.LuceneEmailIndex;
import de.lwsystems.mailarchive.utils.Clock;
import de.proite.mailarchive.rest.tools.IBennoLicense;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.queryParser.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BennoSearchServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(BennoSearchServlet.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();
    private final BennoRest bennoRest;
    private final Benno benno;
    private final IBennoLicense bennoLicense;

    public BennoSearchServlet(BennoRest bennoRest, Benno benno, IBennoLicense bennoLicense) {
        this.bennoRest = bennoRest;
        this.benno = benno;
        this.bennoLicense = bennoLicense;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProcess(request, response);
    }

    protected void doProcess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        JSONObject answer = new JSONObject();
        String sessionId = session.getId();
        response.setContentType("application/json; charset=UTF-8");
        response.setStatus(200);
        String licenseStatus = "INVALID";
        try {
            ISearchResult result;
            String sortField = "SortableDate";
            boolean sortAsc = false;
            String filterQuery = "";
            boolean documentCounter = false;
            boolean full = false;
            long cacheTTL = 0L;
            IBennoConfig config = this.bennoRest.getBennoConfig();
            String searchArchive = request.getParameter("archive");
            String queryString = request.getParameter("query");
            if (queryString.contains("Date:[")) {
                queryString = queryString.replaceAll("Date:\\[", "SortableDate:[");
            }
            int start = this.getStartRequestParameter(request, sessionId);
            int hitIndex = start - 1;
            session.setAttribute("lastFirst", (Object)start);
            sortField = this.getSortFieldFromRequest(request, sortField);
            sortAsc = this.getSortDirectionFromRequest(request, sortAsc);
            full = this.getFullRequestParameter(request, full);
            filterQuery = request.getParameter("filterQuery");
            if (filterQuery == null || filterQuery.equals("")) {
                LOGGER.error((Object)(sessionId + "Parameter \"filterQuery\" empty or not set."));
                BennoSearchServlet.badRequest(response, "Request filter error!", "Parameter \"filterQuery\" empty or not set in request.");
                return;
            }
            cacheTTL = config.getBennoRestConfig().getIndexCacheTTL();
            IContainer myContainer = null;
            if (session.getAttribute("myContainer") == null || session.getAttribute("myArchive") == null || session.getAttribute("myContainer") != searchArchive) {
                myContainer = ServletTools.getContainer(searchArchive, this.benno);
                session.setAttribute("myContainer", (Object)myContainer);
                session.setAttribute("lastQuery", null);
                cacheTTL = 0L;
            } else {
                myContainer = (IContainer)session.getAttribute("myContainer");
            }
            IEmailIndex index = this.getIndex(myContainer, searchArchive);
            this.bennoLicense.bennoTestPeriodCheck(index);
            licenseStatus = this.bennoLicense.getLicenseStatus();
            if (licenseStatus.equals("INVALID")) {
                LOGGER.warn((Object)"License invalid, filter disabled: \"(*)\"");
                filterQuery = "*";
            }
            answer.put("licenseValid", (Object)licenseStatus);
            if (this.isResultCachedInSession(session, queryString, sortField, sortAsc, filterQuery) && Clock.getProvider().newDate().getTime() - (Long)session.getAttribute("lastTime") <= 120000L) {
                result = this.getResultFromSession(session);
                this.logDebug(sessionId + " Using cached result - Result from: " + session.getAttribute("lastTime"));
                this.logDebug(sessionId + " Time-Diff: " + (Clock.getProvider().newDate().getTime() - (Long)session.getAttribute("lastTime")));
            } else {
                result = index.search(sessionId, sortField, queryString, filterQuery, cacheTTL, sortAsc);
                session.setAttribute("lastTime", (Object)Clock.getProvider().newDate().getTime());
                session.setAttribute("lastQuery", (Object)queryString);
                session.setAttribute("lastResult", (Object)result);
                session.setAttribute("lastSortField", (Object)sortField);
                session.setAttribute("lastFilterQuery", (Object)filterQuery);
                session.setAttribute("lastSortAsc", (Object)sortAsc);
            }
            JSONArray results = new JSONArray();
            int limit = this.getLimitRequestParameter(request, sessionId);
            answer.put("limit", limit);
            if (!full) {
                Iterable<ISearchHit> hits = result.getHits(hitIndex, limit);
                for (ISearchHit hit : hits) {
                    JSONObject temp = ServletTools.createJson(hit);
                    results.put((Object)temp);
                }
            } else {
                Iterable<IFullSearchHit> hits = result.getFullHits(hitIndex, limit);
                for (IFullSearchHit hit : hits) {
                    JSONObject temp = ServletTools.createJson(hit);
                    results.put((Object)temp);
                }
            }
            answer.put("results", (Object)results);
            answer.put("count", results.length());
            answer.put("found", result.getHitCount());
            answer.put("overall", (Object)result.getOverallHitCount());
            answer.put("first", start);
            answer.put("last", Math.min(limit + start - 1, start + results.length() - 1));
            if (results.length() == 0) {
                answer.put("last", -1);
                answer.put("first", -1);
            }
            answer.write((Writer)response.getWriter());
        }
        catch (NoSuchObjectException nsoe) {
            try {
                answer.put("found", (Object)"0");
                answer.put("count", (Object)"0");
                answer.put("first", (Object)"-1");
                answer.put("last", (Object)"-1");
                answer.put("overall", nsoe.getOverall());
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            response.resetBuffer();
            response.getWriter().println(answer.toString());
        }
        catch (ContainerNotFoundException cnfe) {
            LOGGER.warn((Object)cnfe.getMessage());
            response.resetBuffer();
            response.setStatus(404);
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"container not found");
                errResult.write((Writer)response.getWriter());
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
            }
        }
        catch (ParseException pex) {
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"Invalid query");
                errResult.write((Writer)response.getWriter());
                LOGGER.warn((Object)(sessionId + " Invalid query string: " + request.getParameter("query")));
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"Uncaught Exception", (Throwable)ex);
            }
        }
        catch (CorruptIndexException e) {
            response.setStatus(901);
        }
        catch (Exception e) {
            response.setStatus(503);
            LOGGER.fatal((Object)"Uncaught Exception", (Throwable)e);
        }
    }

    private IEmailIndex getIndex(IContainer myContainer, String searchArchive) {
        return new LuceneEmailIndex(myContainer, searchArchive);
    }

    public boolean isResultCachedInSession(HttpSession session, String queryString, String sortField, boolean sortAsc, String filterQuery) {
        return session.getAttribute("lastQuery") != null && session.getAttribute("lastQuery").equals(queryString) && session.getAttribute("lastSortField") != null && session.getAttribute("lastSortField").equals(sortField) && session.getAttribute("lastSortAsc") != null && session.getAttribute("lastSortAsc").equals(sortAsc) && session.getAttribute("lastFilterQuery").equals(filterQuery) && session.getAttribute("lastFirst") != null;
    }

    public boolean getFullRequestParameter(HttpServletRequest request, boolean full) {
        if (request.getParameter("full") != null && request.getParameter("full").equals("true")) {
            full = true;
        }
        return full;
    }

    public boolean getSortDirectionFromRequest(HttpServletRequest request, boolean sortAsc) {
        if (request.getParameter("sortAsc") != null && request.getParameter("sortAsc").equals("false")) {
            sortAsc = true;
        }
        return sortAsc;
    }

    public String getSortFieldFromRequest(HttpServletRequest request, String sortField) {
        if (request.getParameter("sort") != null && ((sortField = request.getParameter("sort")).equals("Date") || sortField.equals("Subject"))) {
            sortField = "Sortable" + sortField;
        }
        return sortField;
    }

    public int getStartRequestParameter(HttpServletRequest request, String sessionId) {
        int start;
        if (request.getParameter("start") != null) {
            try {
                start = Integer.parseInt(request.getParameter("start"));
                if (start < 1) {
                    start = 1;
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)(sessionId + " Error reading parameter \"start\": " + ex));
                start = 1;
            }
        } else {
            start = 1;
        }
        return start;
    }

    public int getLimitRequestParameter(HttpServletRequest request, String sessionId) {
        int limit;
        if (request.getParameter("limit") != null) {
            try {
                limit = Integer.parseInt(request.getParameter("limit"));
                if (limit < 0) {
                    limit = 0;
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)(sessionId + " Error reading parameter \"limit\": " + ex));
                limit = 20;
            }
        } else {
            limit = 20;
        }
        return limit;
    }

    private ISearchResult getResultFromSession(HttpSession session) {
        return (ISearchResult)session.getAttribute("lastResult");
    }

    private static void badRequest(HttpServletResponse response, String title, String content) throws IOException {
        response.setStatus(400);
        response.getWriter().print("<html><head>");
        response.getWriter().print("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>");
        response.getWriter().print("<title>" + title + "</title>");
        response.getWriter().print("<h2>HTTP ERROR: 400</h2>");
        response.getWriter().print("<p>" + content + "</p>");
        response.flushBuffer();
    }

    private void logDebug(String msg) {
        Logger LOGGER = Logger.getLogger(BennoSearchServlet.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)msg);
        }
    }
}

