/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.search.lucene;

import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.rest.servlets.BennoSearchServlet;
import de.lwsystems.mailarchive.search.BadRequestException;
import de.lwsystems.mailarchive.search.IEmailIndex;
import de.lwsystems.mailarchive.search.ISearchResult;
import de.lwsystems.mailarchive.search.NoSuchObjectException;
import de.lwsystems.mailarchive.search.lucene.LuceneSearchResult;
import de.proite.mailarchive.rest.tools.BennoFilterManager;
import de.proite.mailarchive.rest.tools.BennoSearcherManager;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.CachingWrapperFilter;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldCollector;

public class LuceneEmailIndex
implements IEmailIndex {
    private static final Logger LOGGER = Logger.getLogger(BennoSearchServlet.class);
    private IContainer myContainer;
    private String searchArchive;
    private IndexSearcher isearcher;
    private IndexReader ireader;
    private Query query;
    private Analyzer analyzer;
    private String queryString;
    private boolean initialized;

    public LuceneEmailIndex(IContainer myContainer, String searchArchive) {
        this.myContainer = myContainer;
        this.searchArchive = searchArchive;
    }

    private void logDebug(String msg) {
        Logger LOGGER = Logger.getLogger(LuceneEmailIndex.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)msg);
        }
    }

    @Override
    public ISearchResult search(String debugPrefix, String sortField, String queryString, String filterQuery, long cacheTTL, boolean sortAsc) throws IOException, ParseException, BadRequestException, NoSuchObjectException {
        this.logDebug(debugPrefix + " Archive: " + this.myContainer.getArchive().getIdentifier());
        this.logDebug(debugPrefix + " Container: " + this.myContainer.getIdentifier());
        this.initReader(cacheTTL);
        if (queryString.startsWith("#RepoPath:")) {
            queryString = queryString.replaceFirst("#RepoPath:", "id:");
            queryString = queryString.replaceFirst("/", "\\\\:");
            if ((queryString = queryString.replace("/", "")).indexOf(".") > 0) {
                queryString = queryString.substring(0, queryString.lastIndexOf("."));
            }
            this.analyzer = new KeywordAnalyzer();
        } else {
            this.analyzer = new ClassicAnalyzer(this.myContainer.getIndexVersion());
        }
        QueryParser parser = new QueryParser(this.myContainer.getIndexVersion(), "Subject", this.analyzer);
        parser.setAllowLeadingWildcard(true);
        this.logDebug(debugPrefix + " Request-Query: " + queryString);
        this.query = parser.parse(queryString);
        this.logDebug(debugPrefix + " Parsed-Query: " + this.query.toString());
        if (sortField != null) {
            this.logDebug(debugPrefix + " SortField: " + sortField.toString());
        }
        CachingWrapperFilter filter = null;
        filter = BennoFilterManager.getInstance(parser).getFilter(filterQuery);
        if (filter == null) {
            LOGGER.warn((Object)(debugPrefix + " Invalid filterQuery string: " + filterQuery));
            LOGGER.error((Object)(debugPrefix + "Invalid \"filterQuery\" string."));
            throw new BadRequestException("Request filter string invalid!", "Syntax error in \"filterQuery\" string.");
        }
        this.logDebug(debugPrefix + " Filter: " + filter.toString());
        int sortType = sortField.equals("SortableDate") ? 6 : 3;
        this.isearcher.setDefaultFieldSortScoring(false, false);
        TopFieldCollector results = TopFieldCollector.create((Sort)new Sort(new SortField(sortField, sortType, sortAsc)), (int)10000000, (boolean)false, (boolean)false, (boolean)false, (boolean)sortAsc);
        this.logDebug(debugPrefix + " Start searching for documents with filter.");
        this.isearcher.search(this.query, (Filter)filter, (Collector)results);
        ScoreDoc[] hits = results.topDocs((int)0).scoreDocs;
        this.logDebug(debugPrefix + " Query returns " + hits.length + " results");
        int overAll = this.ireader.numDocs();
        if (hits.length <= 0) {
            throw new NoSuchObjectException("No results found!", overAll);
        }
        return new LuceneSearchResult(hits, overAll, this.isearcher);
    }

    @Override
    public Date getFirstIndexDate() {
        this.initialized = false;
        long testCacheTTL = 1000L;
        this.initReader(1000L);
        String indexOlderTS = "20000101000000000";
        String indexTS = "";
        try {
            indexTS = this.ireader.document(0).get("IndexTS");
            if (indexTS == null) {
                this.logDebug("Document indexed with Benno < v2.1.5");
                indexTS = "20000101000000000";
            }
            return new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT).parse(indexTS);
        }
        catch (CorruptIndexException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (java.text.ParseException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error((Object)("Index not yet initialized: " + e.toString()));
            try {
                return new SimpleDateFormat("yyyyMMddHHmmssSSS", Locale.ROOT).parse(indexOlderTS);
            }
            catch (java.text.ParseException e2) {
                throw new RuntimeException(e2);
            }
        }
    }

    private void initReader(long cacheTTL) {
        if (!this.initialized) {
            this.isearcher = BennoSearcherManager.getInstance(cacheTTL).getSearcher(this.myContainer);
            try {
                this.ireader = this.isearcher.getIndexReader();
            }
            catch (NullPointerException e) {
                throw new RuntimeException("Archive \"" + this.searchArchive + "\"not initialized! Please import some emails", e);
            }
            this.initialized = true;
        }
    }
}

