/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import com.sun.mail.util.BASE64DecoderStream;
import com.sun.mail.util.BASE64EncoderStream;
import de.proite.mailarchive.rest.tools.ContentType;
import de.proite.mailarchive.rest.tools.MailAttachment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.eclipse.jetty.io.WriterOutputStream;
import org.json.JSONException;
import org.json.JSONObject;

public class MimePartResolver {
    private static final Logger LOGGER = Logger.getLogger(MimePartResolver.class);
    private static int attachmentCounter = 0;

    public static void resolveMimeParts(MimeMultipart mm, ArrayList<JSONObject> attachments, ArrayList<JSONObject> bodies, int attachmentCounter) throws MessagingException, IOException {
        int[] bodyPartCount = new int[]{0, 0};
        MimePartResolver.resolveMimeParts(mm, attachments, bodies, bodyPartCount, attachmentCounter);
    }

    public static void resolveMimeParts(MimeMultipart mm, ArrayList<JSONObject> attachments, ArrayList<JSONObject> bodies, int[] bodyPartCount, int aCounter) throws MessagingException, IOException {
        attachmentCounter = aCounter;
        for (int i = 0; i < mm.getCount(); ++i) {
            String inlineName;
            BodyPart bp = mm.getBodyPart(i);
            boolean isMultiPart = false;
            try {
                if (bp.getContent().getClass().equals(MimeMultipart.class)) {
                    isMultiPart = true;
                }
            }
            catch (UnsupportedEncodingException ex) {
                isMultiPart = false;
                bp.setHeader("Content-Type", ContentType.bareType(bp));
                LOGGER.info((Object)("Detected unsupported charset in Content-Type-Header. Force Content-Type to: " + ContentType.bareType(bp)));
            }
            if (isMultiPart) {
                MimePartResolver.resolveMimeParts((MimeMultipart)bp.getContent(), attachments, bodies, attachmentCounter);
                continue;
            }
            JSONObject file = new JSONObject();
            String fileName = null;
            try {
                fileName = bp.getFileName();
            }
            catch (ParseException exception) {
                fileName = "";
            }
            try {
                inlineName = MimePartResolver.setNameToUnknownFile(bp, attachmentCounter, bp.getHeader("Content-ID")[0]);
            }
            catch (NullPointerException e) {
                try {
                    inlineName = MimePartResolver.setNameToUnknownFile(bp, attachmentCounter, bp.getHeader("Content-Id")[0]);
                }
                catch (NullPointerException ex) {
                    inlineName = "";
                }
            }
            if (fileName == null) {
                try {
                    fileName = MimePartResolver.setNameToUnknownFile(bp, attachmentCounter, inlineName);
                }
                catch (Exception e) {
                    fileName = MimePartResolver.setNameToUnknownFile(bp, attachmentCounter, "empty");
                }
            }
            if (fileName != null && fileName != "") {
                MailAttachment tmpAttachment = new MailAttachment(bp);
                MimePartResolver.putAttribute(file, "content-type", tmpAttachment.getContentType());
                if (tmpAttachment.getFilename() == null) {
                    MimePartResolver.putAttribute(file, "name", fileName);
                } else {
                    MimePartResolver.putAttribute(file, "name", tmpAttachment.getFilename());
                }
                MimePartResolver.putAttribute(file, "content-id", inlineName);
                MimePartResolver.putAttribute(file, "size", tmpAttachment.getSize());
                MimePartResolver.putAttribute(file, "attachmentId", Integer.toString(attachmentCounter));
                attachments.add(file);
                ++attachmentCounter;
                continue;
            }
            MimePartResolver.putAttribute(file, "content-type", ContentType.bareType(bp));
            MimePartResolver.putAttribute(file, "data", MimePartResolver.decodeContent(bp));
            if (ContentType.bareType(bp).toLowerCase().equals("text/plain")) {
                int n = bodyPartCount[0];
                bodyPartCount[0] = n + 1;
                if (n < 1) {
                    bodies.add(file);
                    continue;
                }
                attachments.add(file);
                continue;
            }
            if (ContentType.bareType(bp).toLowerCase().equals("text/html")) {
                int n = bodyPartCount[1];
                bodyPartCount[1] = n + 1;
                if (n < 1) {
                    bodies.add(file);
                    continue;
                }
                attachments.add(file);
                continue;
            }
            attachments.add(file);
        }
    }

    public static String decodeContent(BodyPart bp) {
        String returnContent;
        try {
            Object content = bp.getContent();
            if (content instanceof BASE64DecoderStream) {
                BASE64DecoderStream stream = (BASE64DecoderStream)content;
                StringWriter writer = new StringWriter();
                BASE64EncoderStream base64Stream = new BASE64EncoderStream((OutputStream)new WriterOutputStream((Writer)writer));
                IOUtils.copy((InputStream)stream, (OutputStream)base64Stream);
                returnContent = writer.getBuffer().toString();
            } else {
                returnContent = content.toString();
            }
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)"Error decode body content: ", (Throwable)ex);
            returnContent = "";
        }
        return returnContent;
    }

    public static void getInlineAttachment(MimeMultipart mm, HashMap<String, String> base64Value) throws MessagingException, IOException {
        boolean isMultiPart = false;
        for (int i = 0; i < mm.getCount(); ++i) {
            String fileName;
            BodyPart bp = mm.getBodyPart(i);
            try {
                if (bp.getContent().getClass().equals(MimeMultipart.class)) {
                    isMultiPart = true;
                }
            }
            catch (UnsupportedEncodingException ex) {
                isMultiPart = false;
                bp.setHeader("Content-Type", ContentType.bareType(bp));
                LOGGER.info((Object)("Detected unsupported charset in Content-Type-Header. Force Content-Type to: " + ContentType.bareType(bp)));
            }
            if (isMultiPart) {
                try {
                    MimePartResolver.getInlineAttachment((MimeMultipart)bp.getContent(), base64Value);
                }
                catch (Exception e) {
                    isMultiPart = false;
                }
            }
            if (isMultiPart) continue;
            try {
                fileName = bp.getHeader("Content-ID")[0];
            }
            catch (NullPointerException es) {
                try {
                    fileName = bp.getHeader("Content-Id")[0];
                }
                catch (NullPointerException ex) {
                    fileName = "empty";
                }
            }
            if (fileName.contains("empty")) continue;
            fileName = fileName.replaceAll("[<>]", "");
            base64Value.put(fileName, MimePartResolver.decodeContent(bp).replaceAll("\\r\\n", ""));
        }
    }

    public static ArrayList<JSONObject> convertInlineImageToBase64(MimeMultipart mimePart, ArrayList<JSONObject> body) throws MessagingException, IOException {
        Integer counter = 0;
        for (JSONObject bodyPart : body) {
            Pattern pattern = Pattern.compile("<img\\b[^>]*src\\s*=\\s*\"(cid[^\"]*)\"[^>]*>");
            String bodyData = bodyPart.getString("data").replaceAll("\r?\n", "");
            Matcher matcher = pattern.matcher(bodyData);
            HashMap<String, String> base64Value = new HashMap<String, String>();
            MimePartResolver.getInlineAttachment(mimePart, base64Value);
            matcher.matches();
            while (matcher.find()) {
                if (!matcher.group(1).contains("cid:")) continue;
                try {
                    if (!base64Value.containsKey(matcher.group(1).substring(4))) continue;
                    String base64Data = "data:image/png;base64," + base64Value.get(matcher.group(1).substring(4));
                    bodyData = bodyData.replace(matcher.group(1), base64Data);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("Convert inline image \"" + matcher.group(1).substring(4) + "\""));
                    }
                    body.get(counter).put("data", (Object)bodyData);
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage());
                }
            }
            Integer n = counter;
            Integer n2 = counter = Integer.valueOf(counter + 1);
        }
        return body;
    }

    public static void putAttribute(JSONObject json, String attr, String value) {
        try {
            json.put(attr, (Object)value);
        }
        catch (JSONException ex) {
            LOGGER.warn((Object)("Cannot set string attribute " + attr + " to " + value + ": "), (Throwable)ex);
        }
    }

    public static void putAttribute(JSONObject json, String attr, int value) {
        try {
            json.put(attr, value);
        }
        catch (JSONException ex) {
            LOGGER.warn((Object)("Cannot set integer attribute " + attr + " to " + value + ": "), (Throwable)ex);
        }
    }

    public static String setNameToUnknownFile(BodyPart bp, Integer fileNumber, String contentId) {
        if ((contentId = contentId.replaceAll("[<>]", "")).matches("[\\w,\\s-]+\\.[A-Za-z]{3,}")) {
            return contentId;
        }
        if (ContentType.bareType(bp).toString().equals("message/rfc822")) {
            return "ForwardedMail_" + fileNumber + ".eml";
        }
        if (ContentType.bareType(bp).toString().equals("image/png")) {
            if (contentId.equals("empty")) {
                return "image_" + fileNumber + ".png";
            }
            return contentId + ".png";
        }
        if (ContentType.bareType(bp).toString().equals("image/jpeg")) {
            if (contentId.equals("empty")) {
                return "image_" + fileNumber + ".jpeg";
            }
            return contentId + ".jpeg";
        }
        if (ContentType.bareType(bp).toString().equals("image/jpg")) {
            if (contentId.equals("empty")) {
                return "image_" + fileNumber + ".jpeg";
            }
            return contentId + ".jpeg";
        }
        if (ContentType.bareType(bp).toString().equals("image/tiff")) {
            if (contentId.equals("empty")) {
                return "image_" + fileNumber + ".tiff";
            }
            return contentId + ".tiff";
        }
        if (ContentType.bareType(bp).toString().equals("image/gif")) {
            if (contentId.equals("empty")) {
                return "image_" + fileNumber + ".gif";
            }
            return contentId + ".gif";
        }
        return "";
    }

    public static void getBodyPartList(MimeMultipart mm, ArrayList<BodyPart> bodyParts) throws MessagingException, IOException {
        ArrayList bodyPart = new ArrayList();
        for (int i = 0; i < mm.getCount(); ++i) {
            BodyPart bp = mm.getBodyPart(i);
            boolean isMultiPart = false;
            try {
                if (bp.getContent().getClass().equals(MimeMultipart.class)) {
                    isMultiPart = true;
                }
            }
            catch (UnsupportedEncodingException ex) {
                isMultiPart = false;
                bp.setHeader("Content-Type", ContentType.bareType(bp));
                LOGGER.info((Object)("Detected unsupported charset in Content-Type-Header. Force Content-Type to: " + bp.getContentType()));
            }
            if (isMultiPart) {
                MimePartResolver.getBodyPartList((MimeMultipart)bp.getContent(), bodyParts);
                continue;
            }
            bodyParts.add(bp);
        }
    }
}

