/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ConfiguredArchiveGenerator;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.IBennoConfig;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.rest.servlets.BennoSearchServlet;
import de.lwsystems.mailarchive.rest.servlets.ServletTools;
import de.lwsystems.mailarchive.search.IEmailIndex;
import de.lwsystems.mailarchive.search.NoSuchObjectException;
import de.lwsystems.mailarchive.search.lucene.LuceneEmailIndex;
import de.lwsystems.mailarchive.utils.ILicense;
import de.proite.mailarchive.rest.tools.BennoSearcherManager;
import de.proite.mailarchive.rest.tools.IBennoLicense;
import de.proite.mailarchive.rest.tools.MailboxCollector;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.lucene.queryParser.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BennoStatsServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(BennoSearchServlet.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();
    private final BennoRest bennoRest;
    private final Benno benno;
    private final ILicense license;
    private final IBennoLicense bennoLicense;

    public BennoStatsServlet(BennoRest bennoRest, Benno benno, ILicense license, IBennoLicense bennoLicense) {
        this.bennoRest = bennoRest;
        this.benno = benno;
        this.license = license;
        this.bennoLicense = bennoLicense;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProccess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doProccess(request, response);
    }

    protected void doProccess(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        JSONObject answer = new JSONObject();
        String sessionId = session.getId();
        response.setContentType("application/json; charset=UTF-8");
        response.setStatus(200);
        String licenseStatus = "INVALID";
        try {
            Integer mincount;
            String sortField = "SortableDate";
            boolean sortAsc = false;
            String filterQuery = "";
            Integer showMails = 0;
            boolean documentCounter = false;
            boolean full = false;
            long cacheTTL = 0L;
            IBennoConfig config = this.bennoRest.getBennoConfig();
            String searchArchive = request.getParameter("archive");
            String queryString = request.getParameter("query");
            if (queryString.contains("Date:[") && !queryString.contains("SortableDate:[")) {
                LOGGER.warn((Object)"\"Date\" query instead of \"SortableDate\".");
            }
            if (!queryString.contains("Sender:") && !queryString.contains("SenderDomain:")) {
                queryString = queryString + " AND Sender:*@" + this.license.getMaildomain();
            }
            try {
                showMails = Integer.parseInt(request.getParameter("showmails"));
                mincount = Integer.parseInt(request.getParameter("mincount"));
            }
            catch (Exception e) {
                mincount = 1;
                showMails = 0;
            }
            int start = this.getStartRequestParameter(request, sessionId);
            int hitIndex = start - 1;
            session.setAttribute("lastFirst", (Object)start);
            sortField = this.getSortFieldFromRequest(request, sortField);
            sortAsc = this.getSortDirectionFromRequest(request, sortAsc);
            full = this.getFullRequestParameter(request, full);
            filterQuery = request.getParameter("filterQuery");
            if (filterQuery == null || filterQuery.equals("")) {
                LOGGER.error((Object)(sessionId + "Parameter \"filterQuery\" empty or not set."));
                return;
            }
            if (filterQuery.contains("Date:[") && !filterQuery.contains("SortableDate:[")) {
                LOGGER.warn((Object)"\"Date\" filter instead of \"SortableDate\".");
            }
            cacheTTL = config.getBennoRestConfig().getIndexCacheTTL();
            IContainer myContainer = null;
            if (session.getAttribute("myContainer") == null || session.getAttribute("myArchive") == null || session.getAttribute("myContainer") != searchArchive) {
                myContainer = ServletTools.getContainer(searchArchive, this.benno);
                session.setAttribute("myContainer", (Object)myContainer);
                session.setAttribute("lastQuery", null);
                cacheTTL = 0L;
            } else {
                myContainer = (IContainer)session.getAttribute("myContainer");
            }
            IEmailIndex index = this.getIndex(myContainer, searchArchive);
            this.bennoLicense.bennoTestPeriodCheck(index);
            licenseStatus = this.bennoLicense.getLicenseStatus();
            if (licenseStatus.equals("INVALID")) {
                filterQuery = "*";
            }
            answer.put("licenseValid", (Object)licenseStatus);
            MailboxCollector mailboxCol = index.mailboxSearch(sessionId, sortField, queryString, filterQuery, cacheTTL, sortAsc);
            JSONArray results = new JSONArray();
            Integer mailCount = 0;
            if (showMails == 0) {
                Map<String, Integer> ar = mailboxCol.getDomainCount();
                Iterator<Map.Entry<String, Integer>> it = ar.entrySet().iterator();
                while (it.hasNext()) {
                    JSONObject temp = new JSONObject();
                    Map.Entry<String, Integer> pair = it.next();
                    if (pair.getValue() >= mincount) {
                        temp.put("SenderGroup", (Object)pair.getKey());
                        temp.put("SenderCount", (Object)pair.getValue());
                        mailCount = mailCount + pair.getValue();
                        results.put((Object)temp);
                    }
                    temp = null;
                    pair = null;
                }
            } else {
                Map<String, Integer> ar = mailboxCol.getAddressCount();
                Iterator<Map.Entry<String, Integer>> it = ar.entrySet().iterator();
                while (it.hasNext()) {
                    JSONObject temp = new JSONObject();
                    Map.Entry<String, Integer> pair = it.next();
                    if (pair.getValue() >= mincount) {
                        temp.put("SenderAddress", (Object)pair.getKey());
                        temp.put("SendMails", (Object)pair.getValue());
                        mailCount = mailCount + pair.getValue();
                        results.put((Object)temp);
                    }
                    temp = null;
                    pair = null;
                }
            }
            answer.put("hostinfo", (Object)this.bennoRest.getHostInfo());
            answer.put("container", (Object)searchArchive);
            answer.put("query", (Object)queryString);
            answer.put("mailCount", (Object)mailCount);
            answer.put("collectErrors", (Object)mailboxCol.mailErrors);
            answer.put("collectWarnings", (Object)mailboxCol.mailWarnings);
            answer.put("collectCount", (Object)mailboxCol.mailCount);
            answer.put("filter", (Object)filterQuery);
            answer.put("showMails", (Object)showMails);
            answer.put("minCount", (Object)mincount);
            answer.put("containerList", (Object)this.getContainerList(this.bennoRest));
            answer.put("addressList", (Object)results);
            mailboxCol = null;
            answer.write((Writer)response.getWriter());
        }
        catch (NoSuchObjectException nsoe) {
            try {
                answer.put("found", (Object)"0");
                answer.put("count", (Object)"0");
                answer.put("first", (Object)"-1");
                answer.put("last", (Object)"-1");
                answer.put("overall", nsoe.getOverall());
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            response.resetBuffer();
            response.getWriter().println(answer.toString());
        }
        catch (ContainerNotFoundException cnfe) {
            LOGGER.warn((Object)cnfe.getMessage());
            response.resetBuffer();
            response.setStatus(404);
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"container not found");
                errResult.write((Writer)response.getWriter());
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
            }
        }
        catch (ParseException pex) {
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"Invalid query");
                errResult.write((Writer)response.getWriter());
                LOGGER.warn((Object)(sessionId + " Invalid query string: " + request.getParameter("query")));
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"Uncaught Exception", (Throwable)ex);
            }
        }
        catch (Exception e) {
            response.setStatus(503);
            LOGGER.fatal((Object)"Uncaught Exception", (Throwable)e);
        }
    }

    private IEmailIndex getIndex(IContainer myContainer, String searchArchive) {
        return new LuceneEmailIndex(myContainer, searchArchive);
    }

    public boolean isResultCachedInSession(HttpSession session, String queryString, String sortField, boolean sortAsc, String filterQuery) {
        return session.getAttribute("lastQuery") != null && session.getAttribute("lastQuery").equals(queryString) && session.getAttribute("lastSortField") != null && session.getAttribute("lastSortField").equals(sortField) && session.getAttribute("lastSortAsc") != null && session.getAttribute("lastSortAsc").equals(sortAsc) && session.getAttribute("lastFilterQuery").equals(filterQuery) && session.getAttribute("lastFirst") != null;
    }

    public boolean getFullRequestParameter(HttpServletRequest request, boolean full) {
        if (request.getParameter("full") != null && request.getParameter("full").equals("true")) {
            full = true;
        }
        return full;
    }

    public boolean getSortDirectionFromRequest(HttpServletRequest request, boolean sortAsc) {
        if (request.getParameter("sortAsc") != null && request.getParameter("sortAsc").equals("false")) {
            sortAsc = true;
        }
        return sortAsc;
    }

    public String getSortFieldFromRequest(HttpServletRequest request, String sortField) {
        if (request.getParameter("sort") != null && ((sortField = request.getParameter("sort")).equals("Date") || sortField.equals("Subject"))) {
            sortField = "Sortable" + sortField;
        }
        return sortField;
    }

    public int getStartRequestParameter(HttpServletRequest request, String sessionId) {
        int start;
        if (request.getParameter("start") != null) {
            try {
                start = Integer.parseInt(request.getParameter("start"));
                if (start < 1) {
                    start = 1;
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)(sessionId + " Error reading parameter \"start\": " + ex));
                start = 1;
            }
        } else {
            start = 1;
        }
        return start;
    }

    public int getLimitRequestParameter(HttpServletRequest request, String sessionId) {
        int limit;
        if (request.getParameter("limit") != null) {
            try {
                limit = Integer.parseInt(request.getParameter("limit"));
                if (limit < 0) {
                    limit = 0;
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)(sessionId + " Error reading parameter \"limit\": " + ex));
                limit = 20;
            }
        } else {
            limit = 20;
        }
        return limit;
    }

    private void logDebug(String msg) {
        Logger LOGGER = Logger.getLogger(BennoSearchServlet.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)msg);
        }
    }

    private JSONArray getContainerList(BennoRest bennoRest) {
        JSONArray containerInfo = new JSONArray();
        IBennoConfig config = bennoRest.getBennoConfig();
        for (IArchive aktArchive : new ConfiguredArchiveGenerator(this.benno, config.getArchiveGenerator(), true).getArchives()) {
            IContainerGenerator containerGen = aktArchive.getContainerGenerator();
            try {
                for (IContainer container : containerGen.getContainers()) {
                    JSONObject aktContainer = new JSONObject();
                    aktContainer.putOnce("name", (Object)container.getIdentifier());
                    aktContainer.putOnce("mailCount", (Object)BennoSearcherManager.getInstance(config.getBennoRestConfig().getIndexCacheTTL()).getSearcher(container).getIndexReader().numDocs());
                    containerInfo.put((Object)aktContainer);
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Unexcpeted excpetion:  " + ex));
            }
        }
        return containerInfo;
    }
}

