/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import de.proite.mailarchive.rest.tools.ContentType;
import de.proite.mailarchive.rest.tools.MimePartResolver;
import java.io.UnsupportedEncodingException;
import javax.mail.BodyPart;
import javax.mail.internet.MimeUtility;
import org.apache.log4j.Logger;

public class MailAttachment {
    private String filename;
    private String contentType;
    private int size;
    private static final Logger LOGGER = Logger.getLogger(MimePartResolver.class);

    public MailAttachment() {
        this.filename = "";
        this.contentType = "";
        this.size = 0;
    }

    public MailAttachment(BodyPart bp) {
        try {
            this.filename = bp.getFileName();
            this.contentType = ContentType.bareType(bp);
            this.size = bp.getSize();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MailAttachment(String contentType, int size) {
        this.contentType = ContentType.bareType(contentType);
        if (contentType.contains("name=")) {
            this.filename = contentType.replaceAll(this.contentType + ";", "").replaceAll("\\s+", "").replaceAll("name=", "").replaceAll("\"", "");
        } else if (contentType.contains("filename=")) {
            this.filename = contentType.replaceAll(this.contentType + ";", "").replaceAll("\\s+", "").replaceAll("filename=", "").replaceAll("\"", "");
        }
        this.size = size;
    }

    public String getFilename() {
        String normName;
        if (this.filename == null) {
            return null;
        }
        try {
            normName = MimeUtility.decodeText((String)this.filename);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.info((Object)("Cannot decode filename: " + ex));
            normName = this.filename;
        }
        return normName;
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        return null;
    }

    public int getSize() {
        return this.size;
    }
}

