/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.box.IBoxHolder;
import de.lwsystems.mailarchive.index.LuceneIndex;
import de.lwsystems.mailarchive.maildocument.ArchivedMailDocument;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.rest.api.MailResult;
import de.lwsystems.mailarchive.utils.ILicense;
import de.lwsystems.mailarchive.utils.TestUtils;
import de.proite.mailarchive.rest.tools.JsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.log4j.Logger;
import org.apache.lucene.document.AbstractField;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.json.JSONException;
import org.json.JSONObject;
import org.junit.rules.TemporaryFolder;

public class BennoEmlTestServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(BennoEmlTestServlet.class);
    private final BennoRest bennoRest;
    private final Benno benno;
    private final ILicense license;

    public BennoEmlTestServlet(BennoRest bennoRest, Benno benno, ILicense license) {
        this.bennoRest = bennoRest;
        this.benno = benno;
        this.license = license;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json; charset=UTF-8");
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)fileItemFactory);
        JSONObject result = new JSONObject();
        try {
            List fileItems = servletFileUpload.parseRequest(request);
            for (FileItem fileItem : fileItems) {
                if (fileItem.isFormField()) continue;
                result.put("fileName", (Object)fileItem.getName());
                InputStream inputStream = fileItem.getInputStream();
                TemporaryFolder testFolder = new TemporaryFolder();
                testFolder.create();
                File tempFolder = testFolder.newFolder("folder");
                System.out.println("Test folder: " + testFolder.getRoot());
                LuceneIndex index = new LuceneIndex(this.benno, (IBoxHolder)new TestUtils.TestBoxHolder(), tempFolder, false, Integer.valueOf(120));
                try {
                    ArchivedMailDocument docId = TestUtils.parseStream((InputStream)inputStream);
                    try {
                        index.addDocument(docId);
                    }
                    catch (Exception e) {
                        result.append("indexException", (Object)TestUtils.stackTraceToString((Exception)e));
                    }
                    inputStream.close();
                    index.closeIndexWriter();
                    try {
                        MailResult jsonObject = JsonBuilder.createFullJsonDocument(docId.getDocument());
                        result.append("jsonData", (Object)jsonObject);
                    }
                    catch (Exception e) {
                        result.append("serializeException", (Object)TestUtils.stackTraceToString((Exception)e));
                    }
                    IndexReader reader = IndexReader.open((Directory)new SimpleFSDirectory(tempFolder));
                    Document doc = reader.document(0);
                    String foundDocId = doc.get("docId");
                    JSONObject indexData = new JSONObject();
                    List fieldList = doc.getFields();
                    for (AbstractField field : fieldList) {
                        indexData.put(field.name(), (Object)field.stringValue());
                    }
                    result.append("indexData", (Object)indexData);
                }
                catch (Exception e) {
                    result.append("otherException", (Object)TestUtils.stackTraceToString((Exception)e));
                }
                System.out.println(result.toString(4));
            }
        }
        catch (Exception e) {
            try {
                result.put("otherException", (Object)TestUtils.stackTraceToString((Exception)e));
            }
            catch (JSONException e1) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)e1);
            }
        }
        try {
            result.write((Writer)out);
        }
        catch (JSONException e) {
            LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }
}

