/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ConfiguredArchiveGenerator;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.rest.api.SearchHit;
import de.lwsystems.mailarchive.rest.api.StatsHit;
import de.lwsystems.mailarchive.search.IFullSearchHit;
import de.lwsystems.mailarchive.search.ISearchHit;
import de.lwsystems.mailarchive.search.IStatsHit;
import java.io.IOException;
import java.security.Principal;
import java.util.Date;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;

public class ServletTools {
    private static final Logger LOGGER = Logger.getLogger(ServletTools.class);

    static String getRequestDetails(HttpServletRequest request, boolean html) {
        StringBuilder sRet = new StringBuilder(html ? "<p>" : "");
        String nl = html ? "</p><p>" : "\n";
        sRet.append("session=" + request.getSession(true).getId()).append(nl);
        sRet.append("Authtype=" + request.getAuthType()).append(nl);
        sRet.append("Contenttype=" + request.getContentType()).append(nl);
        sRet.append("ContextPath=" + request.getContextPath()).append(nl);
        sRet.append("Method=" + request.getMethod()).append(nl);
        sRet.append("PathInfo=" + request.getPathInfo()).append(nl);
        sRet.append("PathTranslated=" + request.getPathTranslated()).append(nl);
        sRet.append("Protokoll=" + request.getProtocol()).append(nl);
        sRet.append("RemoteAddr=" + request.getRemoteAddr()).append(nl);
        sRet.append("RemoteUser=" + request.getRemoteUser()).append(nl);
        sRet.append("RemoteHost=" + request.getRemoteHost()).append(nl);
        sRet.append("ServletPath=" + request.getServletPath()).append(nl);
        sRet.append("RequestURL=" + request.getRequestURL().toString()).append(nl);
        sRet.append("CharacterEncoding=" + request.getCharacterEncoding()).append(nl);
        sRet.append("LocalAddr=" + request.getLocalAddr()).append(nl);
        sRet.append("LocalName=" + request.getLocalName()).append(nl);
        sRet.append("PathInfo=" + request.getPathInfo()).append(nl);
        sRet.append("QueryString=" + request.getQueryString()).append(nl);
        sRet.append("RequestURI=" + request.getRequestURI().toString()).append(nl);
        sRet.append("RequestedSessionId=" + request.getRequestedSessionId()).append(nl);
        sRet.append("Scheme=" + request.getScheme()).append(nl);
        sRet.append("ServerName=" + request.getServerName()).append(nl);
        if (request.getCookies() != null) {
            sRet.append("Cookies:").append(nl);
            for (Cookie cookie : request.getCookies()) {
                sRet.append("Name=" + cookie.getName()).append(nl);
                sRet.append("Domain=" + cookie.getDomain()).append(nl);
                sRet.append("Path=" + cookie.getPath()).append(nl);
                sRet.append("Value=" + cookie.getValue()).append(nl);
                sRet.append("Comment=" + cookie.getComment()).append(nl);
                sRet.append("MaxAge=" + Integer.toString(cookie.getMaxAge())).append(nl);
                sRet.append("Version=" + Integer.toString(cookie.getVersion())).append(nl);
                sRet.append("Secure=" + Boolean.toString(cookie.getSecure())).append(nl).append(nl);
            }
            Principal principal = request.getUserPrincipal();
            if (principal != null) {
                sRet.append("Principal:").append(nl);
                sRet.append("Name=" + principal.getName()).append(nl);
                sRet.append("toString=" + principal.toString()).append(nl);
                sRet.append("Class=" + principal.getClass().toString()).append(nl);
            }
        }
        sRet.append(html ? "</p>" : "");
        return sRet.toString();
    }

    public static SearchHit createSearchHit(ISearchHit hitDoc) throws JSONException, IOException {
        SearchHit temp = new SearchHit();
        Date date = hitDoc.getDate();
        if (date != null) {
            temp.setDate(date);
        } else {
            temp.setDate(date);
        }
        temp.setSubject(hitDoc.getSubject());
        temp.setFrom(hitDoc.getFrom());
        temp.setId(hitDoc.getId());
        temp.setTo(hitDoc.getTo());
        temp.setCc(hitDoc.getCc());
        temp.setBcc(hitDoc.getBcc());
        temp.setHasAttachment(hitDoc.hasAttachment());
        return temp;
    }

    public static StatsHit createStatsHit(IStatsHit hitDoc) throws JSONException, IOException {
        StatsHit temp = new StatsHit();
        temp.setAddress(hitDoc.getFrom());
        temp.setSize(hitDoc.getSize());
        temp.setMailCount(0);
        temp.setMailAccounts(0);
        return temp;
    }

    private static JSONArray toJSONArray(String[] strings) {
        JSONArray result = new JSONArray();
        for (String string : strings) {
            result.put((Object)string);
        }
        return result;
    }

    public static IContainer getContainer(String searchContainer, Benno benno) throws ContainerNotFoundException {
        BennoConfig config = benno.getConfig();
        IContainer myContainer = null;
        for (IArchive aktArchive : new ConfiguredArchiveGenerator(benno, config.getArchiveGenerator(), true).getArchives()) {
            IContainerGenerator containerGen = aktArchive.getContainerGenerator();
            try {
                myContainer = containerGen.getContainer(searchContainer);
                break;
            }
            catch (Exception searchEx) {
            }
        }
        if (myContainer == null) {
            throw new ContainerNotFoundException(searchContainer);
        }
        return myContainer;
    }

    public static SearchHit createSearchHit(IFullSearchHit hitDoc) throws JSONException, IOException {
        return ServletTools.createSearchHit((ISearchHit)hitDoc);
    }
}

