/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.rest.api.MailResult;
import de.lwsystems.mailarchive.rest.api.MultipartItem;
import de.lwsystems.mailarchive.rest.utils.MimeUtils;
import de.proite.mailarchive.rest.tools.DecodeHeader;
import de.proite.mailarchive.rest.tools.MailAttachment;
import de.proite.mailarchive.rest.tools.MimePartResolver;
import de.proite.mailarchive.rest.tools.RecipientResolver;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MailDateFormat;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;
import org.json.JSONException;

public class JsonBuilder {
    private static final Logger LOGGER = Logger.getLogger(JsonBuilder.class);

    public static MailResult createFullJsonDocument(MailDocument myDoc) throws JSONException, IOException, MessagingException {
        ArrayList<MultipartItem> attachments = new ArrayList<MultipartItem>();
        ArrayList<MultipartItem> bodies = new ArrayList<MultipartItem>();
        HashMap<String, Object> temp = new HashMap<String, Object>();
        MailResult result = new MailResult();
        JsonBuilder.addCommonHeaderData(myDoc, temp);
        result.setHeader(temp);
        MimeMultipart multipart = null;
        String textPart = null;
        ArrayList<MultipartItem> attachmentList = new ArrayList<MultipartItem>();
        List<MultipartItem> bodyList = new ArrayList<MultipartItem>();
        if (!MimeUtils.getMimeMesage(myDoc).getContent().getClass().equals(String.class)) {
            multipart = JsonBuilder.buildMimeMultipart(myDoc, multipart, attachmentList);
        } else {
            textPart = (String)MimeUtils.getMimeMesage(myDoc).getContent();
        }
        if (multipart != null) {
            MimePartResolver.resolveMimeParts(multipart, attachmentList, bodyList, 0);
            bodyList = MimePartResolver.convertInlineImageToBase64(multipart, bodyList);
        } else {
            MultipartItem tmpFile = new MultipartItem();
            tmpFile.setContentType(MimeUtils.getMimeMesage(myDoc).getContentType());
            if (MimeUtils.getMimeMesage(myDoc).getDisposition() != null) {
                tmpFile.setContentDisposition(MimeUtils.getMimeMesage(myDoc).getDisposition());
            }
            tmpFile.setData(textPart);
            bodyList.add(tmpFile);
        }
        attachments.addAll(attachmentList);
        result.setAttachments(attachments);
        bodies.addAll(bodyList);
        result.setBody(bodies);
        return result;
    }

    public static MimeMultipart buildMimeMultipart(MailDocument myDoc, MimeMultipart multipart, List<MultipartItem> attachmentList) throws MessagingException, IOException {
        if (!MimeUtils.getMimeMesage(myDoc).getContentType().toLowerCase().contains("multipart/") && !MimeUtils.getMimeMesage(myDoc).getContentType().toLowerCase().contains("text/")) {
            attachmentList.add(JsonBuilder.setAttachmentToMultipart(myDoc));
        } else {
            try {
                multipart = (MimeMultipart)MimeUtils.getMimeMesage(myDoc).getContent();
            }
            catch (ClassCastException ex) {
                MultipartItem mmp = JsonBuilder.setAttachmentToMultipart(myDoc);
                mmp.setAttachmentId(0);
                attachmentList.add(mmp);
            }
        }
        return multipart;
    }

    private static MultipartItem setAttachmentToMultipart(MailDocument myDoc) throws MessagingException {
        MultipartItem tmpAttach = new MultipartItem();
        MailAttachment tmpAttachment = new MailAttachment(MimeUtils.getMimeMesage(myDoc).getContentType(), MimeUtils.getMimeMesage(myDoc).getSize(), MimeUtils.getMimeMesage(myDoc).getDisposition());
        tmpAttach.setName(tmpAttachment.getFilename());
        tmpAttach.setContentType(tmpAttachment.getContentType());
        if (tmpAttachment.getContentDisposition() != null) {
            tmpAttach.setContentDisposition(tmpAttachment.getContentDisposition());
        }
        tmpAttach.setAttachmentId(0);
        tmpAttach.setSize(tmpAttachment.getSize());
        return tmpAttach;
    }

    public static Map<String, Object> createHeadersOnlyJsonDocument(MailDocument myDoc) throws JSONException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        JsonBuilder.addCommonHeaderData(myDoc, result);
        return result;
    }

    private static void addCommonHeaderData(MailDocument myDoc, Map<String, Object> result) throws JSONException {
        String[] recipients;
        String ccList = "";
        String toList = "";
        ArrayList<String> bccList = new ArrayList<String>();
        block13: for (Header header : myDoc.getMetaData().getHeaders()) {
            switch (header.getName()) {
                case "Cc": {
                    if (!ccList.isEmpty()) continue block13;
                    ccList = header.getBody();
                    continue block13;
                }
                case "To": {
                    if (!toList.isEmpty()) continue block13;
                    toList = header.getBody();
                    continue block13;
                }
                case "Date": {
                    try {
                        Date MailDate = new MailDateFormat().parse(header.getBody());
                        long dateTS = MailDate.getTime() / 1000L;
                        result.put("X-Benno-DateTS", dateTS);
                        result.put(header.getName(), header.getBody());
                    }
                    catch (ParseException ex) {
                        LOGGER.info((Object)"Cannot add X-Benno-DateTS header: ", (Throwable)ex);
                    }
                    catch (NullPointerException ex) {
                        result.put("X-Benno-DateTS", "0");
                        result.put(header.getName(), header.getBody());
                    }
                    continue block13;
                }
                default: {
                    if (result.get(header.getName()) != null) continue block13;
                    result.put(header.getName(), DecodeHeader.decode(header.getBody()));
                }
            }
        }
        for (String aktRecipient : recipients = myDoc.getMetaData().getRecipients()) {
            if (toList.contains(aktRecipient) || ccList.contains(aktRecipient)) continue;
            bccList.add(aktRecipient);
        }
        result.put("Bcc", bccList);
        result.put("Cc", RecipientResolver.getJSONArrayFromString(ccList));
        result.put("To", RecipientResolver.getJSONArrayFromString(toList));
        result.put("Size", myDoc.getMetaData().getSize());
        result.put("X-Benno-HashCheckPassed", myDoc.getMetaData().hashesMatch());
    }
}

