/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.parser.BennoMailfileParser;
import de.lwsystems.mailarchive.parser.ParserException;
import de.lwsystems.mailarchive.rest.utils.MimeUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import javax.mail.MessagingException;
import org.apache.commons.codec.binary.Base64;

public class SmimeResponse {
    public static MailDocument createDecodedSmimeMailDocument(MailDocument mailDocument) throws ParserException, MessagingException, IOException {
        String decode = SmimeResponse.getDecodedBase64String(mailDocument);
        String smimeDecodedResponse = SmimeResponse.createSmimeMailBodyResponse(decode, mailDocument);
        mailDocument = SmimeResponse.createNewSmimeMailResponseDocument(smimeDecodedResponse, mailDocument);
        return mailDocument;
    }

    private static String getDecodedBase64String(MailDocument mailDocument) throws MessagingException, IOException {
        byte[] mailByteArray = new byte[MimeUtils.getMimeMesage(mailDocument).getRawInputStream().available()];
        MimeUtils.getMimeMesage(mailDocument).getRawInputStream().read(mailByteArray);
        String encodedBase64String = new String(mailByteArray, StandardCharsets.UTF_8);
        byte[] decodedBase64String = Base64.decodeBase64((String)encodedBase64String);
        return new String(decodedBase64String, StandardCharsets.UTF_8);
    }

    private static String createSmimeMailBodyResponse(String decodedBase64String, MailDocument mailDocument) {
        return "===== Hash: " + mailDocument.getMetaData().getBennoHashHex() + "\r\n" + decodedBase64String.substring(decodedBase64String.indexOf("Content-Type:"), decodedBase64String.length());
    }

    private static MailDocument createNewSmimeMailResponseDocument(String smimeDecodedResponse, MailDocument mailDocument) throws ParserException, IOException, MessagingException {
        ByteArrayInputStream smimeInputStream = new ByteArrayInputStream(smimeDecodedResponse.getBytes(StandardCharsets.UTF_8));
        MailDocument smimeMailDocument = new BennoMailfileParser().parseStream((InputStream)smimeInputStream);
        byte[] smimeMailByteArray = new byte[smimeMailDocument.getMailStream().available()];
        smimeMailDocument.getMailStream().read(smimeMailByteArray);
        return new MailDocument(smimeMailByteArray, mailDocument.getMetaData());
    }
}

