/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ConfiguredArchiveGenerator;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.rest.api.BennoStatsApi;
import de.lwsystems.mailarchive.rest.api.ContainerHit;
import de.lwsystems.mailarchive.rest.api.SearchError;
import de.lwsystems.mailarchive.rest.api.StatsAnswer;
import de.lwsystems.mailarchive.rest.api.StatsHit;
import de.lwsystems.mailarchive.rest.servlets.BennoSearchServlet;
import de.lwsystems.mailarchive.rest.servlets.ServletTools;
import de.lwsystems.mailarchive.rest.utils.JsonUtils;
import de.lwsystems.mailarchive.rest.utils.ScidUtils;
import de.lwsystems.mailarchive.search.BadRequestException;
import de.lwsystems.mailarchive.search.IEmailIndex;
import de.lwsystems.mailarchive.search.IStatsHit;
import de.lwsystems.mailarchive.search.IStatsResult;
import de.lwsystems.mailarchive.search.NoSuchObjectException;
import de.lwsystems.mailarchive.search.lucene.LuceneEmailIndex;
import de.lwsystems.mailarchive.utils.Clock;
import de.proite.mailarchive.rest.tools.BennoLicense;
import de.proite.mailarchive.rest.tools.BennoSearcherManager;
import de.proite.mailarchive.rest.tools.IBennoLicense;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.lucene.queryParser.ParseException;
import org.json.JSONException;

public class BennoStatsServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(BennoStatsServlet.class);
    boolean debugEnabled = LOGGER.isDebugEnabled();
    private final BennoRest bennoRest;
    private final Benno benno;
    private final IBennoLicense bennoLicense;
    private final int numOfOutputDomains = 5;

    public BennoStatsServlet(BennoRest bennoRest, Benno benno, IBennoLicense bennoLicense) {
        this.bennoRest = bennoRest;
        this.benno = benno;
        this.bennoLicense = bennoLicense;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doProccess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doProccess(request, response);
    }

    private void doProccess(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        String sessionId = session.getId();
        response.setContentType("application/json; charset=UTF-8");
        response.setStatus(200);
        try {
            BennoConfig config = this.bennoRest.getBennoConfig();
            String queryString = request.getParameter("query");
            try {
                if (queryString.contains("Date:[")) {
                    queryString = queryString.replaceAll("Date:\\[", "SortableDate:[");
                }
            }
            catch (NullPointerException npe) {
                LOGGER.warn((Object)(session.getId() + "Parameter \"query\" empty or not set."));
                queryString = "*";
            }
            String searchSCID = "";
            if (request.getParameter("scid") != null) {
                searchSCID = request.getParameter("scid");
            }
            String filterQuery = request.getParameter("filterQuery");
            try {
                if (filterQuery.contains("Date:[")) {
                    filterQuery = filterQuery.replaceAll("Date:\\[", "SortableDate:[");
                }
            }
            catch (NullPointerException npe) {
                filterQuery = "SortableDate:[197001010000 TO 197001010000]";
                LOGGER.warn((Object)"No filter given. Set to \"SortableDate:[197001010000 TO 197001010000]\"");
            }
            StatsAnswer answer = new BennoStatsApiImpl(response, session, config).search(this.getContainerParameter(request, sessionId), queryString, filterQuery, this.getLimitRequestParameter(request, sessionId), this.getSortFieldFromRequest(request, "SortableDate"), this.getSortDirectionFromRequest(request, false), this.getStartRequestParameter(request, session.getId()), this.getOutputFieldParameter(request, "all"), this.getUncompressedData(request, false), this.getDecodeData(request, false), this.getContainerListOnly(request, false), this.getContainerSizeListOnly(request, false), searchSCID);
            response.resetBuffer();
            JsonUtils.write(answer, response.getWriter());
        }
        catch (ContainerNotFoundException cnfe) {
            LOGGER.warn((Object)cnfe.getMessage());
            response.resetBuffer();
            response.setStatus(404);
            try {
                SearchError errResult = new SearchError();
                errResult.setError("container not found");
                JsonUtils.write(errResult, response.getWriter());
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
            }
        }
        catch (ParseException pex) {
            try {
                response.setStatus(400);
                SearchError errResult = new SearchError();
                errResult.setError("Invalid query");
                JsonUtils.write(errResult, response.getWriter());
                LOGGER.warn((Object)(session.getId() + " Invalid query string: " + request.getParameter("query")));
            }
            catch (Exception ex) {
                LOGGER.warn((Object)"Uncaught Exception", (Throwable)ex);
            }
        }
        catch (Exception e) {
            response.setStatus(503);
            LOGGER.fatal((Object)"Uncaught Exception", (Throwable)e);
        }
    }

    private IEmailIndex getIndex(IContainer myContainer, String searchArchive) {
        return new LuceneEmailIndex(myContainer, searchArchive);
    }

    private boolean isResultCachedInSession(HttpSession session, String queryString, String sortField, boolean sortAsc, String filterQuery) {
        return session.getAttribute("lastQuery") != null && session.getAttribute("lastQuery").equals(queryString) && session.getAttribute("lastSortField") != null && session.getAttribute("lastSortField").equals(sortField) && session.getAttribute("lastSortAsc") != null && session.getAttribute("lastSortAsc").equals(sortAsc) && session.getAttribute("lastFilterQuery").equals(filterQuery) && session.getAttribute("lastFirst") != null;
    }

    public boolean getSortDirectionFromRequest(HttpServletRequest request, boolean sortAsc) {
        if (request.getParameter("sortAsc") != null && request.getParameter("sortAsc").equals("false")) {
            sortAsc = true;
        }
        return sortAsc;
    }

    private String getSortFieldFromRequest(HttpServletRequest request, String sortField) {
        if (request.getParameter("sort") != null && ((sortField = request.getParameter("sort")).equals("Date") || sortField.equals("Subject"))) {
            sortField = "Sortable" + sortField;
        }
        return sortField;
    }

    private int getStartRequestParameter(HttpServletRequest request, String sessionId) {
        int start;
        if (request.getParameter("start") != null) {
            try {
                start = Integer.parseInt(request.getParameter("start"));
                if (start < 1) {
                    start = 1;
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)(sessionId + " Error reading parameter \"start\": " + ex));
                start = 1;
            }
        } else {
            start = 1;
        }
        return start;
    }

    private String getOutputFieldParameter(HttpServletRequest request, String outputField) {
        if (request.getParameter("outputfield") != null) {
            outputField = request.getParameter("outputfield");
        }
        return outputField;
    }

    private boolean getUncompressedData(HttpServletRequest request, boolean uncompressedData) {
        if (request.getParameter("showall") != null && request.getParameter("showall").equals("true")) {
            uncompressedData = true;
        }
        return true;
    }

    private boolean getDecodeData(HttpServletRequest request, boolean decodeData) {
        if (request.getParameter("decode") != null && request.getParameter("decode").equals("true")) {
            decodeData = true;
        }
        return decodeData;
    }

    private boolean getContainerListOnly(HttpServletRequest request, boolean containerListOnly) {
        if (request.getParameter("containerlist") != null && request.getParameter("containerlist").equals("true")) {
            containerListOnly = true;
        }
        return containerListOnly;
    }

    private boolean getContainerSizeListOnly(HttpServletRequest request, boolean containerSizeList) {
        if (request.getParameter("containersizelist") != null && request.getParameter("containersizelist").equals("true")) {
            containerSizeList = true;
        }
        return containerSizeList;
    }

    private String getContainerParameter(HttpServletRequest request, String sessionId) {
        String container = request.getParameter("archive") != null ? request.getParameter("archive") : "";
        return container;
    }

    private int getLimitRequestParameter(HttpServletRequest request, String sessionId) {
        int limit;
        if (request.getParameter("limit") != null) {
            try {
                limit = Integer.parseInt(request.getParameter("limit"));
                if (limit < 0) {
                    limit = 0;
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)(sessionId + " Error reading parameter \"limit\": " + ex));
                limit = 100000;
            }
        } else {
            limit = 100000;
        }
        return limit;
    }

    private void logDebug(String msg) {
        Logger LOGGER = Logger.getLogger(BennoSearchServlet.class);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)msg);
        }
    }

    private IStatsResult getResultFromSession(HttpSession session) {
        return (IStatsResult)session.getAttribute("lastResult");
    }

    private Map<String, ContainerHit> getContainerList(BennoRest bennoRest, String selContainer) {
        HashMap<String, ContainerHit> containerList = new HashMap<String, ContainerHit>();
        BennoConfig config = bennoRest.getBennoConfig();
        for (IArchive aktArchive : new ConfiguredArchiveGenerator(this.benno, config.getArchiveGenerator(), true).getArchives()) {
            IContainerGenerator containerGen = aktArchive.getContainerGenerator();
            try {
                if (selContainer.isEmpty()) {
                    for (IContainer container : containerGen.getContainers()) {
                        if (container.getIdentifier().equals("SYSDATA")) continue;
                        containerList.put(container.getIdentifier(), this.setContainerHit(container, config));
                    }
                    continue;
                }
                containerList.put(selContainer, this.setContainerHit(containerGen.getContainer(selContainer), config));
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Unexcpeted excpetion:  " + ex));
            }
        }
        return containerList;
    }

    private ContainerHit setContainerHit(IContainer container, BennoConfig config) {
        ContainerHit containerHit = new ContainerHit();
        containerHit.setContainerName(container.getIdentifier());
        containerHit.setRepoPath(container.getBoxGenerator().getBoxGeneratorConfig().getDirectory());
        containerHit.setIndexPath(container.getIndexPathString());
        containerHit.setMailCount(BennoSearcherManager.getInstance(config.getBennoRestConfig().getIndexCacheTTL()).getSearcher(container).getIndexReader().numDocs());
        return containerHit;
    }

    private class BennoStatsApiImpl
    implements BennoStatsApi {
        private final HttpSession session;
        private final BennoConfig config;
        private final HttpServletResponse response;
        private Map<String, Integer> encodeIndexAddressNumber = new HashMap<String, Integer>();
        private Map<String, Integer> encodeIndexDomainNumber = new HashMap<String, Integer>();
        private Integer indexMailAddress = 0;
        private Integer indexMailDomain = 0;
        private boolean newAddress = true;
        Integer sumMailWarnings = 0;
        boolean mailWarning = false;

        BennoStatsApiImpl(HttpServletResponse response, HttpSession session, BennoConfig config) {
            this.response = response;
            this.session = session;
            this.config = config;
        }

        @Override
        public StatsAnswer search(String searchArchive, String queryString, String filterQuery, int limit, String sortField, boolean sortAsc, int startValue, String outputField, boolean uncompressedData, boolean decodeData, boolean containerListOnly, boolean containerSizeListOnly, String searchSCID) throws IOException, BadRequestException, ParseException, ContainerNotFoundException {
            StatsAnswer answer = new StatsAnswer();
            HashMap<String, ContainerHit> containers = new HashMap();
            String sessionId = this.session.getId();
            Integer mailErrors = 0;
            long maxMailSize = 0L;
            int mailCount = 0;
            Integer startPoint = startValue;
            int start = 0;
            boolean existsNextResult = false;
            Map containerList = searchArchive.isEmpty() ? BennoStatsServlet.this.getContainerList(BennoStatsServlet.this.bennoRest, "") : BennoStatsServlet.this.getContainerList(BennoStatsServlet.this.bennoRest, searchArchive);
            if (!containerListOnly || containerSizeListOnly) {
                for (Map.Entry configContainerHit : containerList.entrySet()) {
                    ContainerHit containerHit = (ContainerHit)configContainerHit.getValue();
                    searchArchive = containerHit.getContainerName();
                    this.newAddress = true;
                    do {
                        try {
                            IStatsResult result;
                            IContainer myContainer;
                            start = startPoint;
                            int hitIndex = start - 1;
                            this.session.setAttribute("lastFirst", (Object)start);
                            long cacheTTL = this.config.getBennoRestConfig().getIndexCacheTTL();
                            if (this.session.getAttribute("myContainer") == null || this.session.getAttribute("myArchive") == null || this.session.getAttribute("myContainer") != searchArchive) {
                                myContainer = ServletTools.getContainer(searchArchive, BennoStatsServlet.this.benno);
                                this.session.setAttribute("myContainer", (Object)myContainer);
                                this.session.setAttribute("lastQuery", null);
                                cacheTTL = 0L;
                            } else {
                                myContainer = (IContainer)this.session.getAttribute("myContainer");
                            }
                            IEmailIndex index = BennoStatsServlet.this.getIndex(myContainer, searchArchive);
                            String licenseStatus = BennoStatsServlet.this.bennoLicense.getLicenseStatus();
                            if (licenseStatus.equals("INVALID")) {
                                filterQuery = "*";
                            }
                            if (myContainer.isScidActive()) {
                                if (!ScidUtils.isScidQueryValid(searchSCID) || searchSCID.equals("")) {
                                    LOGGER.error((Object)(sessionId + " SCID is active and the parameter is not set in your query."));
                                    BennoLicense.badRequest(this.response, "SCID is missing", "Please add the SCID parameter to your query", 400);
                                    return null;
                                }
                                filterQuery = filterQuery + " AND (scid:" + searchSCID.replace(" ", "") + ")";
                            } else {
                                queryString = queryString + " AND NOT scid:* ";
                            }
                            answer.setLicenseValid(licenseStatus);
                            LOGGER.debug((Object)("Stats search Query: " + queryString));
                            LOGGER.debug((Object)("Stats search FilterQuery: " + filterQuery));
                            if (BennoStatsServlet.this.isResultCachedInSession(this.session, queryString, sortField, sortAsc, filterQuery) && Clock.getProvider().newDate().getTime() - (Long)this.session.getAttribute("lastTime") <= 120000L) {
                                result = BennoStatsServlet.this.getResultFromSession(this.session);
                                BennoStatsServlet.this.logDebug(sessionId + " Using cached result - Result from: " + this.session.getAttribute("lastTime"));
                                BennoStatsServlet.this.logDebug(sessionId + " Time-Diff: " + (Clock.getProvider().newDate().getTime() - (Long)this.session.getAttribute("lastTime")));
                            } else {
                                result = index.statsSearch(sessionId, queryString, filterQuery, cacheTTL, sortAsc);
                                this.session.setAttribute("lastTime", (Object)Clock.getProvider().newDate().getTime());
                                this.session.setAttribute("lastQuery", (Object)queryString);
                                this.session.setAttribute("lastResult", (Object)result);
                                this.session.setAttribute("lastSortField", (Object)sortField);
                                this.session.setAttribute("lastFilterQuery", (Object)filterQuery);
                                this.session.setAttribute("lastSortAsc", (Object)sortAsc);
                            }
                            Iterable<IStatsHit> hits = result.getStatsHits(hitIndex, limit);
                            LOGGER.debug((Object)("Stats search found mails: " + result.getHitCount()));
                            LOGGER.debug((Object)("Stats search overall mails: " + result.getOverallHitCount()));
                            for (IStatsHit hit : hits) {
                                Object object;
                                try {
                                    Object toCcElement;
                                    String[] mailAddress;
                                    ContainerHit containerTempHit;
                                    String container;
                                    if (myContainer.isScidActive()) {
                                        container = hit.getScid();
                                        if (!containers.containsKey(container)) {
                                            containerTempHit = new ContainerHit();
                                            containerTempHit.setScid(true);
                                            containerTempHit.setContainerName(container);
                                            containerTempHit.setRepoPath(containerHit.getRepoPath() + "/" + container + "/repo");
                                            containerTempHit.setIndexPath(containerHit.getIndexPath());
                                            if (!containers.containsKey(myContainer.getIdentifier())) {
                                                ((ContainerHit)containerList.get(myContainer.getIdentifier())).setScid(true);
                                                ((ContainerHit)containerList.get(myContainer.getIdentifier())).setAddresses(null);
                                                ((ContainerHit)containerList.get(myContainer.getIdentifier())).setDomains(null);
                                                containers.put(myContainer.getIdentifier(), (ContainerHit)containerList.get(myContainer.getIdentifier()));
                                            }
                                        } else {
                                            containerTempHit = ((ContainerHit)containers.get(myContainer.getIdentifier())).getScidcontainer().get(container);
                                        }
                                    } else {
                                        container = myContainer.getIdentifier();
                                        if (!containers.containsKey(container)) {
                                            containerTempHit = new ContainerHit();
                                            containerTempHit.setScid(false);
                                            containerTempHit.setContainerName(container);
                                            containerTempHit.setScidcontainer(null);
                                            containerTempHit.setRepoPath(containerHit.getRepoPath());
                                            containerTempHit.setIndexPath(containerHit.getIndexPath());
                                        } else {
                                            containerTempHit = (ContainerHit)containers.get(myContainer.getIdentifier());
                                        }
                                    }
                                    try {
                                        mailAddress = this.splitAddress(hit.getFrom().toLowerCase(), decodeData);
                                    }
                                    catch (NullPointerException npe) {
                                        mailAddress = this.splitAddress(hit.getSender().toLowerCase(), decodeData);
                                    }
                                    containerTempHit.setSender(this.setAddressOrDomainPart(hit, mailAddress[0], false, containerTempHit.getSender()));
                                    containerTempHit.setSenderDomain(this.setAddressOrDomainPart(hit, mailAddress[1], true, containerTempHit.getSenderDomain()));
                                    ArrayList<String[]> toCcList = new ArrayList<String[]>();
                                    toCcList.add(hit.getTo());
                                    toCcList.add(hit.getCc());
                                    if (containerTempHit.getLastIndexDate().equals("") && myContainer.isScidActive()) {
                                        containerTempHit.setLastIndexDate(index.getLastIndexDate(container));
                                        if (((ContainerHit)containers.get(myContainer.getIdentifier())).getLastIndexDate().equals("")) {
                                            ((ContainerHit)containers.get(myContainer.getIdentifier())).setLastIndexDate(index.getLastIndexDate(""));
                                        }
                                    } else if (containerTempHit.getLastIndexDate().equals("") && !myContainer.isScidActive()) {
                                        containerTempHit.setLastIndexDate(index.getLastIndexDate(""));
                                    }
                                    object = toCcList.iterator();
                                    while (object.hasNext()) {
                                        for (String toCcItem : toCcElement = (String[])object.next()) {
                                            mailAddress = this.splitAddress(toCcItem.toLowerCase(), decodeData);
                                            containerTempHit.setRecipient(this.setAddressOrDomainPart(hit, mailAddress[0], false, containerTempHit.getRecipient()));
                                            containerTempHit.setRecipientDomain(this.setAddressOrDomainPart(hit, mailAddress[1], true, containerTempHit.getRecipientDomain()));
                                        }
                                    }
                                    Long mailSize = hit.getSize();
                                    if (mailSize > 0L) {
                                        maxMailSize += mailSize.longValue();
                                        containerTempHit.setContainerSize(containerTempHit.getContainerSize() + mailSize);
                                        if (myContainer.isScidActive()) {
                                            ((ContainerHit)containers.get(myContainer.getIdentifier())).setContainerSize(((ContainerHit)containers.get(myContainer.getIdentifier())).getContainerSize() + mailSize);
                                        }
                                    }
                                    containerTempHit.setMailCount(containerTempHit.getMailCount() + 1);
                                    ++mailCount;
                                    if (this.mailWarning) {
                                        toCcElement = this.sumMailWarnings;
                                        Integer n = this.sumMailWarnings = Integer.valueOf(this.sumMailWarnings + 1);
                                        this.mailWarning = false;
                                    }
                                    if (myContainer.isScidActive()) {
                                        HashMap<String, ContainerHit> scidContainer = new HashMap<String, ContainerHit>();
                                        if (!((ContainerHit)containers.get(myContainer.getIdentifier())).getScidcontainer().isEmpty()) {
                                            scidContainer = ((ContainerHit)containers.get(myContainer.getIdentifier())).getScidcontainer();
                                        }
                                        scidContainer.put(container, containerTempHit);
                                        ((ContainerHit)containers.get(myContainer.getIdentifier())).setScidcontainer(scidContainer);
                                        continue;
                                    }
                                    containers.put(myContainer.getIdentifier(), containerTempHit);
                                }
                                catch (Exception ex) {
                                    LOGGER.error((Object)"Mail cannot be set to stats JSON response.", (Throwable)ex);
                                    Integer n = mailErrors;
                                    mailErrors = mailErrors + 1;
                                    object = mailErrors;
                                }
                            }
                            existsNextResult = result.getStatsHits(start += limit, limit).iterator().hasNext();
                            LOGGER.debug((Object)("Determine other mail objects start: " + start + " limit: " + limit));
                            LOGGER.debug((Object)("Found new mails : " + existsNextResult));
                        }
                        catch (NoSuchObjectException nsoe) {
                            try {
                                answer.setMaxMailSize(-1L);
                            }
                            catch (JSONException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    } while (existsNextResult);
                    if (!containerSizeListOnly) {
                        for (Map.Entry containerTemp : containers.entrySet()) {
                            if (((ContainerHit)containerTemp.getValue()).isScid()) {
                                for (Map.Entry<String, ContainerHit> scidContainer : ((ContainerHit)containerTemp.getValue()).getScidcontainer().entrySet()) {
                                    this.sortAndCompressAddress(scidContainer.getValue(), ((ContainerHit)containerTemp.getValue()).getScidcontainer(), sortField, sortAsc, uncompressedData);
                                }
                                continue;
                            }
                            this.sortAndCompressAddress((ContainerHit)containerTemp.getValue(), containers, sortField, sortAsc, uncompressedData);
                        }
                    }
                    this.indexMailAddress = 0;
                    this.indexMailDomain = 0;
                }
                if (!containerSizeListOnly) {
                    answer.setCollectCount(mailCount);
                    answer.setMaxMailSize(maxMailSize);
                    answer.setCollectWarnings(this.sumMailWarnings);
                    answer.setCollectErrors(mailErrors);
                }
            } else {
                containers = containerList;
            }
            answer.setHostInfo(BennoStatsServlet.this.bennoRest.getHostInfo());
            answer.setInstanceId(BennoStatsServlet.this.bennoRest.getMyInstanceId());
            answer.setQuery(queryString);
            answer.setFilter(filterQuery);
            answer.setContainers(containers);
            return answer;
        }

        private String[] encryptAddress(String[] mailAddress, boolean decodeData) {
            String[] encryptData = new String[2];
            String fullAddress = mailAddress[0] + "@" + mailAddress[1];
            if (!decodeData) {
                try {
                    Integer n;
                    Integer n2;
                    if (this.encodeIndexAddressNumber.get(fullAddress) == null) {
                        this.encodeIndexAddressNumber.put(fullAddress, this.indexMailAddress);
                        n2 = this.indexMailAddress;
                        n = this.indexMailAddress = Integer.valueOf(this.indexMailAddress + 1);
                    }
                    encryptData[0] = "address_" + this.encodeIndexAddressNumber.get(fullAddress);
                    if (this.encodeIndexDomainNumber.get(mailAddress[1]) == null) {
                        this.encodeIndexDomainNumber.put(mailAddress[1], this.indexMailDomain);
                        n2 = this.indexMailDomain;
                        n = this.indexMailDomain = Integer.valueOf(this.indexMailDomain + 1);
                    }
                    encryptData[1] = "domain_" + this.encodeIndexDomainNumber.get(mailAddress[1]);
                    encryptData[0] = encryptData[0] + "@" + encryptData[1];
                }
                catch (Exception exception) {}
            } else {
                encryptData[0] = mailAddress[0] + "@" + mailAddress[1];
                encryptData[1] = mailAddress[1];
            }
            return encryptData;
        }

        private void sortAndCompressAddress(ContainerHit fullContainer, Map<String, ContainerHit> fullContainerMap, String sortField, boolean sortAsc, boolean uncompressedData) {
            ArrayList<StatsHit> senderSort = new ArrayList<StatsHit>(fullContainer.getSender().values());
            ArrayList<StatsHit> senderDomainSort = new ArrayList<StatsHit>(fullContainer.getSenderDomain().values());
            ArrayList<StatsHit> recipientSort = new ArrayList<StatsHit>(fullContainer.getRecipient().values());
            ArrayList<StatsHit> recipientDomainSort = new ArrayList<StatsHit>(fullContainer.getRecipientDomain().values());
            Collections.sort(senderSort, StatsHit.getCompByField(sortField, sortAsc));
            Collections.sort(senderDomainSort, StatsHit.getCompByField(sortField, sortAsc));
            Collections.sort(recipientSort, StatsHit.getCompByField(sortField, sortAsc));
            Collections.sort(recipientDomainSort, StatsHit.getCompByField(sortField, sortAsc));
            this.compressData(uncompressedData, senderDomainSort, senderSort);
            this.compressData(uncompressedData, recipientDomainSort, recipientSort);
            HashMap<String, ArrayList<StatsHit>> senderAndRecipient = new HashMap<String, ArrayList<StatsHit>>();
            senderAndRecipient.put("sender", senderSort);
            senderAndRecipient.put("recipient", recipientSort);
            HashMap<String, ArrayList<StatsHit>> senderAndRecipientDomain = new HashMap<String, ArrayList<StatsHit>>();
            senderAndRecipientDomain.put("sender", senderDomainSort);
            senderAndRecipientDomain.put("recipient", recipientDomainSort);
            fullContainerMap.get(fullContainer.getContainerName()).setAddresses(senderAndRecipient);
            fullContainerMap.get(fullContainer.getContainerName()).setDomains(senderAndRecipientDomain);
        }

        private void compressData(boolean uncompressedData, ArrayList<StatsHit> domainList, ArrayList<StatsHit> addressList) {
            ArrayList<StatsHit> removedDomainList = new ArrayList<StatsHit>();
            if (!uncompressedData) {
                int i = 5;
                while (i <= domainList.size() - 1) {
                    removedDomainList.add(domainList.get(i));
                    domainList.remove(i);
                    i = 5;
                }
                for (int j = 0; j < addressList.size(); ++j) {
                    for (int k = 0; k < removedDomainList.size(); ++k) {
                        try {
                            if (!addressList.get(j).getAddress().contains("@" + ((StatsHit)removedDomainList.get(k)).getAddress())) continue;
                            addressList.remove(j);
                            continue;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            // empty catch block
                        }
                    }
                }
            }
        }

        private Map<String, StatsHit> setAddressOrDomainPart(IStatsHit statsHit, String addressPart, boolean isDomain, Map<String, StatsHit> addressOrDomain) {
            try {
                StatsHit tempStatsHit;
                if (addressOrDomain.get(addressPart) == null) {
                    if (!isDomain) {
                        tempStatsHit = ServletTools.createStatsHit(statsHit);
                        tempStatsHit.setAddress(addressPart);
                        tempStatsHit.setMailAccounts(1);
                        tempStatsHit.setMailCount(1);
                        tempStatsHit.setSize(tempStatsHit.getSize());
                        this.newAddress = true;
                    } else {
                        tempStatsHit = new StatsHit();
                        tempStatsHit.setMailCount(1);
                        tempStatsHit.setMailAccounts(1);
                        tempStatsHit.setAddress(addressPart);
                        tempStatsHit.setSize(statsHit.getSize());
                        this.newAddress = false;
                    }
                } else if (!isDomain) {
                    tempStatsHit = addressOrDomain.get(addressPart);
                    tempStatsHit.setMailCount(tempStatsHit.getMailCount() + 1);
                    tempStatsHit.setSize(tempStatsHit.getSize() + statsHit.getSize());
                } else {
                    tempStatsHit = addressOrDomain.get(addressPart);
                    tempStatsHit.setMailCount(tempStatsHit.getMailCount() + 1);
                    tempStatsHit.setSize(tempStatsHit.getSize() + statsHit.getSize());
                    if (this.newAddress) {
                        tempStatsHit.setMailAccounts(tempStatsHit.getMailAccounts() + 1);
                    }
                }
                addressOrDomain.put(addressPart, tempStatsHit);
                return addressOrDomain;
            }
            catch (Exception exception) {
                return addressOrDomain;
            }
        }

        private String[] splitAddress(String mailAddress, boolean decodeData) {
            String[] parts = new String[2];
            try {
                if (mailAddress.contains("@")) {
                    parts = mailAddress.split("@");
                    parts = this.encryptAddress(parts, decodeData);
                } else {
                    parts[0] = mailAddress;
                    parts[1] = "<not-set>";
                    this.mailWarning = true;
                }
            }
            catch (Exception ex) {
                LOGGER.error((Object)("Mail count error: " + mailAddress + ": " + ex));
                parts[0] = "<not-set>";
                parts[1] = "<not-set>";
            }
            return parts;
        }
    }
}

