/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.search.IEmailIndex;
import de.lwsystems.mailarchive.utils.BennoBuildTime;
import de.lwsystems.mailarchive.utils.Clock;
import de.lwsystems.mailarchive.utils.ILicense;
import de.lwsystems.mailarchive.utils.License;
import de.lwsystems.mailarchive.utils.LicenseException;
import de.proite.mailarchive.rest.tools.BennoLicenseInstance;
import de.proite.mailarchive.rest.tools.IBennoLicense;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.apache.lucene.index.CorruptIndexException;

public class BennoLicense
implements IBennoLicense {
    public static String defaultBennoLicenseFile = "/etc/benno/benno.lic";
    public static InputStream bennoMailLicense = null;
    public static Integer TESTTIME = 60;
    private static final Logger LOGGER = Logger.getLogger(BennoRest.class);
    private String licenseStatus = "LICENSE_NO_STATUS";
    private Long pluginTesttime = 0L;
    private ILicense bennoLicense;
    private Benno benno;

    public BennoLicense(String bennoLicenseFile, Benno benno) {
        defaultBennoLicenseFile = bennoLicenseFile;
        this.benno = benno;
        this.bennoLicenseCheck("notset");
    }

    public BennoLicense(InputStream is, String documentId, Benno benno) {
        bennoMailLicense = is;
        this.benno = benno;
        this.bennoLicenseCheck(documentId);
    }

    private void bennoLicenseCheck(String documentId) {
        try {
            try {
                this.bennoLicense = !documentId.equals("notset") ? new License(bennoMailLicense, documentId) : new License(BennoLicense.getBennoLicenseFile());
            }
            catch (Exception ex) {
                this.bennoLicense = new License(BennoLicense.getBennoLicenseFile());
            }
            try {
                String licenseType = this.bennoLicense.getType();
                if (licenseType.equals("LICENSE_NOT_AVAILABLE")) {
                    LOGGER.warn((Object)"License not available.");
                    this.licenseStatus = licenseType;
                } else {
                    if (this.bennoLicense.getType().equals("Evaluation")) {
                        this.bennoLicense.checkExpire();
                    } else {
                        this.bennoLicense.checkBuild();
                    }
                    String hostInfo = this.bennoLicense.getHostInfo();
                    InetAddress iaddr = InetAddress.getLocalHost();
                    String hostname = iaddr.getCanonicalHostName();
                    String address = iaddr.getHostAddress();
                    if (this.bennoLicense.getHostLicenseInfo() != null && !this.bennoLicense.getHostLicenseInfo().isEmpty()) {
                        this.bennoLicense.checkValid(hostInfo, address);
                        if (hostname.indexOf(".") == -1) {
                            new LicenseException("Hostname \"" + hostname + "\" not fully qualified");
                        }
                        if (address.startsWith("127.")) {
                            new LicenseException("Loopback address detected for hostname \"" + hostname + "\": " + address);
                        }
                    } else {
                        BennoLicenseInstance bennoLicenseInstance = new BennoLicenseInstance(this.benno);
                        String instanceId = bennoLicenseInstance.getInstanceId();
                        this.bennoLicense.checkValid(instanceId, hostname, address);
                    }
                    if (documentId.equals("notset")) {
                        LOGGER.info((Object)("License in " + BennoLicense.getBennoLicenseFile() + " is valid"));
                    } else {
                        LOGGER.info((Object)("License in mail " + documentId + " is valid"));
                    }
                    this.licenseStatus = "LICENSE_VALID";
                }
            }
            catch (UnknownHostException ex) {
                LOGGER.error((Object)"Cannot get hostname", (Throwable)ex);
                this.licenseStatus = "LICENSE_HOSTINFO_ERROR";
                throw new LicenseException("LICENSE_HOSTINFO_ERROR");
            }
            catch (LicenseException ex) {
                LOGGER.error((Object)("Benno MailArchive build " + BennoBuildTime.coreBuildTime()));
                LOGGER.error((Object)("License error: " + ex.getMessage()));
                this.licenseStatus = ex.getMessage();
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)("Cannot check license file: " + ex.getMessage()));
        }
    }

    public static String getBennoLicenseFile() {
        return defaultBennoLicenseFile;
    }

    @Override
    public void bennoTestPeriodCheck(IEmailIndex index) throws CorruptIndexException, IOException, ParseException {
        if (!this.licenseStatus.equals("LICENSE_VALID")) {
            Calendar endOfTestPeriod = this.endOfTestPeriod(index);
            if (endOfTestPeriod.after(Clock.getProvider().getCalendarInstance())) {
                String expireDate = new SimpleDateFormat("yyyy-MM-dd", Locale.ROOT).format(endOfTestPeriod.getTime());
                this.setLicenseExpires(expireDate);
                this.setLicenseStatus("LICENSE_VALID_TESTPERIOD");
            } else {
                if (endOfTestPeriod.getTime().toString().equals("Wed Mar 01 00:00:00 CET 2000")) {
                    LOGGER.warn((Object)"No index entries found. Please import some emails.");
                } else {
                    LOGGER.warn((Object)("The test period has expired at " + endOfTestPeriod.getTime().toString()));
                    LOGGER.warn((Object)"LICENSE NOT VALID");
                }
                this.setLicenseStatus("INVALID");
            }
        }
    }

    @Override
    public String bennoPluginTestPeriodCheck(IEmailIndex index, HttpServletResponse response) throws CorruptIndexException, IOException, ParseException {
        if (!this.getLicenseStatus().equals("LICENSE_VALID")) {
            if (this.getLicenseStatus().equals("LICENSE_VALID_TESTPERIOD")) {
                this.setLicenseExpires(this.getLicenseStatus());
            } else if (this.getLicenseStatus().equals("INVALID")) {
                LOGGER.warn((Object)("The test period has expired at " + this.getLicenseStatus()));
                LOGGER.warn((Object)"LICENSE NOT VALID");
                return this.getLicenseStatus();
            }
        }
        if (this.pluginTesttime != 0L) {
            return this.calcLicensePluginStatus(response);
        }
        return this.getLicenseStatus();
    }

    private String calcLicensePluginStatus(HttpServletResponse response) throws CorruptIndexException, IOException, ParseException {
        Date date = new Date(this.pluginTesttime * 1000L);
        if (this.pluginTesttime > 0L) {
            Long UnixTimeNow = System.currentTimeMillis() / 1000L;
            if (UnixTimeNow > this.pluginTesttime) {
                LOGGER.error((Object)("The test period (plugin) has expired at " + date.toString()));
                LOGGER.error((Object)"LICENSE NOT VALID");
                BennoLicense.badRequest(response, "The test period (plugin) has expired at " + date.toString(), "The test period (plugin) has expired at " + date.toString(), 405);
                return "INVALID";
            }
        } else if (this.pluginTesttime <= 0L) {
            LOGGER.error((Object)"The test period (plugin) is incorrect");
            LOGGER.error((Object)"LICENSE NOT VALID");
            BennoLicense.badRequest(response, "The test period (plugin) is incorrect!", "The test period (plugin) is incorrect", 406);
            return "INVALID";
        }
        return "LICENSE_VALID_TESTPERIOD";
    }

    private Calendar endOfTestPeriod(IEmailIndex index) throws CorruptIndexException, IOException, ParseException {
        Date indexStart = index.getFirstIndexDate();
        Calendar endOfTestTime = Calendar.getInstance();
        endOfTestTime.setTime(indexStart);
        endOfTestTime.add(5, TESTTIME);
        return endOfTestTime;
    }

    public static void badRequest(HttpServletResponse response, String title, String content, Integer errorCode) throws IOException {
        response.setStatus(errorCode.intValue());
        response.getWriter().print("<html><head>");
        response.getWriter().print("<meta http-equiv=\"Content-Type\" content=\"text/html;charset=UTF-8\"/>");
        response.getWriter().print("<title>" + title + "</title>");
        response.getWriter().print("<h2>HTTP ERROR: " + errorCode + "</h2>");
        response.getWriter().print("<p>" + content + "</p>");
        response.flushBuffer();
    }

    @Override
    public String getLicenseStatus() {
        return this.licenseStatus;
    }

    @Override
    public void setLicenseStatus(String licenseStatus) {
        this.licenseStatus = licenseStatus;
    }

    @Override
    public String getLicenseExpires() {
        return this.bennoLicense.getExpires();
    }

    @Override
    public Long getPluginLicenseExpires() {
        return this.pluginTesttime;
    }

    @Override
    public void setPluginLicenseExpires(Long pluginLicenseStatus) {
        this.pluginTesttime = pluginLicenseStatus;
    }

    public void setLicenseExpires(String expireDate) {
        if (this.bennoLicense != null) {
            this.bennoLicense.setExpires(expireDate);
        }
    }
}

