#!/bin/sh
# postinst script for benno-rest
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


case "$1" in
    configure)
    if [ ! -f /etc/benno/rest.secret ];then
        if [ -f /etc/benno-web/rest.conf ];then
            cat /etc/benno-web/rest.conf | grep ^SHARED_SECRET |perl -pe 's/^.+=\s*//' >> /etc/benno/rest.secret
        else
            dd if=/dev/urandom bs=1k count=1 status=none | tr -dc a-zA-Z0-9 | head -c 20 > /etc/benno/rest.secret
        fi
        chown benno.benno /etc/benno/rest.secret
        chmod 0640 /etc/benno/rest.secret
    fi
    ;;

    abort-upgrade|abort-remove|abort-deconfigure)
    ;;

    *)
        echo "postinst called with unknown argument \`$1'" >&2
        exit 1
    ;;
esac

chown benno.benno /var/log/benno

# Automatically added by dh_systemd_enable/13.3.4
if [ "$1" = "configure" ] || [ "$1" = "abort-upgrade" ] || [ "$1" = "abort-deconfigure" ] || [ "$1" = "abort-remove" ] ; then
	# This will only remove masks created by d-s-h on package removal.
	deb-systemd-helper unmask 'benno-rest.service' >/dev/null || true

	# was-enabled defaults to true, so new installations run enable.
	if deb-systemd-helper --quiet was-enabled 'benno-rest.service'; then
		# Enables the unit on first installation, creates new
		# symlinks on upgrades if the unit file has changed.
		deb-systemd-helper enable 'benno-rest.service' >/dev/null || true
	else
		# Update the statefile to add new symlinks (if any), which need to be
		# cleaned up on purge. Also remove old symlinks.
		deb-systemd-helper update-state 'benno-rest.service' >/dev/null || true
	fi
fi
# End automatically added section
# Automatically added by dh_systemd_start/13.3.4
if [ "$1" = "configure" ] || [ "$1" = "abort-upgrade" ] || [ "$1" = "abort-deconfigure" ] || [ "$1" = "abort-remove" ] ; then
	if [ -d /run/systemd/system ]; then
		systemctl --system daemon-reload >/dev/null || true
		if [ -n "$2" ]; then
			_dh_action=restart
		else
			_dh_action=start
		fi
		deb-systemd-invoke $_dh_action 'benno-rest.service' >/dev/null || true
	fi
fi
# End automatically added section
# Automatically added by dh_installinit/13.3.4
if [ "$1" = "configure" ] || [ "$1" = "abort-upgrade" ] || [ "$1" = "abort-deconfigure" ] || [ "$1" = "abort-remove" ] ; then
	if [ -x "/etc/init.d/benno-rest" ]; then
		update-rc.d benno-rest defaults >/dev/null
		if [ -n "$2" ]; then
			_dh_action=restart
		else
			_dh_action=start
		fi
		invoke-rc.d benno-rest $_dh_action || exit 1
	fi
fi
# End automatically added section


if [ -x "/etc/init.d/benno-rest" ]; then
    update-rc.d benno-rest defaults >/dev/null
    if [ -x "`which invoke-rc.d 2>/dev/null`" ]; then
        invoke-rc.d benno-rest start || exit $?
    else
        /etc/init.d/benno-rest start || exit $?
    fi
fi


exit 0

