/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import de.proite.mailarchive.rest.tools.ContentType;
import de.proite.mailarchive.rest.tools.MimePartResolver;
import java.io.UnsupportedEncodingException;
import javax.mail.BodyPart;
import javax.mail.internet.MimeUtility;
import org.apache.log4j.Logger;

public class MailAttachment {
    private String filename;
    private String contentType;
    private String contentDisposition;
    private int size;
    private static final Logger LOGGER = Logger.getLogger(MimePartResolver.class);

    public MailAttachment() {
        this.filename = "";
        this.contentType = "";
        this.size = 0;
    }

    public MailAttachment(BodyPart bp) {
        try {
            this.filename = bp.getFileName();
            this.contentType = ContentType.bareType(bp);
            this.size = bp.getSize();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MailAttachment(String contentType, int size) {
        this.contentType = ContentType.bareType(contentType);
        this.filename = this.identifyFilename(contentType);
        this.size = size;
    }

    public MailAttachment(String contentType, int size, String contentDisposition) {
        this.contentType = ContentType.bareType(contentType);
        this.filename = this.identifyFilename(contentType);
        this.size = size;
        this.contentDisposition = contentDisposition;
    }

    public String identifyFilename(String contentType) {
        Integer startIndex;
        Integer endIndex;
        contentType = contentType.toLowerCase();
        String name = "name=";
        String filename = "file";
        if (contentType.contains(filename + name)) {
            name = filename + name;
        }
        if ((endIndex = Integer.valueOf(contentType.indexOf(";", (int)(startIndex = Integer.valueOf(contentType.indexOf(name)))))).equals(-1)) {
            endIndex = contentType.length();
        }
        try {
            return contentType.substring(startIndex, endIndex).replaceAll(name, "").replaceAll("\"", "");
        }
        catch (StringIndexOutOfBoundsException e) {
            return "";
        }
    }

    public String getFilename() {
        String normName;
        if (this.filename == null) {
            return null;
        }
        try {
            normName = MimeUtility.decodeText((String)this.filename);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.info((Object)("Cannot decode filename: " + ex));
            normName = this.filename;
        }
        return normName;
    }

    public String getContentType() {
        if (this.contentType != null) {
            return this.contentType;
        }
        return null;
    }

    public String getContentDisposition() {
        if (this.contentDisposition != null) {
            return this.contentDisposition;
        }
        return null;
    }

    public int getSize() {
        return this.size;
    }
}

