/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.rest.utils.RepoMailTools;
import de.lwsystems.mailarchive.utils.ConversionUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class BennoInstanceId {
    private static final String instanceSalt = "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e";

    public static String createInstanceId(MailDocumentId mailDocumentId, IBox bennoBox) throws IOException, NoSuchAlgorithmException {
        ByteBuffer mailByteBuffer = ByteBuffer.allocate(8);
        mailByteBuffer.putLong(RepoMailTools.getLastModfiedDate(mailDocumentId, bennoBox).toMillis());
        MessageDigest instanceSha256MessageDigest = BennoInstanceId.createSha256MessageDigest(mailDocumentId.toString(), mailByteBuffer);
        MessageDigest instanceMd5MessageDigest = BennoInstanceId.createMd5MessageDigestFromSha256(instanceSha256MessageDigest);
        return ConversionUtil.fromBytesToHex((byte[])instanceMd5MessageDigest.digest());
    }

    public static String createInstanceInfo(String instanceId, FileTime creationTime) {
        return creationTime.toMillis() * 2L + ":" + instanceId;
    }

    private static MessageDigest createMd5MessageDigestFromSha256(MessageDigest sha256MessageDigest) throws NoSuchAlgorithmException {
        MessageDigest instanceMd5MessageDigest = MessageDigest.getInstance("MD5");
        instanceMd5MessageDigest.update(sha256MessageDigest.digest());
        return instanceMd5MessageDigest;
    }

    private static MessageDigest createSha256MessageDigest(String mailDocumentId, ByteBuffer mailByteBuffer) throws NoSuchAlgorithmException {
        MessageDigest instanceSha256MessageDigest = MessageDigest.getInstance("SHA-256");
        instanceSha256MessageDigest.update(mailDocumentId.getBytes());
        instanceSha256MessageDigest.update(mailByteBuffer.array());
        instanceSha256MessageDigest.update(instanceSalt.getBytes());
        return instanceSha256MessageDigest;
    }
}

