/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ConfiguredArchiveGenerator;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.rest.api.MultipartItem;
import de.lwsystems.mailarchive.rest.api.SearchError;
import de.lwsystems.mailarchive.rest.utils.JsonUtils;
import de.lwsystems.mailarchive.rest.utils.MimeUtils;
import de.lwsystems.mailarchive.rest.utils.ScidUtils;
import de.proite.mailarchive.rest.tools.ContentType;
import de.proite.mailarchive.rest.tools.JsonBuilder;
import de.proite.mailarchive.rest.tools.MimePartResolver;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.mail.BodyPart;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.json.JSONException;

public class BennoAttachmentServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(BennoAttachmentServlet.class);
    private final BennoRest bennoRest;
    private final Benno benno;

    public BennoAttachmentServlet(BennoRest bennoRest, Benno benno) {
        this.bennoRest = bennoRest;
        this.benno = benno;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doProccess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doProccess(request, response);
    }

    private void doProccess(HttpServletRequest request, HttpServletResponse response) {
        block40: {
            response.setContentType("application/json; charset=UTF-8");
            BennoConfig config = this.bennoRest.getBennoConfig();
            String searchArchive = request.getParameter("archive");
            String searchId = request.getParameter("id");
            String attachment = request.getParameter("attachment");
            String searchSCID = "";
            if (request.getParameter("scid") != null) {
                searchSCID = request.getParameter("scid");
            }
            Integer attachmentId = null;
            if (request.getParameterMap().containsKey("attachmentId")) {
                attachmentId = Integer.parseInt(request.getParameter("attachmentId"));
            }
            try {
                int bytesRead;
                IContainer myContainer = null;
                for (IArchive aktArchive : new ConfiguredArchiveGenerator(this.benno, config.getArchiveGenerator(), true).getArchives()) {
                    IContainerGenerator containerGen = aktArchive.getContainerGenerator();
                    try {
                        myContainer = containerGen.getContainer(searchArchive);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
                if (myContainer == null) {
                    throw new ContainerNotFoundException(searchArchive);
                }
                if (myContainer.isScidActive() && (!ScidUtils.isScidQueryValid(searchSCID) || searchSCID.equals(""))) {
                    throw new FileNotFoundException("SCID is active. Please add a correct SCID parameter to your query");
                }
                MailDocumentId documentId = new MailDocumentId(searchId, searchSCID);
                MailDocument myDoc = myContainer.getBox(documentId.getInternalBoxIndentifier()).getDocument(documentId);
                if (myDoc == null) {
                    throw new FileNotFoundException("Mail with id '" + searchId + "' not found!");
                }
                if (!myContainer.isScidActive() && !myDoc.getMetaData().getScid().equals("")) {
                    throw new FileNotFoundException("SCID is not active but the mail has a SCID parameter. Please active SCID in benno.xml");
                }
                MimeMultipart multipart = null;
                ArrayList<MultipartItem> attachmentList = new ArrayList<MultipartItem>();
                ArrayList<MultipartItem> bodyList = new ArrayList<MultipartItem>();
                if (!MimeUtils.getMimeMesage(myDoc).getContent().getClass().equals(String.class)) {
                    multipart = JsonBuilder.buildMimeMultipart(myDoc, multipart, attachmentList);
                }
                if (multipart != null) {
                    MimePartResolver.resolveMimeParts(multipart, attachmentList, bodyList, 0);
                }
                boolean found = false;
                for (MultipartItem tmp : attachmentList) {
                    try {
                        if (tmp.getAttachmentId().equals(attachmentId)) {
                            found = true;
                            continue;
                        }
                        if (!tmp.getName().equals(attachment)) continue;
                        found = true;
                    }
                    catch (JSONException ex) {
                        LOGGER.debug((Object)"MIME part without filename");
                    }
                    catch (NullPointerException ex) {
                        LOGGER.debug((Object)"MIME part is broken");
                    }
                }
                if (!found) {
                    response.resetBuffer();
                    response.setStatus(404);
                    try {
                        SearchError errResult = new SearchError();
                        errResult.setError("attachment not found");
                        JsonUtils.write(errResult, response.getWriter());
                        response.flushBuffer();
                    }
                    catch (Exception ex) {
                        LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
                    }
                }
                LOGGER.debug((Object)multipart);
                if (multipart != null) {
                    ArrayList<BodyPart> bodyParts = new ArrayList<BodyPart>();
                    MimePartResolver.getBodyPartList(multipart, bodyParts);
                    String fileName = "";
                    int attachmentCounter = 0;
                    for (BodyPart bodyPart : bodyParts) {
                        int bytesRead2;
                        try {
                            if (bodyPart.getFileName() == null) {
                                try {
                                    fileName = MimePartResolver.setNameToUnknownFile(bodyPart, attachmentCounter, bodyPart.getHeader("Content-Id")[0]);
                                }
                                catch (Exception e) {
                                    fileName = MimePartResolver.setNameToUnknownFile(bodyPart, attachmentCounter, "empty");
                                }
                            }
                            if (fileName != null && !fileName.equals("") || bodyPart.getFileName() != null && !bodyPart.getFileName().equals("") && attachmentId != null) {
                                if (!attachmentId.equals(attachmentCounter)) {
                                    ++attachmentCounter;
                                }
                            } else {
                                if (bodyPart.getFileName() == null || bodyPart.getFileName().equals("") || bodyPart.getFileName() != null && !bodyPart.getFileName().equalsIgnoreCase(attachment)) continue;
                                if (bodyPart.getDisposition() == null) {
                                }
                            }
                        }
                        catch (Exception ex) {}
                        continue;
                        response.resetBuffer();
                        response.setContentType(bodyPart.getContentType());
                        response.addHeader("Content-Disposition", "attachment; filename=" + attachment);
                        InputStream is = bodyPart.getInputStream();
                        byte[] buf = new byte[4096];
                        while ((bytesRead2 = is.read(buf)) != -1) {
                            response.getOutputStream().write(buf, 0, bytesRead2);
                        }
                        ++attachmentCounter;
                        LOGGER.debug((Object)(request.getSession().getId() + " Requested attachment '" + attachment + "' for mail id '" + searchId + "' - multipart: yes"));
                    }
                    break block40;
                }
                response.resetBuffer();
                String ct = ContentType.bareType(MimeUtils.getMimeMesage(myDoc).getContentType());
                response.setContentType(ct);
                response.addHeader("Content-Disposition", "attachment; filename=" + attachment);
                InputStream is = MimeUtils.getMimeMesage(myDoc).getInputStream();
                byte[] buf = new byte[4096];
                while ((bytesRead = is.read(buf)) != -1) {
                    response.getOutputStream().write(buf, 0, bytesRead);
                }
                LOGGER.debug((Object)(request.getSession().getId() + " Requested attachment '" + attachment + "' for mail id '" + searchId + "' - multipart: no"));
            }
            catch (ContainerNotFoundException ex) {
                try {
                    SearchError errResult = new SearchError();
                    errResult.setError("container not found");
                    JsonUtils.write(errResult, response.getWriter());
                }
                catch (Exception iex) {
                    LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)iex);
                }
                LOGGER.warn((Object)ex.getMessage());
            }
            catch (FileNotFoundException fnfe) {
                LOGGER.debug((Object)("File for ID '" + searchId + "' not found! Continer:" + searchArchive), (Throwable)fnfe);
                response.resetBuffer();
                response.setStatus(404);
                try {
                    SearchError errResult = new SearchError();
                    errResult.setError("file not found");
                    JsonUtils.write(errResult, response.getWriter());
                }
                catch (Exception ex) {
                    LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
            }
        }
    }
}

