/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.rest.servlets;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ConfiguredArchiveGenerator;
import de.lwsystems.mailarchive.archive.IArchive;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.archive.container.IContainerGenerator;
import de.lwsystems.mailarchive.config.BennoConfig;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.rest.BennoRest;
import de.lwsystems.mailarchive.rest.api.MailResult;
import de.lwsystems.mailarchive.rest.utils.JsonUtils;
import de.lwsystems.mailarchive.rest.utils.MimeUtils;
import de.lwsystems.mailarchive.rest.utils.ScidUtils;
import de.proite.mailarchive.rest.tools.JsonBuilder;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.ParseException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class BennoMailServlet
extends HttpServlet {
    private static final Logger LOGGER = Logger.getLogger(BennoMailServlet.class);
    private final BennoRest bennoRest;
    private final Benno benno;
    boolean debugEnabled = LOGGER.isDebugEnabled();

    public BennoMailServlet(BennoRest bennoRest, Benno benno) {
        this.bennoRest = bennoRest;
        this.benno = benno;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        this.doProccess(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) {
        this.doProccess(request, response);
    }

    private void doProccess(HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("text/plain;charset=UTF-8");
        response.setStatus(200);
        BennoConfig config = this.bennoRest.getBennoConfig();
        String searchArchive = request.getParameter("archive");
        String searchId = request.getParameter("id");
        String searchSCID = "";
        if (request.getParameter("scid") != null) {
            searchSCID = request.getParameter("scid");
        }
        String responseFormat = "maildata";
        boolean raw = false;
        boolean skipUtf8Recode = false;
        boolean onlyMailHeaders = false;
        ConfiguredArchiveGenerator archiveGenerator = new ConfiguredArchiveGenerator(this.benno, config.getArchiveGenerator(), true);
        if (request.getParameter("format") != null) {
            responseFormat = request.getParameter("format");
            if (responseFormat.equals("raw")) {
                raw = true;
                if (request.getParameter("skipUTF8Recode") != null && request.getParameter("skipUTF8Recode").equals("true")) {
                    skipUtf8Recode = true;
                }
            } else if (responseFormat.equals("headers")) {
                onlyMailHeaders = true;
            }
        }
        try {
            MailDocumentId documentId;
            IBox box;
            MailDocument myDoc;
            IContainer myContainer = null;
            for (IArchive aktArchive : archiveGenerator.getArchives()) {
                IContainerGenerator containerGen = aktArchive.getContainerGenerator();
                try {
                    myContainer = containerGen.getContainer(searchArchive);
                    String foundArch = aktArchive.getIdentifier();
                    break;
                }
                catch (Exception searchEx) {
                }
            }
            if (myContainer == null) {
                throw new ContainerNotFoundException(searchArchive);
            }
            if (myContainer.isScidActive() && (!ScidUtils.isScidQueryValid(searchSCID) || searchSCID.equals(""))) {
                throw new FileNotFoundException("SCID is active. Please add a correct SCID parameter to your query");
            }
            if (this.debugEnabled) {
                LOGGER.debug((Object)("Load email from repository " + searchId));
            }
            if ((myDoc = (box = myContainer.getBox((documentId = new MailDocumentId(searchId, searchSCID)).getInternalBoxIndentifier())).getDocument(documentId)) == null) {
                throw new FileNotFoundException("Mail with id '" + searchId + "' not found!");
            }
            if (!myContainer.isScidActive() && !myDoc.getMetaData().getScid().equals("")) {
                throw new FileNotFoundException("SCID is not active but the mail has a SCID parameter. Please active SCID in benno.xml");
            }
            if (raw) {
                this.buildRawResponse(response, skipUtf8Recode, myDoc);
            } else if (onlyMailHeaders) {
                this.buildHeadersOnlyJsonResponse(response, myDoc);
            } else {
                MailResult result = this.buildFullJsonResponse(response, myDoc);
                response.setContentType("application/json; charset=UTF-8");
                JsonUtils.write(result, response.getWriter());
            }
            LOGGER.debug((Object)("Client: '" + request.getRemoteAddr() + "' requested Mail '" + searchId + "' Archive: '" + searchArchive + "' Response: " + responseFormat + " and it was successfull!"));
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.debug((Object)("File for ID '" + searchId + "' not found! Continer:" + searchArchive), (Throwable)fnfe);
            response.resetBuffer();
            response.setStatus(404);
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"file not found");
                errResult.write((Writer)response.getWriter());
            }
            catch (Exception ex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
            }
        }
        catch (ContainerNotFoundException ex) {
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"container not found");
                errResult.write((Writer)response.getWriter());
            }
            catch (Exception iex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)iex);
            }
            LOGGER.warn((Object)ex.getMessage());
        }
        catch (ParseException ex) {
            try {
                JSONObject errResult = new JSONObject();
                errResult.put("error", (Object)"Could not parse mailfile");
                errResult.write((Writer)response.getWriter());
            }
            catch (Exception iex) {
                LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)iex);
            }
            LOGGER.warn((Object)("Could not parse mail with ID: " + searchId));
            LOGGER.warn((Object)ex.getMessage());
        }
        catch (Exception ex) {
            LOGGER.fatal((Object)"Uncaught Excpetion", (Throwable)ex);
        }
    }

    private void buildRawResponse(HttpServletResponse response, boolean skipUtf8Recode, MailDocument myDoc) throws MessagingException, IOException, UnsupportedEncodingException {
        CharsetMatch cm = this.detectCharset(myDoc);
        InputStream mailStream = myDoc.getMailStream();
        if (skipUtf8Recode) {
            IOUtils.copy((InputStream)mailStream, (OutputStream)response.getOutputStream());
        } else {
            InputStreamReader isr = cm != null ? new InputStreamReader(mailStream, cm.getName()) : new InputStreamReader(mailStream);
            BufferedReader br = new BufferedReader(isr);
            while (br.ready()) {
                response.getWriter().println(br.readLine());
            }
        }
    }

    private void buildHeadersOnlyJsonResponse(HttpServletResponse response, MailDocument myDoc) throws JSONException, IOException {
        Map<String, Object> result = JsonBuilder.createHeadersOnlyJsonDocument(myDoc);
        response.setContentType("application/json; charset=UTF-8");
        JsonUtils.write(result, response.getWriter());
    }

    private MailResult buildFullJsonResponse(HttpServletResponse response, MailDocument myDoc) throws JSONException, IOException, MessagingException {
        return JsonBuilder.createFullJsonDocument(myDoc);
    }

    private CharsetMatch detectCharset(MailDocument myDoc) throws MessagingException, IOException {
        CharsetMatch cm;
        CharsetDetector cd = new CharsetDetector();
        MimeUtils.getMimeMesage(myDoc).getEncoding();
        cd.setText(myDoc.getMailStream());
        try {
            cm = cd.detect();
        }
        catch (Exception ex) {
            LOGGER.warn((Object)"Cannot detect charset: ", (Throwable)ex);
            cm = null;
        }
        return cm;
    }
}

