/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.search.lucene;

import de.lwsystems.mailarchive.search.ISearchHit;
import de.proite.mailarchive.rest.tools.RecipientResolver;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;

public class LuceneSearchHit
implements ISearchHit {
    private Document hitDoc;
    private RecipientResolver rr;

    public LuceneSearchHit(Document hitDoc) {
        this.hitDoc = hitDoc;
        try {
            if (!this.hitDoc.get("From").contains("@")) {
                this.searchAndSortFromMailAddress();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rr = new RecipientResolver(hitDoc.getFieldables("To"), hitDoc.getFieldables("Cc"), hitDoc.getFieldables("Recipient"));
    }

    @Override
    public String[] getTo() {
        return this.rr.getToArray();
    }

    @Override
    public String[] getCc() {
        return this.rr.getCcArray();
    }

    @Override
    public String[] getBcc() {
        return this.rr.getBccArray();
    }

    @Override
    public Date getDate() {
        String dateString = this.hitDoc.get("Date") + "+0000";
        TimeZone tz = TimeZone.getDefault();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmZ");
        sdf.setTimeZone(tz);
        if (dateString != null) {
            try {
                return sdf.parse(dateString);
            }
            catch (ParseException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public String getSubject() {
        return this.hitDoc.get("Subject");
    }

    @Override
    public String getFrom() {
        return this.hitDoc.get("From");
    }

    @Override
    public String getId() {
        return this.hitDoc.get("id");
    }

    @Override
    public String hasAttachment() {
        if (this.hitDoc.get("hasAttachment") == null) {
            return "0";
        }
        return this.hitDoc.get("hasAttachment");
    }

    private void searchAndSortFromMailAddress() {
        Fieldable[] sender;
        for (Fieldable senderField : sender = this.hitDoc.getFieldables("From")) {
            if (senderField.stringValue().contains("@")) continue;
            Fieldable tempAddress = senderField;
            this.hitDoc.removeField("From");
            this.hitDoc.add(tempAddress);
        }
    }
}

