/*
 * Decompiled with CFR 0.152.
 */
package de.lwsystems.mailarchive.search.lucene;

import de.lwsystems.mailarchive.search.IStatsHit;
import de.lwsystems.mailarchive.search.IStatsResult;
import de.lwsystems.mailarchive.search.lucene.LuceneStatsHit;
import de.lwsystems.mailarchive.utils.ArrayRangeIterator;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;

public class LuceneStatsResult
implements IStatsResult {
    private ScoreDoc[] hits;
    private int overAll;
    private IndexSearcher isearcher;

    public LuceneStatsResult(ScoreDoc[] hits, int overAll, IndexSearcher isearcher) {
        this.hits = hits;
        this.isearcher = isearcher;
        this.overAll = overAll;
    }

    private <HIT extends IStatsHit> Iterable<HIT> getIterableHits(final int hitIndex, final int limit, boolean full) {
        return new Iterable<HIT>(){

            @Override
            public Iterator<HIT> iterator() {
                return ArrayRangeIterator.buildIterator((Object[])LuceneStatsResult.this.hits, (int)hitIndex, (int)limit, new ScoreHitTransformer());
            }
        };
    }

    @Override
    public Iterable<IStatsHit> getStatsHits(int hitIndex, int limit) {
        return this.getIterableHits(hitIndex, limit, false);
    }

    @Override
    public int getHitCount() {
        return this.hits.length;
    }

    @Override
    public Integer getOverallHitCount() {
        return this.overAll;
    }

    private class ScoreHitTransformer<HIT extends IStatsHit>
    implements ArrayRangeIterator.Transformer<ScoreDoc, HIT> {
        private ScoreHitTransformer() {
        }

        public HIT transform(ScoreDoc scoreDoc) {
            try {
                Document hitDoc = LuceneStatsResult.this.isearcher.doc(scoreDoc.doc);
                return (HIT)new LuceneStatsHit(hitDoc);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

