/*
 * Decompiled with CFR 0.152.
 */
package de.proite.mailarchive.rest.tools;

import de.lwsystems.mailarchive.Benno;
import de.lwsystems.mailarchive.archive.ArchiveException;
import de.lwsystems.mailarchive.archive.box.IBox;
import de.lwsystems.mailarchive.archive.box.MailDocumentId;
import de.lwsystems.mailarchive.archive.container.ContainerNotFoundException;
import de.lwsystems.mailarchive.archive.container.IContainer;
import de.lwsystems.mailarchive.config.FSBoxStorageConfig;
import de.lwsystems.mailarchive.maildocument.Header;
import de.lwsystems.mailarchive.maildocument.MailDocument;
import de.lwsystems.mailarchive.rest.servlets.ServletTools;
import de.lwsystems.mailarchive.search.BadRequestException;
import de.lwsystems.mailarchive.search.IEmailIndex;
import de.lwsystems.mailarchive.search.IFullSearchHit;
import de.lwsystems.mailarchive.search.ISearchResult;
import de.lwsystems.mailarchive.search.NoSuchObjectException;
import de.lwsystems.mailarchive.search.lucene.LuceneEmailIndex;
import de.lwsystems.mailarchive.utils.BennoBuildTime;
import de.lwsystems.mailarchive.utils.CompressionUtil;
import de.lwsystems.mailarchive.utils.ConversionUtil;
import de.lwsystems.mailarchive.utils.InitizalizationMail;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.lucene.queryParser.ParseException;

public class BennoLicenseInstance {
    private final String licenseKeyHeader = "X-BENNO-System-Recipient";
    private final String searchContainer = "SYSDATA";
    private final String instanceSalt = "cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e";
    private IContainer myContainer;
    private IEmailIndex index;
    private Benno benno;

    public BennoLicenseInstance(Benno benno) throws ContainerNotFoundException {
        this.benno = benno;
        this.myContainer = ServletTools.getContainer("SYSDATA", this.benno);
        this.index = new LuceneEmailIndex(this.myContainer, "SYSDATA");
    }

    public String getInstanceId() throws ArchiveException, ContainerNotFoundException, IOException, NoSuchAlgorithmException {
        Iterable<IFullSearchHit> hits;
        try {
            hits = this.getMailListResult("(From:*@* To:*@* Recipient:*@* Sender:*@*)").getFullHits(0, 100000);
        }
        catch (Exception nso) {
            return "";
        }
        return this.iterateMailHits(hits, this.myContainer);
    }

    private ISearchResult getMailListResult(String query) throws BadRequestException, ParseException, IOException {
        ISearchResult result = null;
        try {
            result = this.index.search("License", "IndexTS", query, "(From:*@* To:*@* Recipient:*@* Sender:*@*)", 0L, false);
        }
        catch (NoSuchObjectException nso) {
            return null;
        }
        return result;
    }

    private String iterateMailHits(Iterable<IFullSearchHit> hits, IContainer container) throws ArchiveException, IOException, NoSuchAlgorithmException {
        for (IFullSearchHit hit : hits) {
            Header[] ausgabe;
            MailDocumentId documentId = new MailDocumentId(hit.getId(), "");
            IBox box = container.getBox(documentId.getInternalBoxIndentifier());
            MailDocument myDoc = box.getDocument(documentId);
            for (Header header : ausgabe = myDoc.getMetaData().getHeaders()) {
                if (!header.getName().equalsIgnoreCase("X-BENNO-System-Recipient")) continue;
                return this.findLicenseInstanceIdMail(myDoc, hit, box);
            }
        }
        return "";
    }

    private String findLicenseInstanceIdMail(MailDocument myDoc, IFullSearchHit hit, IBox box) throws IOException, NoSuchAlgorithmException {
        IBox.CompressionType compression = box.getBoxConfig().getCompression();
        String repoPath = box.getRepoPath() + "/" + box.getIdentifier();
        FSBoxStorageConfig sysBoxStorageConfig = (FSBoxStorageConfig)box.getBoxConfig().getBoxStorageConfig();
        MailDocumentId documentId = new MailDocumentId(hit.getId(), "");
        int separatorIndex = documentId.toString().indexOf(":");
        String instanceIdMailChecksum = documentId.toString().substring(separatorIndex + 1);
        for (int i = 0; i < sysBoxStorageConfig.getDirLength() * sysBoxStorageConfig.getSubdirs(); i += sysBoxStorageConfig.getDirLength()) {
            repoPath = repoPath + "/" + instanceIdMailChecksum.substring(0, sysBoxStorageConfig.getDirLength());
            instanceIdMailChecksum = instanceIdMailChecksum.substring(sysBoxStorageConfig.getDirLength(), instanceIdMailChecksum.length());
        }
        repoPath = repoPath + "/" + instanceIdMailChecksum + CompressionUtil.getCompressionSuffix((IBox.CompressionType)compression);
        Path licenseInstanceIdMail = Paths.get(repoPath, new String[0]);
        return this.createInstanceIdKey(hit, licenseInstanceIdMail);
    }

    private String createInstanceIdKey(IFullSearchHit hit, Path InstanceIdMailPath) throws NoSuchAlgorithmException, IOException {
        MessageDigest instanceSha256MessageDigest = MessageDigest.getInstance("SHA-256");
        MessageDigest instanceMd5MessageDigest = MessageDigest.getInstance("MD5");
        if (Files.exists(InstanceIdMailPath, new LinkOption[0])) {
            BasicFileAttributes attr = Files.readAttributes(InstanceIdMailPath, BasicFileAttributes.class, new LinkOption[0]);
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(attr.lastModifiedTime().toMillis());
            instanceSha256MessageDigest.update(hit.getId().getBytes());
            instanceSha256MessageDigest.update(buffer.array());
        }
        instanceSha256MessageDigest.update("cf83e1357eefb8bdf1542850d66d8007d620e4050b5715dc83f4a921d36ce9ce47d0d13c5d85f2b0ff8318d2877eec2f63b931bd47417a81a538327af927da3e".getBytes());
        instanceMd5MessageDigest.update(instanceSha256MessageDigest.digest());
        String instanceId = ConversionUtil.fromBytesToHex((byte[])instanceMd5MessageDigest.digest());
        return instanceId;
    }

    public void initializeNewInstallationMail() {
        try {
            String query = "(From:*@* To:*@* Recipient:*@* Sender:*@*) AND (HEADER-X-BENNO-CORE-VERSION:" + BennoBuildTime.coreBuildTime() + " AND HEADER-X-BENNO-REST-VERSION:" + BennoBuildTime.restBuildTime() + ")";
            ISearchResult result = this.index.search("License", "IndexTS", query, "(From:*@* To:*@* Recipient:*@* Sender:*@*)", 0L, false);
            if (result.getHitCount() < 1) {
                InitizalizationMail.createInitializationMailMessage((Benno)this.benno);
            }
        }
        catch (Exception nso) {
            InitizalizationMail.createInitializationMailMessage((Benno)this.benno);
        }
    }
}

