/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.j2se6;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JettyHttpExchange
extends HttpExchange {
    private HttpContext _context;
    private HttpServletRequest _req;
    private HttpServletResponse _resp;
    private Headers _responseHeaders = new Headers();
    private int _responseCode = 0;
    private InputStream _is;
    private OutputStream _os;
    private HttpPrincipal _principal;

    public JettyHttpExchange(HttpContext context, HttpServletRequest req, HttpServletResponse resp) {
        this._context = context;
        this._req = req;
        this._resp = resp;
        try {
            this._is = req.getInputStream();
            this._os = resp.getOutputStream();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Headers getRequestHeaders() {
        Headers headers = new Headers();
        Enumeration en = this._req.getHeaderNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            Enumeration en2 = this._req.getHeaders(name);
            while (en2.hasMoreElements()) {
                String value = (String)en2.nextElement();
                headers.add(name, value);
            }
        }
        return headers;
    }

    @Override
    public Headers getResponseHeaders() {
        return this._responseHeaders;
    }

    @Override
    public URI getRequestURI() {
        try {
            String uriAsString = this._req.getRequestURI();
            if (this._req.getQueryString() != null) {
                uriAsString = uriAsString + "?" + this._req.getQueryString();
            }
            return new URI(uriAsString);
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getRequestMethod() {
        return this._req.getMethod();
    }

    @Override
    public HttpContext getHttpContext() {
        return this._context;
    }

    @Override
    public void close() {
        try {
            this._resp.getOutputStream().close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public InputStream getRequestBody() {
        return this._is;
    }

    @Override
    public OutputStream getResponseBody() {
        return this._os;
    }

    @Override
    public void sendResponseHeaders(int rCode, long responseLength) throws IOException {
        this._responseCode = rCode;
        for (Map.Entry<String, List<String>> entry : this._responseHeaders.entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            for (int i = 0; i < values.size(); ++i) {
                String value = values.get(i);
                this._resp.setHeader(name, value);
            }
        }
        if (responseLength > 0L) {
            this._resp.setHeader("content-length", "" + responseLength);
        }
        this._resp.setStatus(rCode);
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return new InetSocketAddress(this._req.getRemoteAddr(), this._req.getRemotePort());
    }

    @Override
    public int getResponseCode() {
        return this._responseCode;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return new InetSocketAddress(this._req.getLocalAddr(), this._req.getLocalPort());
    }

    @Override
    public String getProtocol() {
        return this._req.getProtocol();
    }

    @Override
    public Object getAttribute(String name) {
        return this._req.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this._req.setAttribute(name, value);
    }

    @Override
    public void setStreams(InputStream i, OutputStream o) {
        this._is = i;
        this._os = o;
    }

    @Override
    public HttpPrincipal getPrincipal() {
        return this._principal;
    }

    public void setPrincipal(HttpPrincipal principal) {
        this._principal = principal;
    }
}

