/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.j2se6;

import com.sun.net.httpserver.Authenticator;
import com.sun.net.httpserver.Filter;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpPrincipal;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.j2se6.JettyHttpExchange;

public class J2SE6ContextHandler
extends ContextHandler {
    private HttpContext _context;
    private HttpHandler _handler;

    public J2SE6ContextHandler(HttpContext context, HttpHandler handler) {
        this._context = context;
        this._handler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, HttpServletRequest req, HttpServletResponse resp, int dispatch) throws IOException, ServletException {
        block11: {
            if (!target.startsWith(this.getContextPath())) {
                return;
            }
            JettyHttpExchange jettyHttpExchange = new JettyHttpExchange(this._context, req, resp);
            try {
                Authenticator auth = this._context.getAuthenticator();
                if (auth != null) {
                    Authenticator.Result authResult = auth.authenticate(jettyHttpExchange);
                    if (authResult instanceof Authenticator.Success) {
                        HttpPrincipal p = ((Authenticator.Success)authResult).getPrincipal();
                        jettyHttpExchange.setPrincipal(p);
                        this.invokeHandler(jettyHttpExchange);
                    } else if (authResult instanceof Authenticator.Failure) {
                        int rc = ((Authenticator.Failure)authResult).getResponseCode();
                        resp.sendError(rc);
                    } else if (authResult instanceof Authenticator.Retry) {
                        int rc = ((Authenticator.Retry)authResult).getResponseCode();
                        resp.sendError(rc);
                    }
                    break block11;
                }
                this.invokeHandler(jettyHttpExchange);
            }
            catch (Exception ex) {
                try {
                    PrintWriter writer = new PrintWriter(jettyHttpExchange.getResponseBody());
                    resp.setStatus(500);
                    writer.println("<h2>HTTP ERROR: 500</h2>");
                    writer.println("<pre>INTERNAL_SERVER_ERROR</pre>");
                    writer.println("<p>RequestURI=" + req.getRequestURI() + "</p>");
                    writer.println("<pre>");
                    ex.printStackTrace(writer);
                    writer.println("</pre>");
                    writer.println("<p><i><small><a href=\"http://jetty.mortbay.org\">Powered by jetty://</a></small></i></p>");
                    writer.close();
                }
                catch (Throwable throwable) {
                    Request base_request = req instanceof Request ? (Request)req : HttpConnection.getCurrentConnection().getRequest();
                    base_request.setHandled(true);
                    throw throwable;
                }
                Request base_request = req instanceof Request ? (Request)req : HttpConnection.getCurrentConnection().getRequest();
                base_request.setHandled(true);
            }
        }
        Request base_request = req instanceof Request ? (Request)req : HttpConnection.getCurrentConnection().getRequest();
        base_request.setHandled(true);
    }

    protected void invokeHandler(JettyHttpExchange exchange) throws IOException {
        List<Filter> filters = this._context.getFilters();
        if (filters != null && filters.size() > 0) {
            ArrayList<Filter> copy = new ArrayList<Filter>(filters.subList(1, filters.size()));
            Filter.Chain chain = new Filter.Chain(copy, this._handler);
            filters.get(0).doFilter(exchange, chain);
        } else {
            this._handler.handle(exchange);
        }
    }

    public HttpHandler getHttpHandler() {
        return this._handler;
    }

    public void setHttpHandler(HttpHandler handler) {
        this._handler = handler;
    }
}

