/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.j2se6;

import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandler;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.handler.DefaultHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.j2se6.J2SE6ContextHandler;
import org.mortbay.jetty.j2se6.JettyHttpContext;
import org.mortbay.jetty.j2se6.ThreadPoolExecutorAdapter;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.log.Log;
import org.mortbay.thread.ThreadPool;

public class JettyHttpServer
extends HttpServer {
    private Server _server = new Server();
    private ContextHandlerCollection _contextCollection;
    private InetSocketAddress _addr;
    private ThreadPoolExecutor _executor;
    private boolean _started = false;

    public JettyHttpServer() {
        HandlerCollection handlerCollection = new HandlerCollection();
        this._contextCollection = new ContextHandlerCollection();
        handlerCollection.setHandlers(new Handler[]{this._contextCollection, new DefaultHandler()});
        this._server.setHandler((Handler)handlerCollection);
    }

    @Override
    public void bind(InetSocketAddress addr, int backlog) throws IOException {
        if (this._started) {
            throw new BindException("Already started");
        }
        Connector[] connectors = this._server.getConnectors();
        if (connectors != null) {
            throw new BindException("Server already bound");
        }
        this._addr = addr;
        if (this._executor != null && this._server.getThreadPool() == null) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)"using given Executor for server thread pool");
            }
            this._server.setThreadPool((ThreadPool)new ThreadPoolExecutorAdapter(this._executor));
        }
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setAcceptors(1);
        connector.setAcceptQueueSize(backlog);
        connector.setPort(addr.getPort());
        connector.setHost(addr.getHostName());
        this._server.addConnector((Connector)connector);
    }

    @Override
    public InetSocketAddress getAddress() {
        return this._addr;
    }

    @Override
    public void start() {
        if (this._started) {
            throw new IllegalStateException("Already started");
        }
        try {
            this._server.start();
            this._started = true;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void setExecutor(Executor executor) {
        if (this._started) {
            throw new IllegalStateException("Server started");
        }
        if (!(executor instanceof ThreadPoolExecutor)) {
            throw new IllegalArgumentException("only ThreadPoolExecutor are allowed");
        }
        this._executor = (ThreadPoolExecutor)executor;
    }

    @Override
    public Executor getExecutor() {
        return this._executor;
    }

    @Override
    public void stop(int delay) {
        if (delay < 0) {
            throw new IllegalStateException("Delay is negative");
        }
        this._server.setGracefulShutdown(delay * 1000);
        try {
            this._server.stop();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public HttpContext createContext(String path, HttpHandler handler) {
        this.checkIfContextIsFree(path);
        JettyHttpContext context = new JettyHttpContext(this, path, handler);
        J2SE6ContextHandler jettyContextHandler = context.getJettyContextHandler();
        this._contextCollection.addHandler((Handler)jettyContextHandler);
        return context;
    }

    private void checkIfContextIsFree(String path) {
        Handler[] handlers = this._contextCollection.getChildHandlersByClass(ContextHandler.class);
        for (int i = 0; handlers != null && i < handlers.length; ++i) {
            ContextHandler ctx = (ContextHandler)handlers[i];
            if (!ctx.getContextPath().equals(path)) continue;
            throw new IllegalArgumentException("another context already bound to path " + path);
        }
    }

    @Override
    public HttpContext createContext(String path) {
        return this.createContext(path, null);
    }

    @Override
    public void removeContext(String path) throws IllegalArgumentException {
        ContextHandler handler = null;
        Handler[] handlers = this._contextCollection.getChildHandlersByClass(ContextHandler.class);
        for (int i = 0; handlers != null && i < handlers.length && handler == null; ++i) {
            ContextHandler ctx = (ContextHandler)handlers[i];
            if (!ctx.getContextPath().equals(path)) continue;
            handler = ctx;
        }
        if (handler != null) {
            this._contextCollection.removeHandler(handler);
        }
    }

    @Override
    public void removeContext(HttpContext context) {
        this.removeContext(context.getPath());
    }
}

